/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.payment.pay.ali.model.AlipayTradeWebRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayWebPayResult;
import com.tydic.payment.pay.ali.model.ExtendParams;
import com.tydic.payment.pay.ali.service.impl.AlipayWebPayServiceImpl;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.AliWebPayBusiService;
import com.tydic.payment.pay.busi.bo.AliWebPayReqBo;
import com.tydic.payment.pay.busi.bo.AliWebPayRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=AliWebPayBusiService.class)
public class AliWebPayBusiServiceImpl
implements AliWebPayBusiService {
    private static final Logger log = LoggerFactory.getLogger(AliWebPayBusiServiceImpl.class);
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public AliWebPayRspBo dealAliWebPay(AliWebPayReqBo pmcAliWebPayReqBo) {
        if (pmcAliWebPayReqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pmcAliWebPayReqBo.getOrderId() == 0L) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d orderId\u80fd\u4e3a\u7a7a");
        }
        if (pmcAliWebPayReqBo.getMerchantId() == 0L) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d merchantId\u80fd\u4e3a\u7a7a");
        }
        if (pmcAliWebPayReqBo.getParamMap().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pmcAliWebPayReqBo.getTotalFee() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u91d1\u989d\u80fd\u4e3a\u7a7a");
        }
        AliWebPayRspBo pmcAliWebPayRspBo = new AliWebPayRspBo();
        try {
            PorderPo pOrder = this.payOrderAtomService.queryPorderInfo(pmcAliWebPayReqBo.getOrderId());
            if (pOrder == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            if ("A10".equals(pOrder.getOrderStatus())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8");
            }
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setOrderId(pOrder.getOrderId());
            orderPayTransAtomReq.setBusiId(pOrder.getBusiId());
            orderPayTransAtomReq.setMerchantId(pOrder.getMerchantId());
            orderPayTransAtomReq.setOrderStatus(pOrder.getOrderStatus());
            orderPayTransAtomReq.setPayMethod(Long.parseLong("21"));
            orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(pOrder.getTotalFee())));
            String outTradeNo = this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
            String notifyUrl = this.payPropertiesVo.getAliNotifyUrl();
            String returnUrl = pOrder.getRedirectUrl();
            String totalAmount = MoneyUtils.fenToYuan((BigDecimal)pmcAliWebPayReqBo.getTotalFee()).toString();
            String body = pOrder.getDetailName();
            ExtendParams extendParams = null;
            String timeoutExpress = "2m";
            AlipayTradeWebRequestBuilder alipayTradeWebRequestBuilder = new AlipayTradeWebRequestBuilder().setOutTradeNo(outTradeNo).setSubject(body).setTotalAmount(totalAmount).setBody(body).setExtendParams(extendParams).setTimeoutExpress(timeoutExpress).setNotifyUrl(notifyUrl).setRerutnUrl(returnUrl);
            AlipayWebPayServiceImpl service = new AlipayWebPayServiceImpl.ClientBuilder().build(String.valueOf(pmcAliWebPayReqBo.getParamMap().get("appid")), String.valueOf(pmcAliWebPayReqBo.getParamMap().get("privateKey")), String.valueOf(pmcAliWebPayReqBo.getParamMap().get("publicKey")));
            AlipayWebPayResult result = service.webPay(alipayTradeWebRequestBuilder);
            if (result == null) {
                pmcAliWebPayRspBo.setRspCode("8888");
                pmcAliWebPayRspBo.setRspName("\u652f\u4ed8\u5b9d\u4e0b\u5355\u5931\u8d25");
                return pmcAliWebPayRspBo;
            }
            log.info("Body" + result.getResponse().getBody());
            if (result.getResponse() == null) {
                pmcAliWebPayRspBo.setPayStatus("FAIL");
            }
            if (result.getResponse().getBody() != null) {
                pmcAliWebPayRspBo.setPayStatus("SUCCESS");
                pmcAliWebPayRspBo.setBody(result.getResponse().getBody());
                pmcAliWebPayRspBo.setRspName("\u8c03\u7528\u652f\u4ed8\u5b9d\u6210\u529f");
            }
            if (result.getResponse().getErrorCode() != null) {
                pmcAliWebPayRspBo.setPayStatus("FAIL");
                pmcAliWebPayRspBo.setRspName(result.getResponse().getMsg());
            }
            pmcAliWebPayRspBo.setRspCode("0000");
            pmcAliWebPayRspBo.setRspName("\u652f\u4ed8\u5b9d\u4e0b\u5355\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            pmcAliWebPayRspBo.setRspCode("8888");
            pmcAliWebPayRspBo.setRspName("\u8c03\u7528\u652f\u4ed8\u5b9d\u7535\u8111\u652f\u4ed8\u5f02\u5e38");
        }
        return pmcAliWebPayRspBo;
    }
}

