/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.BusiSystemMerchantRelAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAttrAtomService;
import com.tydic.payment.pay.busi.BusiPaymentMerchantDeleteBusiService;
import com.tydic.payment.pay.busi.DeleteInfoMechartService;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantDeleteBusiReqBO;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantDeleteBusiRspBO;
import com.tydic.payment.pay.busi.bo.DeleteInfoMechartReqBo;
import com.tydic.payment.pay.busi.bo.DeleteInfoMechartRspBo;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.PayParaInfoPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deleteInfoMechartService")
public class DeleteInfoMechartServiceImpl
implements DeleteInfoMechartService {
    private static final Logger log = LoggerFactory.getLogger(DeleteInfoMechartServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private BusiSystemMerchantRelAtomService busiSystemMerchantRelAtomService;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;
    @Autowired
    private PayParaInfoAtomService payParaInfoAtomService;
    @Autowired
    private PayParaInfoAttrAtomService payParaInfoAttrAtomService;
    @Autowired
    private BusiPaymentMerchantDeleteBusiService busiPaymentMerchantDeleteBusiService;

    public DeleteInfoMechartRspBo deleteInfoMechart(DeleteInfoMechartReqBo bo) {
        log.info("\u5220\u9664\u5546\u6237\u4fe1\u606f\u5165\u53c2\uff1a" + bo);
        this.validateArg(bo);
        String merchantId = bo.getMerchantId();
        DeleteInfoMechartRspBo retBo = new DeleteInfoMechartRspBo();
        MerChantInfoPo qryMPo = new MerChantInfoPo();
        qryMPo.setMerchantId(Long.valueOf(merchantId));
        List<MerChantInfoPo> queryMerChantInfoByCondition = this.merchantInfoAtomService.queryMerChantInfoByCondition(qryMPo);
        if (queryMerChantInfoByCondition.isEmpty()) {
            log.error("\u5220\u9664\u5546\u6237\u670d\u52a1\u51fa\u9519\uff1a\u8be5\u5546\u6237\u4e0d\u5b58\u5728");
            retBo.setRspCode("8888");
            retBo.setRspName("\u5220\u9664\u5546\u6237\u670d\u52a1\u51fa\u9519\uff1a\u8be5\u5546\u6237(" + merchantId + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        BusiSystemMerchantRelPo delMBRelPo = new BusiSystemMerchantRelPo();
        delMBRelPo.setMerchantId(Long.valueOf(merchantId));
        this.busiSystemMerchantRelAtomService.deleteBusiSystemMerchantRelByMerchant(delMBRelPo);
        BusiPaymentMerchantDeleteBusiReqBO deleteRelBo = new BusiPaymentMerchantDeleteBusiReqBO();
        deleteRelBo.setMerchantId(Long.valueOf(merchantId));
        BusiPaymentMerchantDeleteBusiRspBO delete = this.busiPaymentMerchantDeleteBusiService.delete(deleteRelBo);
        if (!"0000".equals(delete.getRspCode())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5220\u9664\u4e1a\u52a1\u5546\u6237-\u652f\u4ed8\u5546\u6237");
        }
        MerchantPayMethodRelPo qryMPRelPo = new MerchantPayMethodRelPo();
        qryMPRelPo.setMerchantId(Long.valueOf(merchantId));
        List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(qryMPRelPo);
        for (MerchantPayMethodRelPo mppo : queryMerchantPayMethodRelByCondition) {
            Long payParaId = mppo.getPayParaId();
            PayParaInfoAttrPo delAttrPo = new PayParaInfoAttrPo();
            delAttrPo.setPayParaId(payParaId);
            this.payParaInfoAttrAtomService.deletePayParaInfoAttrByParaId(delAttrPo);
            PayParaInfoPo delParaPo = new PayParaInfoPo();
            delParaPo.setPayParaId(payParaId);
            this.payParaInfoAtomService.deletePayParaInfo(delParaPo);
        }
        MerchantPayMethodRelPo delMerId = new MerchantPayMethodRelPo();
        delMerId.setMerchantId(Long.valueOf(merchantId));
        this.merchantPayMethodRelAtomService.deleteMerchantPayMethodRelByMerchantId(delMerId);
        MerChantInfoPo delMerPo = new MerChantInfoPo();
        delMerPo.setMerchantId(Long.valueOf(merchantId));
        this.merchantInfoAtomService.deleteMerChantInfo(delMerPo);
        retBo.setRspCode("0000");
        retBo.setRspName("\u5220\u9664\u5546\u6237\u6210\u529f");
        return retBo;
    }

    private void validateArg(DeleteInfoMechartReqBo bo) {
        if (bo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getMerchantId() == null || bo.getMerchantId().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027MerchantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

