/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.GdBank4PayBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PaymentGdBankReqBo;
import com.tydic.payment.pay.busi.bo.PaymentGdBankRspBo;
import com.tydic.payment.pay.common.util.HttpUtil;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PorderDetallMapper;
import com.tydic.payment.pay.dao.po.PorderDetallPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.BankPayUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="gdBank4PayBusiService")
public class GdBank4PayBusiServiceImpl
implements GdBank4PayBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GdBank4PayBusiServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PorderDetallMapper porderDetallMapper;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public PaymentGdBankRspBo dealGdBankPay(PaymentGdBankReqBo reqBo) {
        boolean flag;
        PorderPayTransAtomReqBo orderPayTransAtomReq;
        String outTradeNo;
        String timeEnd;
        String numberName;
        String banknumber;
        String merid;
        String key;
        List<PorderDetallPo> goods;
        PorderPo orderInfo;
        PaymentGdBankRspBo rspBo;
        block19: {
            rspBo = new PaymentGdBankRspBo();
            orderInfo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(reqBo.getOrderId()));
            if (orderInfo == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + reqBo.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
            }
            PorderDetallPo good = new PorderDetallPo();
            good.setOrderId(orderInfo.getOrderId());
            goods = null;
            try {
                goods = this.porderDetallMapper.getList(good);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            key = reqBo.getParamMap().get("key") + "";
            merid = reqBo.getParamMap().get("merid") + "";
            banknumber = reqBo.getParamMap().get("banknumber") + "";
            numberName = reqBo.getParamMap().get("numbername") + "";
            timeEnd = "180";
            outTradeNo = "";
            orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            flag = true;
            if (!StringUtils.isEmpty((Object)orderInfo.getOutRemark())) {
                outTradeNo = orderInfo.getOutRemark();
                try {
                    orderPayTransAtomReq.setPayOrderId(outTradeNo);
                    PorderPayTransAtomRspBo porderPayTransAtomRspBo = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(orderPayTransAtomReq);
                    if (porderPayTransAtomRspBo == null) {
                        orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
                        orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
                        orderPayTransAtomReq.setMerchantId(Long.parseLong(reqBo.getMerchantId()));
                        orderPayTransAtomReq.setPayMethod(Long.parseLong("120"));
                        orderPayTransAtomReq.setOrderStatus("A00");
                        orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)reqBo.getTotalFee()));
                        orderPayTransAtomReq.setTransMerchant(merid);
                        orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)reqBo.getTotalFee()));
                        break block19;
                    }
                    if (porderPayTransAtomRspBo != null && !"A10".equals(porderPayTransAtomRspBo.getOrderStatus())) {
                        flag = false;
                        break block19;
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355id\u3010ORDER_ID=" + reqBo.getOrderId() + "\u3011\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            } else {
                orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
                orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
                orderPayTransAtomReq.setMerchantId(Long.parseLong(reqBo.getMerchantId()));
                orderPayTransAtomReq.setPayMethod(Long.parseLong("120"));
                orderPayTransAtomReq.setOrderStatus("A00");
                orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)reqBo.getTotalFee()));
                orderPayTransAtomReq.setTransMerchant(merid);
            }
        }
        if (flag) {
            try {
                outTradeNo = this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        JSONObject jo = new JSONObject(new LinkedHashMap());
        jo.put("ordernumber", (Object)outTradeNo);
        jo.put("ordertime", (Object)this.simpleDateFormat.format(this.queryDBDateBusiService.getDBDate()));
        jo.put("merid", (Object)merid);
        jo.put("paytype", (Object)"weixin");
        jo.put("transtype", (Object)"0000");
        jo.put("signmethon", (Object)"md5");
        jo.put("charset", (Object)"utf8");
        jo.put("notifyurl", (Object)this.payPropertiesVo.getGdBankPayNotifyUrl());
        jo.put("backurl", (Object)this.payPropertiesVo.getGdBankPayNotifyUrl());
        jo.put("amount", (Object)reqBo.getTotalFee());
        jo.put("customerip", (Object)orderInfo.getCreateIpAddress());
        jo.put("remark1", (Object)timeEnd);
        jo.put("remark2", (Object)orderInfo.getDetailName());
        jo.put("remark3", (Object)orderInfo.getOrderAttrValue1());
        jo.put("remark4", (Object)orderInfo.getOrderAttrValue2());
        jo.put("remark5", (Object)orderInfo.getOrderAttrValue3());
        jo.put("remark6", (Object)"");
        jo.put("remark7", (Object)"");
        jo.put("remark8", (Object)"");
        jo.put("remark9", (Object)"");
        jo.put("remark10", (Object)"");
        jo.put("remark11", (Object)"");
        jo.put("remark12", (Object)"");
        JSONArray dataArray = new JSONArray(new LinkedList());
        JSONObject dataObj1 = new JSONObject(new LinkedHashMap());
        dataObj1.put("banknumber", (Object)banknumber);
        dataObj1.put("numbername", (Object)numberName);
        dataObj1.put("remark1", (Object)"");
        dataObj1.put("remark2", (Object)"");
        JSONArray listArray = new JSONArray(new LinkedList());
        JSONObject listObj1 = new JSONObject(new LinkedHashMap());
        if (goods == null || goods.size() == 0) {
            listObj1.put("title", (Object)orderInfo.getDetailName());
            listObj1.put("id", (Object)"11111");
            listObj1.put("category_name", (Object)"");
            listObj1.put("price", (Object)reqBo.getTotalFee());
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            listObj1.put("suborderid", (Object)uuid);
            listObj1.put("remark1", (Object)"");
            listObj1.put("remark2", (Object)"");
            listArray.add((Object)listObj1);
        } else {
            for (PorderDetallPo po : goods) {
                listObj1.put("title", (Object)orderInfo.getDetailName());
                listObj1.put("id", (Object)po.getGoodsId());
                listObj1.put("category_name", (Object)"");
                listObj1.put("price", (Object)MoneyUtils.haoToFen((Long)po.getGoodsFee()).intValue());
                String uuid = UUID.randomUUID().toString().replaceAll("-", "");
                listObj1.put("suborderid", (Object)uuid);
                listObj1.put("remark1", (Object)"");
                listObj1.put("remark2", (Object)"");
                listArray.add((Object)listObj1);
            }
        }
        dataObj1.put("list", (Object)listArray);
        dataArray.add((Object)dataObj1);
        jo.put("data", (Object)dataArray);
        LOGGER.info("data:" + dataArray);
        String sign = BankPayUtil.generateSignature(key, jo.toString());
        LOGGER.info("sign:" + sign);
        LOGGER.info("\u8bf7\u6c42\u62a5\u6587\uff1aresult=" + JSONObject.toJSONString((Object)jo) + sign);
        LOGGER.info("\u8bf7\u6c42\u5730\u5740\uff1a" + this.payPropertiesVo.getGdBankPay4Url());
        String result = "";
        LOGGER.info("\u8c03\u7528\u5149\u5927\u94f6\u884c\u5165\u53c2\uff1a" + jo.toJSONString());
        try {
            result = HttpUtil.sendRequest((String)("result=" + JSONObject.toJSONString((Object)jo) + sign), (String)this.payPropertiesVo.getGdBankPay4Url(), (String)"POST", (String)"UTF-8");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.info("\u8c03\u7528\u5149\u5927\u94f6\u884c\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        if (result.startsWith("https://")) {
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u6210\u529f");
            rspBo.setPayStatus("PAYING");
            rspBo.setQrCode(result);
            rspBo.setPayOrderId(outTradeNo);
            rspBo.setEffectiveSeconds(timeEnd);
        } else {
            JSONObject err = JSONObject.parseObject((String)result);
            rspBo.setRspCode("8888");
            rspBo.setRspName(err.getString("info"));
        }
        return rspBo;
    }
}

