/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.AbilityToPayPlatformService;
import com.tydic.payment.pay.busi.WXOrderQueryBusiService;
import com.tydic.payment.pay.busi.WXPayApiBusiService;
import com.tydic.payment.pay.common.util.ParseAbilityResponse;
import com.tydic.payment.pay.common.util.ParseInfo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.wx.req.bo.WXApiOrderQueryReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiOrderQueryRspBO;
import com.tydic.payment.pay.wx.util.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="wXOrderQueryBusiService")
public class WXOrderQueryBusiServiceImpl
implements WXOrderQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(WXOrderQueryBusiServiceImpl.class);
    @Autowired
    private WXPayApiBusiService wXPayApiBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private AbilityToPayPlatformService abilityToPayPlatformService;

    public WXApiOrderQueryRspBO orderQuery(WXApiOrderQueryReqBO req) {
        log.info("\u8fdb\u5165\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355" + req);
        WXApiOrderQueryRspBO rsp = new WXApiOrderQueryRspBO();
        try {
            this.checkInputParas(req);
            if ("1".equals(this.payPropertiesVo.getAbilitySwitch())) {
                rsp = this.orderQueryByAbility(req);
            } else if ("0".equals(this.payPropertiesVo.getAbilitySwitch())) {
                rsp = this.wXPayApiBusiService.orderQuery(req);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        return rsp;
    }

    private WXApiOrderQueryRspBO orderQueryByAbility(WXApiOrderQueryReqBO req) throws Exception {
        WXApiOrderQueryRspBO rsp = new WXApiOrderQueryRspBO();
        JSONObject body = new JSONObject();
        JSONObject bodyInfo = new JSONObject();
        bodyInfo.put("APP_ID", (Object)req.getAppid());
        bodyInfo.put("MCH_ID", (Object)req.getMch_id());
        bodyInfo.put("SUB_MCH_ID", (Object)req.getSub_mch_id());
        bodyInfo.put("NONCE_STR", (Object)req.getNonce_str());
        bodyInfo.put("SIGN", (Object)req.getSign());
        bodyInfo.put("OUT_TRADE_NO", (Object)req.getOut_trade_no());
        body.put("ORDER_QUERY_REQ", (Object)bodyInfo);
        String resultStr = this.abilityToPayPlatformService.abilityToPayPlatform(this.payPropertiesVo.getAbilityWxOrderQueryUrl(), body);
        System.out.println(resultStr);
        ParseInfo parseInfo = ParseAbilityResponse.getRspBodyInfo((String)resultStr, (String)"ORDER_QUERY_RSP");
        if (!"0000".equals(parseInfo.getRsp_code())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", parseInfo.getRsp_msg());
        }
        if (!Signature.checkIsSignValidFromAbilityResponse((JSONObject)parseInfo.getJsonInfo(), (String)req.getKey())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6821\u9a8c\u67e5\u8be2\u8ba2\u5355api\u8fd4\u56de\u7b7e\u540d\u5931\u8d25");
        }
        rsp = (WXApiOrderQueryRspBO)ParseAbilityResponse.parseJsonToMap((JSONObject)parseInfo.getJsonInfo(), WXApiOrderQueryRspBO.class, (boolean)true);
        return rsp;
    }

    private void checkInputParas(WXApiOrderQueryReqBO req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getAppid())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u5165\u53c2\u3010appid\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getMch_id())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u5165\u53c2\u3010mch_id\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getSign())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u5165\u53c2\u3010sign\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getKey())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u5165\u53c2\u3010key\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getTransaction_id()) && StringUtils.isEmpty((Object)req.getOut_trade_no())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u5165\u53c2\u3010transaction_id\u3011\u3001\u3010out_trade_no\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }
}

