/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.PorderPayTransReqBo;
import com.tydic.payment.pay.bo.RefundMessageBo;
import com.tydic.payment.pay.busi.AliRefundService;
import com.tydic.payment.pay.busi.CashRefundBusiService;
import com.tydic.payment.pay.busi.CreateRefundBusiService;
import com.tydic.payment.pay.busi.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PorderPayTransBusiService;
import com.tydic.payment.pay.busi.UnionAcpPayRefundBusiService;
import com.tydic.payment.pay.busi.WXRefundBusiService;
import com.tydic.payment.pay.busi.bo.AliRefundReqBo;
import com.tydic.payment.pay.busi.bo.AliRefundRspBo;
import com.tydic.payment.pay.busi.bo.CashRefundBusiReqBo;
import com.tydic.payment.pay.busi.bo.CashRefundBusiRspBo;
import com.tydic.payment.pay.busi.bo.CreateRefundOrderReqBo;
import com.tydic.payment.pay.busi.bo.CreateRefundOrderRspBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.busi.bo.PayOrderReqBo;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.UnionAcpPayRefundBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionAcpPayRefundBusiRspBO;
import com.tydic.payment.pay.busi.bo.WXRefundBusiReqBo;
import com.tydic.payment.pay.busi.bo.WXRefundBusiRspBo;
import com.tydic.payment.pay.comb.RefundCombService;
import com.tydic.payment.pay.comb.bo.RefundCombReqBO;
import com.tydic.payment.pay.comb.bo.RefundCombRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=RefundCombService.class)
public class RefundCombServiceImpl
implements RefundCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefundCombServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private WXRefundBusiService wXRefundBusiService;
    @Autowired
    private AliRefundService aliRefundService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private CreateRefundBusiService createRefundBusiService;
    @Autowired
    private CashRefundBusiService cashRefundBusiService;
    @Autowired
    private PorderPayTransBusiService porderPayTransBusiService;
    @Autowired
    private UnionAcpPayRefundBusiService unionAcpPayRefundBusiService;

    public RefundCombRspBO dealRefund(RefundCombReqBO req) throws Exception {
        LOGGER.info("\u9000\u6b3e\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)req));
        if (StringUtils.isEmpty((Object)req.getRefundFee())) {
            req.setRefundFee(req.getRealFee());
        }
        JSONObject rsp = new JSONObject();
        RefundCombRspBO refundCombRspBO = new RefundCombRspBO();
        try {
            String str;
            String payMethod;
            Iterator it;
            Set payMethods;
            CreateRefundOrderRspBo createRefundOrderRspBo;
            this.checkInputParas(req);
            Long busiId = Long.parseLong(req.getBusiId());
            OrderQueryConstructionReqBo orderQueryConstructionReqBo = new OrderQueryConstructionReqBo();
            orderQueryConstructionReqBo.setBusiId(busiId);
            orderQueryConstructionReqBo.setOutOrderId(req.getOutOrderId());
            OrderQueryConstructionRspBo constructionRspBo = this.orderQueryConstructionBusiService.queryConstruction(orderQueryConstructionReqBo);
            if ("0000".equals(constructionRspBo.getRspCode())) {
                refundCombRspBO.setResultCode("FAIL");
                refundCombRspBO.setResultMsg("\u5916\u90e8\u9000\u6b3e\u8ba2\u5355\u53f7\u3010" + req.getOutOrderId() + "\u3011\u5df2\u7ecf\u4f7f\u7528\uff0c\u8bf7\u52ff\u91cd\u590d\u4f7f\u7528");
                refundCombRspBO.setRspCode("0000");
                refundCombRspBO.setRspName("\u9000\u6b3e\u5931\u8d25");
                return refundCombRspBO;
            }
            orderQueryConstructionReqBo.setBusiId(busiId);
            orderQueryConstructionReqBo.setOutOrderId(req.getOutRefundId());
            constructionRspBo = this.orderQueryConstructionBusiService.queryConstruction(orderQueryConstructionReqBo);
            if (!"0000".equals(constructionRspBo.getRspCode())) {
                refundCombRspBO.setResultCode("FAIL");
                refundCombRspBO.setResultMsg("\u5916\u90e8\u8ba2\u5355\u53f7 \u3010" + req.getOutRefundId() + "\u3011\u3010busiId =" + req.getBusiCode() + "\u3011 \u65e0\u4fe1\u606f");
                refundCombRspBO.setRspCode("0000");
                refundCombRspBO.setRspName("\u9000\u6b3e\u5931\u8d25");
                return refundCombRspBO;
            }
            PorderPo orderInfo = this.payOrderAtomService.queryPorderByOutOrderId(req.getOutRefundId(), constructionRspBo.getOrderId());
            if (orderInfo == null) {
                refundCombRspBO.setResultCode("FAIL");
                refundCombRspBO.setResultMsg("\u8ba2\u5355\u53f7\u3010outRefundNo=" + req.getOutRefundId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
                refundCombRspBO.setRspCode("0000");
                refundCombRspBO.setRspName("\u9000\u6b3e\u5931\u8d25");
                return refundCombRspBO;
            }
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
            orderPayTransAtomReq.setOrderStatus("A10");
            List<PorderPayTransAtomRspBo> transAtomList = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
            if (orderInfo.getTotalFee().compareTo(orderInfo.getRefundFee()) == 0) {
                refundCombRspBO.setResultCode("FINISH");
                refundCombRspBO.setResultMsg("\u8ba2\u5355\u53f7\u5df2\u7ecf\u5b8c\u6210\u9000\u6b3e");
                refundCombRspBO.setRspCode("0000");
                refundCombRspBO.setRspName("\u8ba2\u5355\u53f7\u5df2\u7ecf\u5b8c\u6210\u9000\u6b3e");
                return refundCombRspBO;
            }
            this.checkOrderInfo(req, orderInfo, transAtomList);
            CreateRefundOrderReqBo createRefundOrderReqBo = new CreateRefundOrderReqBo();
            BeanUtils.copyProperties((Object)req, (Object)createRefundOrderReqBo);
            createRefundOrderReqBo.setRefundFlag(Long.valueOf(Long.parseLong(req.getRefundFlag())));
            createRefundOrderReqBo.setSubBanking(constructionRspBo.getOrderId());
            createRefundOrderReqBo.setRefundFee(req.getRefundFee());
            createRefundOrderReqBo.setNotifyUrl(req.getNotifyUrl());
            if (createRefundOrderReqBo.getRefundFee() == null) {
                createRefundOrderReqBo.setRefundFee(req.getRealFee());
            }
            if ("8888".equals((createRefundOrderRspBo = this.createRefundBusiService.createRefundOrder(createRefundOrderReqBo)).getRspCode())) {
                LOGGER.info("\u521b\u5efa\u652f\u4ed8\u9000\u6b3e\u8bb0\u5f55\u4e86\u5f02\u5e38");
                refundCombRspBO.setRspCode(createRefundOrderRspBo.getRspCode());
                refundCombRspBO.setRspName("\u5931\u8d25");
                refundCombRspBO.setResultCode("FAIL");
                refundCombRspBO.setResultMsg(createRefundOrderRspBo.getRspName());
                return refundCombRspBO;
            }
            Long refundId = createRefundOrderRspBo.getRefundId();
            Long orderId = createRefundOrderRspBo.getOrderId();
            Map refundMsg = createRefundOrderRspBo.getRefundOrderId();
            String merchant_id = String.valueOf(orderInfo.getMerchantId());
            if (StringUtils.isEmpty((Object)req.getRefundDesc())) {
                req.setRefundDesc("\u4e1a\u52a1\u51b2\u6b63");
            }
            BigDecimal totalFee = MoneyUtils.haoToFen((Long)orderInfo.getTotalFee());
            if (refundMsg.containsKey("30")) {
                CashRefundBusiReqBo cashRefundReqBo = new CashRefundBusiReqBo();
                cashRefundReqBo.setOrderId(orderId);
                cashRefundReqBo.setRefundId(refundId);
                cashRefundReqBo.setPayMethod("30");
                cashRefundReqBo.setRefundOrderId(((RefundMessageBo)refundMsg.get("30")).getRefundOrderId());
                cashRefundReqBo.setRefundReason(req.getRefundDesc());
                cashRefundReqBo.setRefundFee(((RefundMessageBo)refundMsg.get("30")).getRefundFee());
                cashRefundReqBo.setMerchantId(Long.valueOf(Long.parseLong(merchant_id)));
                CashRefundBusiRspBo cashRefundRspBo = this.cashRefundBusiService.dealCashRefund(cashRefundReqBo);
                rsp = (JSONObject)JSONObject.toJSON((Object)cashRefundRspBo);
            } else if (refundMsg.containsKey("10") || refundMsg.containsKey("11") || refundMsg.containsKey("13") || refundMsg.containsKey("12") || refundMsg.containsKey("14") || refundMsg.containsKey("15")) {
                payMethods = refundMsg.keySet();
                it = payMethods.iterator();
                payMethod = "";
                while (it.hasNext()) {
                    str = (String)it.next();
                    if (!"10".equals(str) && !"11".equals(str) && !"13".equals(str) && !"12".equals(str) && !"14".equals(str) && !"15".equals(str)) continue;
                    payMethod = str;
                    break;
                }
                if ("".equals(payMethod)) {
                    LOGGER.info("\u5fae\u4fe1\u9000\u6b3e\uff0c \u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                WXRefundBusiReqBo wxRefundReq = new WXRefundBusiReqBo();
                wxRefundReq.setOutTradeNo(((RefundMessageBo)refundMsg.get(payMethod)).getPayOrderId());
                wxRefundReq.setOutRefundNo(((RefundMessageBo)refundMsg.get(payMethod)).getRefundOrderId());
                wxRefundReq.setTransactionId(((RefundMessageBo)refundMsg.get(payMethod)).getPayNotifyTransId());
                wxRefundReq.setTotalFee(totalFee);
                wxRefundReq.setRefundFee(((RefundMessageBo)refundMsg.get(payMethod)).getRefundFee());
                wxRefundReq.setRefundDesc(req.getRefundDesc());
                wxRefundReq.setOrderId(orderId);
                wxRefundReq.setRefundId(refundId);
                wxRefundReq.setPayMethod(payMethod);
                wxRefundReq.setMerchantId(orderInfo.getMerchantId());
                wxRefundReq.setTradeTime(((RefundMessageBo)refundMsg.get(payMethod)).getTradeTime());
                WXRefundBusiRspBo wxRefundRsp = this.wXRefundBusiService.dealWxRefund(wxRefundReq);
                rsp = (JSONObject)JSONObject.toJSON((Object)wxRefundRsp);
            } else if (refundMsg.containsKey("20") || refundMsg.containsKey("21") || refundMsg.containsKey("23") || refundMsg.containsKey("22") || refundMsg.containsKey("24")) {
                payMethods = refundMsg.keySet();
                it = payMethods.iterator();
                payMethod = "";
                while (it.hasNext()) {
                    str = (String)it.next();
                    if (!"20".equals(str) && !"21".equals(str) && !"23".equals(str) && !"22".equals(str) && !"24".equals(str)) continue;
                    payMethod = str;
                    break;
                }
                if ("".equals(payMethod)) {
                    LOGGER.info("\u652f\u4ed8\u5b9d\u9000\u6b3e\uff0c \u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                AliRefundReqBo aliRefundReqBo = new AliRefundReqBo();
                aliRefundReqBo.setMerchantId(Long.valueOf(Long.parseLong(merchant_id)));
                aliRefundReqBo.setOrderId(orderInfo.getOrderId());
                aliRefundReqBo.setPayOrderId(((RefundMessageBo)refundMsg.get(payMethod)).getPayOrderId());
                aliRefundReqBo.setRefundFee(((RefundMessageBo)refundMsg.get(payMethod)).getRefundFee());
                aliRefundReqBo.setRefundReason(req.getRefundDesc());
                aliRefundReqBo.setPayMethod(payMethod);
                aliRefundReqBo.setRefundId(refundId);
                aliRefundReqBo.setRefundOrderId(((RefundMessageBo)refundMsg.get(payMethod)).getRefundOrderId());
                AliRefundRspBo AliRefundRspBo2 = this.aliRefundService.dealAliRefund(aliRefundReqBo);
                AliRefundRspBo2.setPayMethod(payMethod);
                rsp = (JSONObject)JSONObject.toJSON((Object)AliRefundRspBo2);
            } else if (refundMsg.containsKey("110") || refundMsg.containsKey("112") || refundMsg.containsKey("113")) {
                payMethods = refundMsg.keySet();
                it = payMethods.iterator();
                payMethod = "";
                while (it.hasNext()) {
                    str = (String)it.next();
                    if (!"110".equals(str) && !"112".equals(str) && !"113".equals(str)) continue;
                    payMethod = str;
                    break;
                }
                RefundMessageBo refundMessageBO = (RefundMessageBo)refundMsg.get(payMethod);
                UnionAcpPayRefundBusiReqBO unionAcpPayRefundBusiReqBO = new UnionAcpPayRefundBusiReqBO();
                unionAcpPayRefundBusiReqBO.setMerchantId(Long.valueOf(Long.parseLong(merchant_id)));
                unionAcpPayRefundBusiReqBO.setOrderId(orderInfo.getOrderId());
                unionAcpPayRefundBusiReqBO.setPayMethod(payMethod);
                unionAcpPayRefundBusiReqBO.setPayOrderId(refundMessageBO.getPayOrderId());
                unionAcpPayRefundBusiReqBO.setRefundId(refundId);
                unionAcpPayRefundBusiReqBO.setRefundOrderId(refundMessageBO.getRefundOrderId());
                unionAcpPayRefundBusiReqBO.setRefundFee(refundMessageBO.getRefundFee().toString());
                unionAcpPayRefundBusiReqBO.setRefundReason(req.getRefundDesc());
                UnionAcpPayRefundBusiRspBO unionAcpPayRefundBusiRspBO = this.unionAcpPayRefundBusiService.refund(unionAcpPayRefundBusiReqBO);
                rsp = (JSONObject)JSONObject.toJSON((Object)unionAcpPayRefundBusiRspBO);
            } else {
                if (refundMsg.containsKey("120")) {
                    refundCombRspBO.setRspCode("0000");
                    refundCombRspBO.setResultCode("FAIL");
                    refundCombRspBO.setResultMsg("\u5149\u5927\u94f6\u884c\u6682\u4e0d\u652f\u6301\u9000\u6b3e");
                    refundCombRspBO.setRspName("\u5149\u5927\u94f6\u884c\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u9000\u6b3e");
                    return refundCombRspBO;
                }
                refundCombRspBO.setRspCode("0000");
                refundCombRspBO.setResultCode("FAIL");
                refundCombRspBO.setResultMsg("\u672a\u67e5\u8be2\u5230\u6b64\u8ba2\u5355\u7684\u652f\u4ed8\u65b9\u5f0f");
                refundCombRspBO.setRspName("\u672a\u67e5\u8be2\u5230\u6b64\u8ba2\u5355\u7684\u652f\u4ed8\u65b9\u5f0f");
                return refundCombRspBO;
            }
            if ("0000".equals(rsp.getString("rspCode")) && !"CONFIRM".equals(rsp.getString("refundStatus"))) {
                try {
                    Iterator entries = refundMsg.entrySet().iterator();
                    PorderPayTransReqBo reqBo = null;
                    RefundMessageBo refundMessageBo = null;
                    while (entries.hasNext()) {
                        reqBo = new PorderPayTransReqBo();
                        refundMessageBo = (RefundMessageBo)entries.next().getValue();
                        String payOrderId = refundMessageBo.getPayOrderId();
                        Long refundFee = MoneyUtils.fenToHao((BigDecimal)refundMessageBo.getRetiredFee()).longValue();
                        reqBo.setPayOrderId(payOrderId);
                        reqBo.setOrderId(orderId);
                        reqBo.setRefundFee(refundFee);
                        this.porderPayTransBusiService.updateOrderPayTransByPayOrderId(reqBo);
                    }
                    PayOrderReqBo payOrderReqBo = new PayOrderReqBo();
                    payOrderReqBo.setOrderId(orderId);
                    payOrderReqBo.setRefundFee(Long.valueOf(MoneyUtils.fenToHao((BigDecimal)createRefundOrderRspBo.getRetiredFee()).longValue()));
                    payOrderReqBo.setOrderRefundId(createRefundOrderRspBo.getOrderRefundId());
                    PayOrderRspBo payOrderRspBo = this.payOrderBusiService.update(payOrderReqBo);
                    if (!"0000".equals(payOrderRspBo.getRspCode())) {
                        LOGGER.info("\u9000\u6b3e\u8ba2\u5355\u5173\u8054\u5931\u8d25\uff1apayId =" + orderId + "\u9000\u6b3e\u5355\u53f7\u4e3a refundId = " + refundId);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u66f4\u65b0\u5df2\u9000\u6b3e\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            if (!"CONFIRM".equals(rsp.getString("refundStatus"))) {
                refundCombRspBO.setTradeTime(rsp.getString("tradeTime"));
                refundCombRspBO.setTransactionsId(String.valueOf(refundId));
                refundCombRspBO.setResultMsg(rsp.getString("msg"));
                refundCombRspBO.setPayMethod(rsp.getString("payMethod"));
            }
            refundCombRspBO.setRspCode(rsp.getString("rspCode"));
            refundCombRspBO.setRspName(rsp.getString("rspName"));
            refundCombRspBO.setResultCode(rsp.getString("refundStatus"));
            refundCombRspBO.setUrl(rsp.getString("url"));
            refundCombRspBO.setPayMethod(rsp.getString("payMethod"));
            LOGGER.info("\u9000\u6b3e\u7ec4\u5408\u670d\u52a1\u5b8c\u6210\uff0c\u51c6\u5907\u53d1\u6d88\u606f\u961f\u5217\uff0c\u6b64\u65f6\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)refundCombRspBO));
            if (!"PAYING".equals(rsp.getString("refundStatus"))) {
                OrderQueryConstructionReqBo insetorderQueryConstructionReqBo = new OrderQueryConstructionReqBo();
                insetorderQueryConstructionReqBo.setBusiId(Long.valueOf(Long.parseLong(req.getBusiId())));
                insetorderQueryConstructionReqBo.setOrderId(refundId);
                insetorderQueryConstructionReqBo.setOutOrderId(req.getOutOrderId());
                OrderQueryConstructionRspBo orderQueryConstructionRspBo = this.orderQueryConstructionBusiService.insertConstruction(insetorderQueryConstructionReqBo);
                if (!"0000".equals(orderQueryConstructionRspBo.getRspCode())) {
                    LOGGER.info("****************** \u5206\u5e93\u5efa\u5173\u8054\u5f02\u5e38\u5566 *****************");
                    LOGGER.info(" orderId=" + refundId + " busiId=" + req.getBusiId() + "outOrderId=" + req.getOutOrderId());
                    refundCombRspBO.setResultMsg("\u5206\u5e93\u5efa\u5173\u8054\u5f02\u5e38\uff0c\u8bf7\u624b\u5de5\u5904\u7406");
                }
            }
        }
        catch (BusinessException e) {
            refundCombRspBO.setRspCode("0000");
            refundCombRspBO.setRspName("\u9000\u6b3e\u5931\u8d25");
            refundCombRspBO.setResultCode("FAIL");
            refundCombRspBO.setResultMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            refundCombRspBO.setRspCode("8888");
            refundCombRspBO.setRspName("\u9000\u6b3e\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return refundCombRspBO;
    }

    private void checkInputParas(RefundCombReqBO req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9000\u6b3e\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOutOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9000\u6b3e\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u5916\u90e8\u8ba2\u5355\u53f7\u3010outOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOutRefundId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9000\u6b3e\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u8bf7\u6c42\u9000\u6b3e\u7684\u8ba2\u5355\u53f7\u3010outRefundId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getBusiId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9000\u6b3e\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u8bf7\u6c42\u9000\u6b3e\u7684\u8ba2\u5355\u53f7\u3010busiId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkOrderInfo(RefundCombReqBO req, PorderPo orderInfo, List<PorderPayTransAtomRspBo> transAtomList) throws Exception {
        if (StringUtils.isEmpty((Object)req.getRefundFee()) && StringUtils.isEmpty((Object)req.getRealFee())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8bf7\u4f20\u5165\u9000\u6b3e\u91d1\u989d");
        }
        if (orderInfo.getTotalFee().compareTo(orderInfo.getRefundFee()) == 0) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be5\u8ba2\u5355\u3010" + req.getOutRefundId() + "\u3011\u5df2\u5b8c\u6210\u9000\u6b3e");
        }
        BigDecimal lastFee = MoneyUtils.haoToFen((Long)(orderInfo.getTotalFee() - orderInfo.getRefundFee()));
        if (lastFee.compareTo(new BigDecimal(req.getRefundFee())) < 0) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5b9e\u9000\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53ef\u9000\u91d1\u989d");
        }
        if (!"A10".equals(orderInfo.getOrderStatus())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be5\u8ba2\u5355\u3010" + req.getOutRefundId() + "\u3011\u8fd8\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u9000\u6b3e");
        }
        if (transAtomList == null || transAtomList.size() == 0) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9000\u6b3e\u7ec4\u5408\u670d\u52a1\u6839\u636e\u8bf7\u6c42\u9000\u6b3e\u7684\u8ba2\u5355\u53f7\u3010outRefundNo=" + req.getOutRefundId() + "\u3011\u5728\u8868\u3010P_ORDER_PAY_TRANS\u3011\u4e2d\u67e5\u8be2\u4e0d\u5230\u652f\u4ed8\u6210\u529f\u7684\u8bf7\u6c42\u6570\u636e!");
        }
        if ("02".equals(req.getOrderType()) && orderInfo.getRefundFee().compareTo(0L) > 0) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9000\u6b3e\u7684\u8ba2\u5355\u53f7\u3010outRefundNo=" + req.getOutRefundId() + "\u3011\u5df2\u7ecf\u90e8\u5206\u9000\u6b3e\uff0c\u4e0d\u652f\u6491\u5168\u989d\u9000\u6b3e");
        }
        if ("02".equals(req.getOrderType()) && orderInfo.getTotalFee().compareTo(MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(req.getRefundFee()))) != 0) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9000\u6b3e\u7684\u8ba2\u5355\u53f7\u3010outRefundNo=" + req.getOutRefundId() + "\u3011\u8bf7\u6c42\u4e3a\u5168\u989d\u9000\u6b3e\uff0c \u8bf7\u786e\u8ba4\u9000\u6b3e\u91d1\u989d\u662f\u5426\u4e3a\u6b63\u786e");
        }
    }
}

