/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.config.quartz;

import com.tydic.payment.pay.comb.PayProTriggerRefundCallSysCombService;
import com.tydic.payment.pay.comb.bo.PayProTriggerRefundCallSysCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProTriggerRefundCallSysCombRspBo;
import com.tydic.payment.pay.config.quartz.RefundCallBackSender;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PayProRefundCallBaceJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(PayProRefundCallBaceJob.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private RefundCallBackSender refundCallBackSender;
    @Autowired
    private PayProTriggerRefundCallSysCombService payProTriggerRefundCallSysCombService;
    public static final String ORDER_ID_KEY = "orderId";
    public static final String TIME_KEY = "time";

    public void execute(JobExecutionContext context) {
        log.info("----------------------------\u652f\u4ed8\u4e2d\u5fc3\u9000\u6b3e\u56de\u8c03\u542f\u52a8-------------------------------");
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String orderId = dataMap.getString(ORDER_ID_KEY);
        int noticeTime = Integer.parseInt(dataMap.getString(TIME_KEY));
        log.info("\u8ba2\u5355id\u4e3a\uff1a" + orderId + "\u5f53\u524d\u89e6\u53d1\u6b21\u6570\u4e3a\uff1a" + noticeTime);
        PayProTriggerRefundCallSysCombReqBo callReqBo = new PayProTriggerRefundCallSysCombReqBo();
        callReqBo.setOrderId(orderId);
        PayProTriggerRefundCallSysCombRspBo callRetBo = this.payProTriggerRefundCallSysCombService.noticeBusiSys(callReqBo);
        if (!"0000".equals(callRetBo.getRespCode()) && this.payPropertiesVo.isUseMulitpleCallBack()) {
            String savedTimes = this.payPropertiesVo.getValueByKey("mulitple.callback.times");
            int times = Integer.parseInt(savedTimes);
            if (noticeTime < times) {
                this.refundCallBackSender.sendTask(orderId);
            } else {
                log.info("\u8ba2\u5355id\uff08" + orderId + "\uff09\u5df2\u8fbe\u5230" + times + "\u6b21\uff0c\u4e0d\u518d\u7ee7\u7eed\u56de\u8c03");
            }
        }
    }
}

