/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.dao.BillCompareDiffMapper;
import com.tydic.payment.pay.dao.po.BillCompareDiffPO;
import com.tydic.payment.pay.dao.po.BillCompareDiffPageReqPO;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.BillCmpDiffListQryWebReqBO;
import com.tydic.payment.pay.web.bo.rsp.BillCmpDiffListQryWebRspBO;
import com.tydic.payment.pay.web.service.BillCmpDiffListQryWebService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=BillCmpDiffListQryWebService.class)
public class BillCmpDiffListQryWebServiceImpl
implements BillCmpDiffListQryWebService {
    private static final Logger log = LoggerFactory.getLogger(BillCmpDiffListQryWebServiceImpl.class);
    @Autowired
    private BillCompareDiffMapper billCompareDiffMapper;
    @Autowired
    private QueryPCodeInfoService queryPCodeInfoService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;

    public RspPage<BillCmpDiffListQryWebRspBO> qryBillCmpDiffList(BillCmpDiffListQryWebReqBO req) {
        log.info("\u5bf9\u8d26\u5dee\u5f02\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + req);
        RspPage retBo = new RspPage();
        ArrayList<BillCmpDiffListQryWebRspBO> rspList = new ArrayList<BillCmpDiffListQryWebRspBO>();
        retBo.setRows(rspList);
        if (StringUtils.isEmpty((Object)req.getBusiId())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5165\u53c2\u3010busiId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            String str;
            BillCompareDiffPageReqPO po = new BillCompareDiffPageReqPO();
            if (!StringUtils.isEmpty((Object)req.getBillDateBegin())) {
                String[] beginDateStr = req.getBillDateBegin().split(" ");
                str = beginDateStr[0].replaceAll("-", "");
                Long beginDateLong = Long.valueOf(str);
                po.setBillDateBegin(beginDateLong);
            }
            if (!StringUtils.isEmpty((Object)req.getBillDateEnd())) {
                String[] endDateStr = req.getBillDateBegin().split(" ");
                str = endDateStr[0].replaceAll("-", "");
                Long endDateLong = Long.valueOf(str);
                po.setBillDateEnd(endDateLong);
            }
            if (StringUtils.isEmpty((Object)req.getBillDateBegin()) && StringUtils.isEmpty((Object)req.getBillDateEnd())) {
                po.setBillDate(Long.valueOf(new SimpleDateFormat("yyyyMMdd").format(new Date())));
            }
            po.setBusiId(Long.valueOf(req.getBusiId()));
            if (!StringUtils.isEmpty((Object)req.getOrderId())) {
                po.setOrderId(Long.valueOf(req.getOrderId()));
            }
            if (!StringUtils.isEmpty((Object)req.getOutOrderId())) {
                po.setOutOrderId(req.getOutOrderId());
            }
            Page page = null;
            if (req.getPageNo() > 1) {
                page = new Page(req.getPageNo(), req.getPageSize());
            } else {
                page = new Page();
                BeanUtils.copyProperties((Object)req, (Object)page);
                if (page.getPageNo() < 1) {
                    page.setPageNo(1);
                }
                if (page.getPageSize() < 1) {
                    page.setPageSize(10);
                }
            }
            List<BillCompareDiffPO> list = this.billCompareDiffMapper.queryBillCompareDiffByPage((Page<BillCompareDiffPageReqPO>)page, po);
            if (!CollectionUtils.isEmpty(list)) {
                BusiSystemInfoPO busiSystemInfoPO = new BusiSystemInfoPO();
                QueryPCodeInfoReqBO queryPCodeInfoReq = new QueryPCodeInfoReqBO();
                for (BillCompareDiffPO l : list) {
                    QueryPCodeInfoRspBO queryPCodeInfoRsp;
                    BillCmpDiffListQryWebRspBO bo = new BillCmpDiffListQryWebRspBO();
                    if (!StringUtils.isEmpty((Object)l.getBusiId())) {
                        bo.setBusiId(String.valueOf(l.getBusiId()));
                        busiSystemInfoPO.setBusiId(l.getBusiId());
                        List<BusiSystemInfoPO> busiSystemInfoList = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiSystemInfoPO);
                        if (!busiSystemInfoList.isEmpty()) {
                            String busiName = busiSystemInfoList.get(0).getBusiName();
                            bo.setBusiName(busiName == null ? "" : busiName);
                        }
                    }
                    if (l.getOrderId() != null && l.getOrderId() > 0L) {
                        bo.setOrderId(String.valueOf(l.getOrderId()));
                    }
                    if (l.getOrderDate() != null) {
                        bo.setOrderDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(l.getOrderDate()));
                    }
                    if (l.getDiffType() != null && l.getDiffType() > 0) {
                        queryPCodeInfoReq.setTypeCode("COMPARE_DIFF_DIFF_TYPE");
                        queryPCodeInfoReq.setCodeValue(String.valueOf(l.getDiffType()));
                        queryPCodeInfoRsp = this.queryPCodeInfoService.queryPCodeInfo(queryPCodeInfoReq);
                        bo.setDiffType(queryPCodeInfoRsp.getCodeInfo() == null ? "" : queryPCodeInfoRsp.getCodeInfo());
                    }
                    if (l.getBillDate() != null && l.getBillDate() > 0L) {
                        bo.setBillDate(String.valueOf(l.getBillDate()));
                    }
                    if (l.getCreateDate() != null) {
                        bo.setCreateDate(new SimpleDateFormat("yyy-MM-dd HH:mm:ss").format(l.getCreateDate()));
                    }
                    if (!StringUtils.isEmpty((Object)l.getOrderType())) {
                        bo.setOrderType(l.getOrderType());
                        queryPCodeInfoReq.setTypeCode("P_ORDER_ORDER_TYPE");
                        queryPCodeInfoReq.setCodeValue(l.getOrderType());
                        queryPCodeInfoRsp = this.queryPCodeInfoService.queryPCodeInfo(queryPCodeInfoReq);
                        bo.setOrderType(queryPCodeInfoRsp.getCodeInfo() == null ? "" : queryPCodeInfoRsp.getCodeInfo());
                    }
                    bo.setPayOrderId(l.getPayOrderId());
                    bo.setRefundOrderId(l.getRefundOrderId());
                    bo.setBillTransId(l.getBillTransId() == null ? "" : l.getBillTransId());
                    String totalFee = "";
                    String payTotalFee = "";
                    if (!StringUtils.isEmpty((Object)l.getTotalFee())) {
                        totalFee = new BigDecimal(l.getTotalFee()).divide(new BigDecimal("100")).toString();
                    }
                    if (!StringUtils.isEmpty((Object)l.getPayTotalFee())) {
                        payTotalFee = new BigDecimal(l.getPayTotalFee()).divide(new BigDecimal("100")).toString();
                    }
                    bo.setTotalFee(totalFee);
                    bo.setPayTotalFee(payTotalFee);
                    rspList.add(bo);
                }
                retBo.setRecordsTotal(page.getTotalCount());
                retBo.setPageNo(page.getPageNo());
                retBo.setTotal(page.getTotalPages());
                return retBo;
            }
            retBo.setRecordsTotal(0);
            retBo.setTotal(0);
            retBo.setPageNo(1);
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "BillCmpDiffListQryWebService\u670d\u52a1\u5f02\u5e38");
        }
        return retBo;
    }
}

