/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.executor;

import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.comb.BillComparisonCombService;
import com.tydic.payment.bill.comb.BillPayBalanceCombService;
import com.tydic.payment.bill.comb.BillPayDayCombService;
import com.tydic.payment.bill.comb.BillPaySettleTransCombService;
import com.tydic.payment.bill.exception.BillBalanceException;
import com.tydic.payment.bill.exception.BillCompareException;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.exception.BillSyncPayDayException;
import com.tydic.payment.bill.exception.BillSyncSettleTransException;
import com.tydic.payment.bill.executor.AbstractCleanBillExecutor;
import com.tydic.payment.bill.executor.BillDownAndTrans;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultBillExecutor
extends AbstractCleanBillExecutor {
    private BillDownAndTrans billDownAndTrans;
    private BillPayDayCombService billPayDayCombService;
    private BillComparisonCombService billComparisonCombService;
    private BillPayBalanceCombService billPayBalanceCombService;
    private BillPaySettleTransCombService billPaySettleTransCombService;

    @Autowired
    public DefaultBillExecutor(BillDownAndTrans billDownAndTrans, BillPayDayCombService billPayDayCombService, BillComparisonCombService billComparisonCombService, BillPayBalanceCombService billPayBalanceCombService, BillPaySettleTransCombService billPaySettleTransCombService) {
        this.billDownAndTrans = billDownAndTrans;
        this.billPayDayCombService = billPayDayCombService;
        this.billComparisonCombService = billComparisonCombService;
        this.billPayBalanceCombService = billPayBalanceCombService;
        this.billPaySettleTransCombService = billPaySettleTransCombService;
    }

    @Override
    protected void doDownAndTransClean(BillExecuteRequest request) throws BillDownAndTransException {
        this.billDownAndTrans.doDownAndTransClean(request);
    }

    @Override
    protected void doDownAndTrans(BillExecuteRequest request) throws BillDownAndTransException {
        this.billDownAndTrans.doDownAndTrans(request);
    }

    @Override
    protected void doSyncSettleTransClean(BillExecuteRequest request) throws BillSyncSettleTransException {
        this.billPaySettleTransCombService.doSyncSettleTransClean(request);
    }

    @Override
    protected void doSyncSettleTransDay(BillExecuteRequest request) throws BillSyncSettleTransException {
        this.billPaySettleTransCombService.doSyncSettleTransDay(request);
    }

    @Override
    protected void doBalanceClean(BillExecuteRequest request) throws BillBalanceException {
        this.billPayBalanceCombService.doBalanceClean(request);
    }

    @Override
    protected void doBalance(BillExecuteRequest request) throws BillBalanceException {
        this.billPayBalanceCombService.doBalance(request);
    }

    @Override
    protected void doCompareClean(BillExecuteRequest request) throws BillCompareException {
        this.billComparisonCombService.doCompareClean(request);
    }

    @Override
    protected void doCompare(BillExecuteRequest request) throws BillCompareException {
        this.billComparisonCombService.doCompare(request);
    }

    @Override
    protected void doSyncPayDayClean(BillExecuteRequest request) throws BillSyncPayDayException {
        this.billPayDayCombService.clean(request);
    }

    @Override
    protected void doSyncPayDay(BillExecuteRequest request) throws BillSyncPayDayException {
        this.billPayDayCombService.payDay(request);
    }
}

