/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProPayCenterOrderAbilityService;
import com.tydic.payment.pay.ability.bo.PayProPayCenterOrderAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProPayCenterOrderAbilityRspBo;
import com.tydic.payment.pay.comb.PayProPreparedOrderCombService;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProPayCenterOrderAbilityService.class)
public class PayProPayCenterOrderAbilityServiceImpl
implements PayProPayCenterOrderAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProPayCenterOrderAbilityServiceImpl.class);
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    @Autowired
    private PayProPreparedOrderCombService payProPreparedOrderCombService;

    public PayProPayCenterOrderAbilityRspBo dealOrder(PayProPayCenterOrderAbilityReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u652f\u4ed8\u4e0b\u5355\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProPayCenterOrderAbilityRspBo retBo = new PayProPayCenterOrderAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("214010");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        PayProPreparedOrderCombReqBo combBo = new PayProPreparedOrderCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combBo);
        combBo.setOrderType("01");
        PayProPreparedOrderCombRspBo orderRetBo = this.payProPreparedOrderCombService.createOrder(combBo);
        if (!"0000".equals(orderRetBo.getRespCode())) {
            retBo.setRespCode("214010");
            retBo.setRespDesc(orderRetBo.getRespDesc());
            return retBo;
        }
        BeanUtils.copyProperties((Object)orderRetBo, (Object)retBo);
        return retBo;
    }

    private String validateArg(PayProPayCenterOrderAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "outOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "busiCode\u4e0d\u80fd\u4e3a\u540c\u65f6\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "totalFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getReqWay())) {
            return "reqWay\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "detailName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!(StringUtils.isEmpty((Object)reqBo.getRedirectUrl()) || reqBo.getRedirectUrl().trim().startsWith(HTTP_PREFIX) || reqBo.getRedirectUrl().trim().startsWith(HTTPS_PREFIX))) {
            return "redirectUrl\u5fc5\u987b\u4ee5'http://'\u6216\u8005'https://'\u5f00\u5934";
        }
        if (!(StringUtils.isEmpty((Object)reqBo.getNotifyUrl()) || reqBo.getNotifyUrl().trim().startsWith(HTTP_PREFIX) || reqBo.getNotifyUrl().trim().startsWith(HTTPS_PREFIX))) {
            return "notifyUrl\u5fc5\u987b\u4ee5'http://'\u6216\u8005'https://'\u5f00\u5934";
        }
        return null;
    }
}

