/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.advice;

import java.util.Collections;
import java.util.HashMap;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class PayBusiServiceTransactionAdvice {
    private static final String TRANSACTION_POINTCUT = "execution(* com.tydic.payment.pay.busi..*(..))";
    private static final String NON_TRANSACTION_POINTCUT = "execution(* com.tydic.payment.pay.ability..*(..)) || execution(* com.tydic.payment.pay.atom..*(..)) || execution(* com.tydic.payment.pay.comb..*(..)) || execution(* com.tydic.payment.pay.payable..*(..))";
    private final PlatformTransactionManager transactionManager;

    @Autowired
    public PayBusiServiceTransactionAdvice(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Bean
    public TransactionInterceptor txAdvice() {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        RuleBasedTransactionAttribute readOnlyRule = new RuleBasedTransactionAttribute();
        readOnlyRule.setReadOnly(true);
        readOnlyRule.setPropagationBehavior(4);
        RuleBasedTransactionAttribute requireRule = new RuleBasedTransactionAttribute();
        requireRule.setRollbackRules(Collections.singletonList(new RollbackRuleAttribute(Throwable.class)));
        requireRule.setPropagationBehavior(0);
        requireRule.setTimeout(5);
        HashMap<String, RuleBasedTransactionAttribute> txMap = new HashMap<String, RuleBasedTransactionAttribute>(16);
        txMap.put("create*", requireRule);
        txMap.put("register*", requireRule);
        txMap.put("update*", requireRule);
        txMap.put("delete*", requireRule);
        txMap.put("insert*", requireRule);
        txMap.put("add*", requireRule);
        txMap.put("modify*", requireRule);
        txMap.put("save*", requireRule);
        txMap.put("cancel*", requireRule);
        txMap.put("change*", requireRule);
        txMap.put("notify*", requireRule);
        txMap.put("break*", requireRule);
        txMap.put("marking*", requireRule);
        txMap.put("execute*", requireRule);
        txMap.put("set*", requireRule);
        txMap.put("record*", requireRule);
        txMap.put("log*", requireRule);
        txMap.put("deal*", requireRule);
        txMap.put("complete*", requireRule);
        txMap.put("batchDelete*", requireRule);
        txMap.put("batchInsert*", requireRule);
        txMap.put("on*", requireRule);
        txMap.put("*", readOnlyRule);
        source.setNameMap(txMap);
        return new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor txAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(TRANSACTION_POINTCUT);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.txAdvice());
    }

    @Bean
    public TransactionInterceptor nonTxAdvice() {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        RuleBasedTransactionAttribute readOnlyRule = new RuleBasedTransactionAttribute();
        readOnlyRule.setReadOnly(true);
        readOnlyRule.setPropagationBehavior(4);
        HashMap<String, RuleBasedTransactionAttribute> txMap = new HashMap<String, RuleBasedTransactionAttribute>(4);
        txMap.put("*", readOnlyRule);
        source.setNameMap(txMap);
        return new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor nonTxAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(NON_TRANSACTION_POINTCUT);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.nonTxAdvice());
    }
}

