/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.tydic.payment.pay.atom.RelBusiCashierAtomService;
import com.tydic.payment.pay.config.PayProCacheManager;
import com.tydic.payment.pay.constant.PayProCacheKeys;
import com.tydic.payment.pay.dao.RelBusiCashierMapper;
import com.tydic.payment.pay.dao.po.RelBusiCashierPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="relBusiCashierAtomService")
public class RelBusiCashierAtomServiceImpl
implements RelBusiCashierAtomService {
    @Autowired
    private RelBusiCashierMapper relBusiCashierMapper;
    @Autowired
    private PayProCacheManager payProCacheManager;

    @Override
    public Long createRelBusiCashier(RelBusiCashierPo po) {
        this.validateArg(po);
        int createRelBusiCashier = this.relBusiCashierMapper.createRelBusiCashier(po);
        if (createRelBusiCashier < 1) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_REL_BUSI_CASHIER\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getId() == null) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_REL_BUSI_CASHIER\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getId();
    }

    @Override
    public int updateRelBusiCashier(RelBusiCashierPo po) {
        this.validateArgUpdate(po);
        int updateRelBusiCashier = this.relBusiCashierMapper.updateRelBusiCashier(po);
        return updateRelBusiCashier;
    }

    @Override
    public int deleteRelBusiCashier(RelBusiCashierPo po) {
        this.validateArgDel(po);
        int deleteRelBusiCashier = this.relBusiCashierMapper.deleteRelBusiCashier(po);
        return deleteRelBusiCashier;
    }

    @Override
    public List<RelBusiCashierPo> queryRelBusiCashier(RelBusiCashierPo po) {
        if (po == null) {
            po = new RelBusiCashierPo();
        }
        ArrayList<RelBusiCashierPo> cacheList = new ArrayList<RelBusiCashierPo>();
        if (!StringUtils.isEmpty((Object)po.getReqWay()) && po.getBusiId() != null) {
            String cacheKey = PayProCacheKeys.PAY_CACHE_REL_BUSI_REQWAY.getKey() + po.getBusiId().toString() + "_" + po.getReqWay();
            RelBusiCashierPo cachedPo = this.payProCacheManager.get(cacheKey, RelBusiCashierPo.class);
            if (cachedPo != null) {
                cacheList.add(cachedPo);
                return cacheList;
            }
            List<RelBusiCashierPo> queryRelBusiCashier = this.relBusiCashierMapper.queryRelBusiCashier(po);
            if (queryRelBusiCashier == null || queryRelBusiCashier.isEmpty()) {
                return cacheList;
            }
            RelBusiCashierPo queryedPo = queryRelBusiCashier.get(0);
            this.payProCacheManager.set(cacheKey, queryedPo, true, null);
            return queryRelBusiCashier;
        }
        List<RelBusiCashierPo> queryRelBusiCashier = this.relBusiCashierMapper.queryRelBusiCashier(po);
        if (queryRelBusiCashier == null || queryRelBusiCashier.isEmpty()) {
            return cacheList;
        }
        return queryRelBusiCashier;
    }

    private void validateArgDel(RelBusiCashierPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_REL_BUSI_CASHIER\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_REL_BUSI_CASHIER\u5165\u53c2\u5c5e\u6027Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArgUpdate(RelBusiCashierPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_REL_BUSI_CASHIER\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_REL_BUSI_CASHIER\u5165\u53c2\u5c5e\u6027ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArg(RelBusiCashierPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_REL_BUSI_CASHIER\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() != null) {
            po.setId(null);
        }
        if (po.getBusiId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_REL_BUSI_CASHIER\u5165\u53c2\u5c5e\u6027BusiId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getReqWay() == null || po.getReqWay().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_REL_BUSI_CASHIER\u5165\u53c2\u5c5e\u6027ReqWay\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getCashierTemplate() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_REL_BUSI_CASHIER\u5165\u53c2\u5c5e\u6027CashierTemplate\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public int deleteRelBusiCashierByBusiId(RelBusiCashierPo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636ebusiId\u5220\u9664P_REL_BUSI_CASHIER\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getBusiId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636ebusiId\u5220\u9664P_REL_BUSI_CASHIER\u5165\u53c2po\u5bf9\u8c61\u7684\u5c5e\u6027BusiId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long busiId = po.getBusiId();
        po = new RelBusiCashierPo();
        po.setBusiId(busiId);
        return this.relBusiCashierMapper.deleteRelBusiCashier(po);
    }

    @Override
    public List<String> queryReqWayRelBusi(Long busiId) {
        if (busiId == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636ebusiId\u67e5\u8be2P_REL_BUSI_CASHIER\u5165\u53c2busiId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> queryRelBusiCashier = this.relBusiCashierMapper.queryReqWayRelBusi(busiId);
        if (CollectionUtils.isEmpty(queryRelBusiCashier)) {
            return new ArrayList<String>();
        }
        return queryRelBusiCashier;
    }
}

