/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.UnionAcpPayQueryBusiService;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.bo.UnionAcpPayQueryBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionAcpPayQueryBusiRspBO;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import com.tydic.payment.pay.util.UnionPayAcpSdkRspUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=UnionAcpPayQueryBusiService.class)
public class UnionAcpPayQueryBusiServiceImpl
implements UnionAcpPayQueryBusiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Resource
    private FileClient fileClient;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;

    public UnionAcpPayQueryBusiRspBO query(UnionAcpPayQueryBusiReqBO reqBO) {
        this.logger.debug("\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u4ea4\u6613\u72b6\u6001\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        Map<String, String> paramMap = this.getPayParamMap(reqBO.getMerchantId());
        this.loadProperties(paramMap);
        Map<String, String> requestData = this.buildRequestData(reqBO, paramMap);
        Map reqData = AcpService.sign(requestData, (String)"UTF-8");
        String url = SdkConfig.getConfig().getSingleQueryUrl();
        Map rspData = AcpService.post((Map)reqData, (String)url, (String)"UTF-8");
        return this.buildRspBO(reqBO, paramMap, rspData);
    }

    private UnionAcpPayQueryBusiRspBO buildRspBO(UnionAcpPayQueryBusiReqBO reqBO, Map<String, String> paramMap, Map<String, String> rspData) {
        UnionAcpPayQueryBusiRspBO rspBO = new UnionAcpPayQueryBusiRspBO();
        rspBO.setRspCode("8888");
        if (rspData.isEmpty()) {
            rspBO.setRspName("\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u62a5\u6587\u6216\u8fd4\u56dehttp\u72b6\u6001\u7801\u975e200");
            return rspBO;
        }
        if (!AcpService.validate(rspData, (String)"UTF-8")) {
            rspBO.setRspName("\u89e3\u6790\u54cd\u5e94\u62a5\u6587\uff0c\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            return rspBO;
        }
        String respCode = rspData.get("respCode");
        if (!UnionPayAcpSdkRspUtils.isSuccess(respCode)) {
            rspBO.setRspName(rspData.get("respMsg"));
            return rspBO;
        }
        rspBO.setRspCode("0000");
        rspBO.setRspName("\u67e5\u8be2\u6210\u529f");
        rspBO.setQueryId(rspData.get("queryId"));
        rspBO.setTraceTime(rspData.get("traceTime"));
        rspBO.setTxnTime(rspData.get("txnTime"));
        rspBO.setTxnAmt(rspData.get("txnAmt"));
        rspBO.setMerId(rspData.get("merId"));
        rspBO.setTxnType(rspData.get("txnType"));
        rspBO.setOrigRespCode(rspData.get("origRespCode"));
        rspBO.setOrigRespMsg(rspData.get("origRespMsg"));
        return rspBO;
    }

    private Map<String, String> buildRequestData(UnionAcpPayQueryBusiReqBO reqBO, Map<String, String> paramMap) {
        HashMap<String, String> data = new HashMap<String, String>(32);
        data.put("version", SdkConfig.getConfig().getVersion());
        data.put("encoding", "UTF-8");
        data.put("signMethod", SdkConfig.getConfig().getSignMethod());
        data.put("txnType", "00");
        data.put("txnSubType", "00");
        data.put("bizType", "000201");
        String merId = paramMap.get("merId");
        data.put("merId", merId);
        data.put("accessType", "0");
        data.put("orderId", reqBO.getOrderId());
        data.put("txnTime", reqBO.getTxnTime());
        return data;
    }

    private void loadProperties(Map<String, String> paramMap) {
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, paramMap);
    }

    private Map<String, String> getPayParamMap(String merchantId) {
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setMerchantId(String.valueOf(merchantId));
        paraReq.setPayMethod("110");
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }
}

