/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractCashPayAble;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CashPayAbleImpl
extends AbstractCashPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(CashPayAbleImpl.class);
    @Autowired
    private PayMethodMapper payMethodMapper;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.CASH_PAY.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        LOG.info("\u73b0\u91d1\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b");
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("212019");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        Map payTransMap = reqBo.getPayTransParam();
        String offlinePayUrl = null;
        try {
            offlinePayUrl = payTransMap.get("offlinePayUrl").toString();
        }
        catch (NullPointerException e) {
            LOG.info("\u672a\u4f20\u5165\u975e\u53ca\u65f6\u7ebf\u4e0b\u652f\u4ed8\u8df3\u8f6c\u5730\u5740\uff0c\u672c\u6b21\u4f7f\u7528\u7acb\u5373\u7ebf\u4e0b\u652f\u4ed8");
        }
        if (StringUtils.isEmpty((Object)offlinePayUrl)) {
            Date dbDate = this.payMethodMapper.getDBDate().getDate();
            String tradeTime = new DateTime((Object)dbDate).toString("yyyyMMddHHmmss");
            retBo.setPayResultCode("SUCCESS");
            retBo.setPayResultMsg("\u652f\u4ed8\u6210\u529f");
            retBo.setTradeTime(tradeTime);
            retBo.setPayNotifyTransId(reqBo.getOrderId() + "");
        }
        retBo.setWebUrl(offlinePayUrl);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027orderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

