/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayDataDataserviceBillDownloadurlQueryRequest;
import com.alipay.api.response.AlipayDataDataserviceBillDownloadurlQueryResponse;
import com.tydic.payment.bill.busi.AliPayBillDownloadBusiService;
import com.tydic.payment.bill.busi.bo.AliPayBillDownloadBusiServiceReqBO;
import com.tydic.payment.bill.constant.BillFileManager;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="aliPayBillDownloadBusiService")
public class AliPayBillDownloadBusiServiceImpl
implements AliPayBillDownloadBusiService {
    private static final Logger logger = LoggerFactory.getLogger(AliPayBillDownloadBusiServiceImpl.class);
    private static final String FILE_NAME = "aliPay";
    private static final String FILE_SUFFIX = "zip";
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public String dealAliPayBillDownload(AliPayBillDownloadBusiServiceReqBO reqBO) {
        logger.debug("\u652f\u4ed8\u5b9d\u8d26\u5355\u4e0b\u8f7d\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)reqBO);
        String appId = reqBO.getAppid();
        String privateKey = reqBO.getPrivateKey();
        String publicKey = reqBO.getPublicKey();
        String url = this.payPropertiesVo.getAliOpenApiDomain();
        String format = "json";
        String charset = "utf-8";
        String signType = "RSA2";
        String billDate = this.convertDate(reqBO.getBillDate());
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(url, appId, privateKey, format, charset, publicKey, signType);
        AlipayDataDataserviceBillDownloadurlQueryRequest request = new AlipayDataDataserviceBillDownloadurlQueryRequest();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("bill_type", "trade");
        dataMap.put("bill_date", billDate);
        request.setBizContent(JSON.toJSONString(dataMap));
        AlipayDataDataserviceBillDownloadurlQueryResponse response = null;
        try {
            response = (AlipayDataDataserviceBillDownloadurlQueryResponse)alipayClient.execute((AlipayRequest)request);
        }
        catch (AlipayApiException e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        if (response == null || !response.isSuccess()) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", response == null ? "\u652f\u4ed8\u5b9d\u83b7\u53d6\u8d26\u5355\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a" : response.getSubMsg());
        }
        String billDownloadUrl = response.getBillDownloadUrl();
        String filePath = BillFileManager.getPaymentInsFilePath((String)reqBO.getBillDate(), (String)appId, (String)FILE_NAME, (String)FILE_SUFFIX);
        this.downloadBillFile(billDownloadUrl, filePath);
        return filePath;
    }

    private String convertDate(String date) {
        return date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8);
    }

    private String getFilePath(AliPayBillDownloadBusiServiceReqBO reqBO) {
        StringBuilder filePath = new StringBuilder(16);
        filePath.append(".//");
        filePath.append(reqBO.getAppid());
        filePath.append("-");
        filePath.append(reqBO.getBillDate());
        filePath.append(".zip");
        return filePath.toString();
    }

    private void downloadBillFile(String downloadUrl, String filePath) {
        try {
            URL url = new URL(downloadUrl);
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setConnectTimeout(5000);
            httpUrlConnection.setDoInput(true);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setUseCaches(false);
            httpUrlConnection.setRequestMethod("GET");
            httpUrlConnection.setRequestProperty("CHARSET", "UTF-8");
            httpUrlConnection.connect();
            InputStream fileInputStream = httpUrlConnection.getInputStream();
            File file = new File(filePath);
            logger.debug("\u652f\u4ed8\u5b9d\u8d26\u5355\u6587\u4ef6\u4e34\u65f6\u8def\u5f84\uff1a{}", (Object)file.getAbsolutePath());
            byte[] buffer = new byte[1024];
            FileOutputStream out = new FileOutputStream(file);
            int byteRead = 0;
            while ((byteRead = fileInputStream.read(buffer)) != -1) {
                out.write(buffer, 0, byteRead);
            }
            fileInputStream.close();
            out.close();
            httpUrlConnection.disconnect();
        }
        catch (Exception e) {
            logger.info("\u4e0b\u8f7d\u5bf9\u5e10\u6587\u4ef6\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u652f\u4ed8\u5b9d\u8d26\u5355\u4e0b\u8f7d\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private List<String> unZip(String filename) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ZipEntry entry;
            ZipFile zf = new ZipFile(filename, Charset.forName("GBK"));
            FileInputStream in = new FileInputStream(filename);
            ZipInputStream zin = new ZipInputStream((InputStream)in, Charset.forName("GBK"));
            while ((entry = zin.getNextEntry()) != null && !entry.isDirectory()) {
                String line;
                long size;
                if (entry.getName().lastIndexOf("\u4e1a\u52a1\u660e\u7ec6.csv") == -1 || (size = entry.getSize()) <= 0L) continue;
                StringBuilder builder = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(entry), "GBK"));
                while ((line = br.readLine()) != null) {
                    builder.append(line + "\n");
                }
                br.close();
                String[] dataStrs = builder.toString().replace(" ", "").replace("\t", "").split("\n");
                logger.info(builder.toString());
                for (int i = 5; i < dataStrs.length - 4; ++i) {
                    list.add(dataStrs[i].replace(",", ";"));
                }
            }
            zin.closeEntry();
            zin.close();
            zf.close();
            in.close();
        }
        catch (Exception e) {
            logger.info("\u8bf7\u6c42\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

