/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ali.model;

import com.google.gson.annotations.SerializedName;
import com.tydic.payment.pay.ali.model.ExtendParams;
import com.tydic.payment.pay.ali.model.RequestBuilder;
import org.apache.commons.lang.StringUtils;

public class AlipayTradeWebRequestBuilder
extends RequestBuilder {
    private BizContent bizContent = new BizContent();

    @Override
    public boolean validate() {
        if (StringUtils.isEmpty((String)this.bizContent.outTradeNo)) {
            throw new NullPointerException("out_trade_no should not be NULL!");
        }
        if (StringUtils.isEmpty((String)this.bizContent.totalAmount)) {
            throw new NullPointerException("total_amount should not be NULL!");
        }
        if (StringUtils.isEmpty((String)this.bizContent.subject)) {
            throw new NullPointerException("subject should not be NULL!");
        }
        return true;
    }

    @Override
    public Object getBizContent() {
        return this.bizContent;
    }

    public AlipayTradeWebRequestBuilder() {
        this.bizContent.product_code = "FAST_INSTANT_TRADE_PAY";
        this.bizContent.goods_type = "0";
    }

    public String getOutTradeNo() {
        return this.bizContent.outTradeNo;
    }

    @Override
    public AlipayTradeWebRequestBuilder setAppAuthToken(String appAuthToken) {
        return (AlipayTradeWebRequestBuilder)super.setAppAuthToken(appAuthToken);
    }

    @Override
    public AlipayTradeWebRequestBuilder setNotifyUrl(String notifyUrl) {
        return (AlipayTradeWebRequestBuilder)super.setNotifyUrl(notifyUrl);
    }

    @Override
    public AlipayTradeWebRequestBuilder setRerutnUrl(String rerutnUrl) {
        return (AlipayTradeWebRequestBuilder)super.setRerutnUrl(rerutnUrl);
    }

    public AlipayTradeWebRequestBuilder setOutTradeNo(String outTradeNo) {
        this.bizContent.outTradeNo = outTradeNo;
        return this;
    }

    public String getTotalAmount() {
        return this.bizContent.totalAmount;
    }

    public AlipayTradeWebRequestBuilder setTotalAmount(String totalAmount) {
        this.bizContent.totalAmount = totalAmount;
        return this;
    }

    public String getSubject() {
        return this.bizContent.subject;
    }

    public AlipayTradeWebRequestBuilder setSubject(String subject) {
        this.bizContent.subject = subject;
        return this;
    }

    public String getBody() {
        return this.bizContent.body;
    }

    public AlipayTradeWebRequestBuilder setBody(String body) {
        this.bizContent.body = body;
        return this;
    }

    public ExtendParams getExtendParams() {
        return this.bizContent.extendParams;
    }

    public AlipayTradeWebRequestBuilder setExtendParams(ExtendParams extendParams) {
        this.bizContent.extendParams = extendParams;
        return this;
    }

    public String getTimeoutExpress() {
        return this.bizContent.timeoutExpress;
    }

    public AlipayTradeWebRequestBuilder setTimeoutExpress(String timeoutExpress) {
        this.bizContent.timeoutExpress = timeoutExpress;
        return this;
    }

    public String getProduct_code() {
        return this.bizContent.product_code;
    }

    public static class BizContent {
        private String body;
        private String subject;
        @SerializedName(value="out_trade_no")
        private String outTradeNo;
        @SerializedName(value="timeout_express")
        private String timeoutExpress;
        @SerializedName(value="total_amount")
        private String totalAmount;
        private String product_code;
        private String goods_type;
        @SerializedName(value="extend_params")
        private ExtendParams extendParams;
        @SerializedName(value="qr_pay_mode")
        private String qr_pay_mode;
        @SerializedName(value="qrcode_width")
        private String qrcode_width;

        public String toString() {
            StringBuilder sb = new StringBuilder("BizContent{");
            sb.append(", body='").append(this.body).append('\'');
            sb.append(", subject='").append(this.subject).append('\'');
            sb.append("outTradeNo='").append(this.outTradeNo).append('\'');
            sb.append(", totalAmount='").append(this.totalAmount).append('\'');
            sb.append(", extendParams=").append(this.extendParams);
            sb.append(", timeoutExpress='").append(this.timeoutExpress).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

