/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.busi.CallNoticeQsMqProduceService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PorderDetallMapper;
import com.tydic.payment.pay.dao.po.PorderDetallPo;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="callNoticeQsMqProduceService")
public class CallNoticeQsMqProduceServiceImpl
implements CallNoticeQsMqProduceService {
    private static final Logger log = LoggerFactory.getLogger(CallNoticeQsMqProduceServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PorderDetallMapper porderDetallMapper;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public CallBackNoticeRspBo sendMsg(CallBackNoticeReqBo reqBo) {
        CallBackNoticeRspBo callBackNoticeRspBo = new CallBackNoticeRspBo();
        PorderPo orderInfo = null;
        if (reqBo == null) {
            log.info("\u6d88\u606f\u53d1\u9001\u7684\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6d88\u606f\u53d1\u9001\u7684\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            log.info("\u6d88\u606f\u5165\u53c2 \uff1a orderId \u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6d88\u606f\u5165\u53c2 \uff1a orderId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        orderInfo = this.payOrderAtomService.queryPorderInfo(reqBo.getOrderId());
        if (orderInfo == null) {
            log.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        String create_time = "";
        if ("06".equals(reqBo.getNoticeType()) || "02".equals(reqBo.getNoticeType())) {
            if (!reqBo.getParams().containsKey("orderId")) {
                log.info("\u9000\u6b3e\u8ba2\u5355\u8bf7\u4f20\u5165\u9000\u6b3e\u8ba2\u5355\u53f7");
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            PorderPo orderRefund = this.payOrderAtomService.queryPorderInfo(Long.parseLong((String)reqBo.getParams().get("orderId")));
            if (orderRefund == null) {
                log.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            create_time = this.simpleDateFormat.format(orderRefund.getCreateTime());
        } else {
            create_time = this.simpleDateFormat.format(orderInfo.getCreateTime());
        }
        log.info("\u652f\u4ed8\u4e2d\u5fc3\u51c6\u5907\u8c03\u4e86\uff0c\u5f00\u59cb\u5199\u5165\u961f\u5217\u6570\u636e\u5230\u6e05\u7b97\u4e2d\u5fc3!");
        String tag = "";
        Object obj = null;
        if ("02".equals(reqBo.getNoticeType())) {
            tag = "TAGQSrefund";
            obj = this.packagePayNoticeData(orderInfo, Long.parseLong((String)reqBo.getParams().get("orderId")), reqBo.getOrderId(), create_time, reqBo.getNoticeType());
        } else if ("06".equals(reqBo.getNoticeType())) {
            tag = "TAGQSrefund";
            obj = this.packagePayNoticeData(orderInfo, Long.parseLong((String)reqBo.getParams().get("orderId")), Long.parseLong((String)reqBo.getParams().get("orderId")), create_time, reqBo.getNoticeType());
        } else {
            tag = "TAGQSpay";
            obj = this.packagePayNoticeData(orderInfo, reqBo.getOrderId(), reqBo.getOrderId(), create_time, "01");
        }
        return callBackNoticeRspBo;
    }

    public Object packagePayNoticeData(PorderPo orderInfo, Long refunId, Long orderId, String create_time, String orderType) {
        List<PorderPayTransPo> payTransPos = this.queryPorderPayTrans(orderInfo);
        List<PorderDetallPo> porderDetalls = this.queryPorderDetalls(orderId);
        BigDecimal realFee = MoneyUtils.haoToYuan((Long)orderInfo.getRealFee());
        JSONObject data = new JSONObject();
        JSONObject ORDER_INFO = new JSONObject();
        ORDER_INFO.put("ORDER_ID", (Object)refunId);
        ORDER_INFO.put("IN_MODE_CODE", (Object)orderInfo.getInModeCode());
        ORDER_INFO.put("STORE_ID", (Object)orderInfo.getStoreId());
        ORDER_INFO.put("OUT_ORDER_ID", (Object)orderInfo.getOutOrderId());
        ORDER_INFO.put("MERCHANT_ID", (Object)orderInfo.getMerchantId());
        ORDER_INFO.put("BUSINESS_ID", (Object)"");
        ORDER_INFO.put("REAL_FEE", (Object)realFee);
        ORDER_INFO.put("DETAIL_NAME", (Object)orderInfo.getDetailName());
        ORDER_INFO.put("REDIRECT_URL", (Object)orderInfo.getRedirectUrl());
        ORDER_INFO.put("NOTIFY_URL", (Object)orderInfo.getNotifyUrl());
        ORDER_INFO.put("USER_ACCOUNT", (Object)orderInfo.getUserAccount());
        ORDER_INFO.put("USER_MOBILE", (Object)orderInfo.getUserMobile());
        ORDER_INFO.put("ORDER_ATTR_VALUE1", (Object)orderInfo.getOrderAttrValue1());
        ORDER_INFO.put("ORDER_ATTR_VALUE2", (Object)orderInfo.getOrderAttrValue2());
        ORDER_INFO.put("ORDER_ATTR_VALUE3", (Object)orderInfo.getOrderAttrValue3());
        ORDER_INFO.put("REMARK", (Object)orderInfo.getOutRemark());
        ORDER_INFO.put("CREATE_OPER_ID", (Object)orderInfo.getCreateOperId());
        ORDER_INFO.put("CREATE_OPER_ID_NAME", (Object)orderInfo.getCreateOperIdName());
        ORDER_INFO.put("PROVINCE", (Object)orderInfo.getProvinceId());
        ORDER_INFO.put("CITY", (Object)orderInfo.getCityId());
        ORDER_INFO.put("DISTRICT", (Object)orderInfo.getDistrictId());
        ORDER_INFO.put("CHANNEL_ID", (Object)orderInfo.getChannelId());
        ORDER_INFO.put("STAFF_ID", (Object)orderInfo.getCreateOperId());
        ORDER_INFO.put("CREATE_TIME", (Object)create_time);
        ORDER_INFO.put("ORDER_TYPE", (Object)orderType);
        BigDecimal price = new BigDecimal("0");
        BigDecimal goodsFee = new BigDecimal("0");
        BigDecimal settPrice = new BigDecimal("0");
        BigDecimal offerShareFee = new BigDecimal("0");
        JSONArray goodsInfo = new JSONArray();
        for (PorderDetallPo porderDetall : porderDetalls) {
            if (!StringUtils.isEmpty((Object)porderDetall.getGoodsPrice())) {
                price = MoneyUtils.haoToYuan((Long)porderDetall.getGoodsPrice());
            }
            if (!StringUtils.isEmpty((Object)porderDetall.getGoodsFee())) {
                goodsFee = MoneyUtils.haoToYuan((Long)porderDetall.getGoodsFee());
            }
            if (!StringUtils.isEmpty((Object)porderDetall.getOfferShareFee())) {
                offerShareFee = MoneyUtils.haoToYuan((Long)porderDetall.getOfferShareFee());
            }
            if (porderDetall.getSettPrice() != null) {
                settPrice = MoneyUtils.haoToYuan((Long)porderDetall.getSettPrice());
            }
            JSONObject OFFER_INFO = new JSONObject();
            OFFER_INFO.put("GOODS_NAME", (Object)porderDetall.getGoodsName());
            OFFER_INFO.put("GOODS_ID", (Object)porderDetall.getGoodsId());
            OFFER_INFO.put("BRAND_CODE", (Object)porderDetall.getBrandCode());
            OFFER_INFO.put("OFFER_TYPE", (Object)porderDetall.getOfferType());
            OFFER_INFO.put("OFFER_DIVIDE", (Object)porderDetall.getOfferDivide());
            OFFER_INFO.put("BELONG_PLATFORM", (Object)porderDetall.getBelongPlatform());
            OFFER_INFO.put("OFFER_SUPPLIER", (Object)porderDetall.getOfferSupplier());
            OFFER_INFO.put("BELONG_STOCK", (Object)porderDetall.getBelongStock());
            OFFER_INFO.put("SETT_PRICE", (Object)settPrice);
            OFFER_INFO.put("OFFER_TAX", (Object)porderDetall.getOfferTax());
            OFFER_INFO.put("GOODS_PRICE", (Object)price);
            OFFER_INFO.put("GOODS_NUM", (Object)porderDetall.getGoodsNum());
            OFFER_INFO.put("PARENT_OFFER_ID", (Object)porderDetall.getParentOfferId());
            OFFER_INFO.put("OFFER_SHARE_FEE", (Object)offerShareFee);
            goodsInfo.add((Object)OFFER_INFO);
        }
        if (goodsInfo.size() > 0) {
            ORDER_INFO.put("GOODS_DETAIL", (Object)goodsInfo);
        }
        log.info("\u8981\u63a8\u9001\u7684\u5bf9\u8c61\u4e3a\uff1a" + ORDER_INFO);
        return JSONObject.toJSONString((Object)ORDER_INFO);
    }

    public List<PorderPayTransPo> queryPorderPayTrans(PorderPo orderInfo) {
        PorderPayTransPo porderPayTransPo = new PorderPayTransPo();
        porderPayTransPo.setOrderId(orderInfo.getOrderId());
        porderPayTransPo.setOrderStatus("A10");
        List<PorderPayTransPo> pOrderTrans = this.porderPayTransAtomService.queryOrderPayTrans(porderPayTransPo);
        if (pOrderTrans.size() == 0) {
            log.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        if (!"01".equals(orderInfo.getOrderType())) {
            log.info("\u8ba2\u5355\u53f7 \u3010orderId \u3011 =" + orderInfo.getOrderId() + "\u4e0d\u662f\u652f\u4ed8\u8ba2\u5355");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u53f7 \u3010orderId \u3011 =" + orderInfo.getOrderId() + "\u4e0d\u662f\u652f\u4ed8\u8ba2\u5355");
        }
        if ("A00".equals(orderInfo.getOrderStatus())) {
            log.info("\u8ba2\u5355\u53f7 \u3010orderId \u3011 =" + orderInfo.getOrderId() + "\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u53d1\u8d77\u901a\u77e5");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u53f7 \u3010orderId \u3011 =" + orderInfo.getOrderId() + "\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u53d1\u8d77\u901a\u77e5");
        }
        return pOrderTrans;
    }

    public List<PorderDetallPo> queryPorderDetalls(Long orderId) {
        PorderDetallPo porderDetall = new PorderDetallPo();
        porderDetall.setOrderId(orderId);
        ArrayList<PorderDetallPo> porderDetalls = new ArrayList();
        try {
            porderDetalls = this.porderDetallMapper.getList(porderDetall);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return porderDetalls;
    }
}

