/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.busi.PayProWxUnifiedOrderBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProWxUnifiedOrderBusiRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.OrderConstant;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.wx.req.bo.WXApiUnifiedOrderReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiUnifiedOrderRspBO;
import com.tydic.payment.pay.wx.util.HttpsRequest;
import com.tydic.payment.pay.wx.util.Signature;
import com.tydic.payment.pay.wx.util.Util;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayProWxUnifiedOrderBusiServiceImpl
implements PayProWxUnifiedOrderBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProWxUnifiedOrderBusiServiceImpl.class);
    private static final String EXPIRE_TIME = "3";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    private static final String SUCCESS = "SUCCESS";

    public PayProWxUnifiedOrderBusiRspBo unifiedOrder(PayProWxUnifiedOrderBusiReqBo reqBo) {
        WXApiUnifiedOrderRspBO rsp;
        String appId;
        PayProWxUnifiedOrderBusiRspBo retBo;
        block18: {
            retBo = new PayProWxUnifiedOrderBusiRspBo();
            String validateArgStr = this.validateArg(reqBo);
            if (!StringUtils.isEmpty((Object)validateArgStr)) {
                retBo.setRespCode("212005");
                retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
                return retBo;
            }
            retBo.setPayOrderId(reqBo.getPayOrderId());
            Date startTime = this.queryDBDateBusiService.getDBDate();
            Date expireTime = new DateTime((Object)startTime).plusMinutes(Integer.parseInt(reqBo.getExtTime())).toDate();
            String wxUnifiedOrderUrl = this.payPropertiesVo.getWXUnifiedOrderUrl();
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u670d\u52a1 -> \u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u5730\u5740\uff1a" + wxUnifiedOrderUrl);
            }
            Map paraMap = reqBo.getParaMap();
            String payMethod = reqBo.getPayMethod();
            String mchId = (String)paraMap.get("mchid");
            String signKey = (String)paraMap.get("signkey");
            appId = (String)reqBo.getParaMap().get("appid");
            if ("15".equals(payMethod)) {
                appId = reqBo.getAppletAppId();
            } else if ("12".equals(payMethod)) {
                appId = reqBo.getAppPayAppId();
            }
            String wxPayResultNotifyUrl = this.payPropertiesVo.getWxPayResultNotifyUrl();
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u670d\u52a1 -> \u56de\u8c03\u5730\u5740\uff1a" + wxPayResultNotifyUrl);
            }
            WXApiUnifiedOrderReqBO unifiedOrderReqData = null;
            try {
                unifiedOrderReqData = new WXApiUnifiedOrderReqBO().setAppid(appId).setMch_id(mchId).setDevice_info(reqBo.getDeviceInfo()).setBody(reqBo.getBody()).setOut_trade_no(reqBo.getPayOrderId()).setTotal_fee(Integer.parseInt(reqBo.getTotalFee())).setSpbill_create_ip(reqBo.getSpbillCreateIp()).setProduct_id(reqBo.getProductId()).setTrade_type(reqBo.getTradeType()).setOpenid(reqBo.getOpenId()).setNotify_url(wxPayResultNotifyUrl).setScene_info(reqBo.getSceneInfo()).setTime_start(startTime).setTime_expire(expireTime).setNonce_str("").setKey(signKey);
            }
            catch (ParseException e) {
                LOG.error("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355(payPro)\u670d\u52a1\u5f02\u5e38\uff1a" + e);
                throw new BusinessException("216005", "\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355(payPro)\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            }
            if (unifiedOrderReqData == null) {
                LOG.error("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u5bf9\u8c61(WXApiUnifiedOrderReqBO)\u4e3a\u7a7a");
                throw new BusinessException("216005", "\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u5bf9\u8c61(WXApiUnifiedOrderReqBO)\u4e3a\u7a7a");
            }
            String resultString = null;
            try {
                HttpsRequest httpsRequest = new HttpsRequest();
                resultString = httpsRequest.sendPostPayPro(wxUnifiedOrderUrl, (Object)unifiedOrderReqData);
                LOG.info("----------------------------\u5fae\u4fe1\u4e0b\u5355\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b----------------------------");
                LOG.info(resultString);
            }
            catch (Exception e) {
                LOG.error("\u5411\u5fae\u4fe1\u4e0b\u5355\u5f02\u5e38\uff1a" + e);
                throw new BusinessException("216005", "\u5411\u5fae\u4fe1\u4e0b\u5355\u5f02\u5e38\uff1a" + e);
            }
            if (StringUtils.isEmpty((Object)resultString)) {
                LOG.error("\u5fae\u4fe1\u4e0b\u5355\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a");
                throw new BusinessException("216005", "\u5fae\u4fe1\u4e0b\u5355\u8fd4\u56de\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            }
            rsp = (WXApiUnifiedOrderRspBO)Util.getObjectFromXMLGeneric((String)resultString, WXApiUnifiedOrderRspBO.class);
            if (rsp != null && SUCCESS.equals(rsp.getReturn_code()) && SUCCESS.equals(rsp.getResult_code())) {
                try {
                    if (!Signature.checkIsSignValidFromResponseString((String)resultString, (String)unifiedOrderReqData.getKey())) {
                        LOG.error("\u5fae\u4fe1\u4e0b\u5355\u8fd4\u56de\u540e\u7b7e\u540d\u9519\u8bef");
                        throw new BusinessException("216005", "\u5fae\u4fe1\u4e0b\u5355\u8fd4\u56de\u540e\u7b7e\u540d\u9519\u8bef");
                    }
                    break block18;
                }
                catch (Exception e) {
                    LOG.error("\u5fae\u4fe1\u4e0b\u5355\u8fd4\u56de\u540e\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
                    throw new BusinessException("216005", "\u5fae\u4fe1\u4e0b\u5355\u8fd4\u56de\u540e\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
                }
            }
            retBo.setRespCode("212005");
            if (rsp != null) {
                retBo.setRespDesc("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + rsp.getErr_code_des() + "-" + rsp.getReturn_msg());
            } else {
                retBo.setRespDesc("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1arsp\u5bf9\u8c61\u4e3a\u7a7a");
            }
            return retBo;
        }
        retBo.setAppId(appId);
        retBo.setCodeUrl(rsp.getCode_url());
        retBo.setMwebUrl(rsp.getMweb_url());
        retBo.setPrepayId(rsp.getPrepay_id());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u5fae\u4fe1\u4e0b\u5355\u6210\u529f");
        return retBo;
    }

    private String validateArg(PayProWxUnifiedOrderBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        if (paraMap == null || paraMap.isEmpty()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("mchid"))) {
            return "paraMap\u4e2dmchid\u5fc5\u4f20";
        }
        if (StringUtils.isEmpty(paraMap.get("signkey"))) {
            return "paraMap\u4e2dsignkey\u5fc5\u4f20";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String payMethod = reqBo.getPayMethod();
        if (StringUtils.isEmpty((Object)payMethod)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payMethod\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("14".equals(payMethod) || "15".equals(payMethod)) {
            if (StringUtils.isEmpty((Object)reqBo.getSpbillCreateIp())) {
                return "\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u65f6:spbillCreateIp\u5fc5\u4f20";
            }
            if (StringUtils.isEmpty((Object)reqBo.getOpenId())) {
                return "\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u65f6:openId\u5fc5\u4f20";
            }
            reqBo.setTradeType(OrderConstant.WxTradeType.JSAPI.getTradeType());
        } else if ("13".equals(payMethod)) {
            reqBo.setTradeType(OrderConstant.WxTradeType.MWEB.getTradeType());
        } else if ("12".equals(payMethod)) {
            if (StringUtils.isEmpty((Object)reqBo.getSpbillCreateIp())) {
                return "app\u652f\u4ed8\u65f6:spbillCreateIp\u5fc5\u4f20";
            }
            reqBo.setTradeType(OrderConstant.WxTradeType.APP.getTradeType());
        } else if ("11".equals(payMethod)) {
            reqBo.setTradeType(OrderConstant.WxTradeType.NATIVE.getTradeType());
        } else {
            return "\u4e0d\u652f\u6301\u7684\u652f\u4ed8\u65b9\u5f0f\uff08" + payMethod + "\uff09";
        }
        if ("15".equals(payMethod) && StringUtils.isEmpty((Object)reqBo.getAppletAppId())) {
            return "\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u65f6\uff0cappletAppId\u5fc5\u4f20";
        }
        if ("12".equals(payMethod) && StringUtils.isEmpty((Object)reqBo.getAppPayAppId())) {
            return "APP\u652f\u4ed8\u65f6\uff0cappPayAppId\u5fc5\u4f20";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBody())) {
            return "\u5546\u54c1\u63cf\u8ff0\uff1abody\u5fc5\u4f20";
        }
        String totalFee = reqBo.getTotalFee();
        if (StringUtils.isEmpty((Object)totalFee)) {
            return "totalFee\u5fc5\u4f20";
        }
        try {
            Long.parseLong(totalFee);
        }
        catch (NumberFormatException e) {
            return "totalFee\u5fc5\u987b\u4e3a\u6570\u5b57";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            reqBo.setExtTime(EXPIRE_TIME);
        }
        return null;
    }
}

