/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.bo.PayProBaseRspBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.PayProOrderQueryBusiService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.busi.impl.CallBackNoticeServiceImpl;
import com.tydic.payment.pay.comb.PayProTriggerCallSysCombService;
import com.tydic.payment.pay.comb.bo.PayProTriggerCallSysCombRspBo;
import com.tydic.payment.pay.comb.bo.PayProTriigerCallSysCombReqBo;
import com.tydic.payment.pay.common.util.HttpUtil;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProTriggerCallSysCombService.class)
public class PayProTriggerCallSysCombServiceImpl
implements PayProTriggerCallSysCombService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayProOrderQueryBusiService payProOrderQueryBusiService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService payProQueryInfoBusiSystemByConditionService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;

    public PayProTriggerCallSysCombRspBo callSys(PayProTriigerCallSysCombReqBo reqBo) {
        this.LOGGER.info("\u63a5\u53d7\u5916\u90e8\u4e3b\u52a8\u89e6\u53d1\u8bf7\u6c42\u56de\u8c03\u5165\u53c2\u4e3a\uff1a" + JSONObject.toJSONString((Object)reqBo));
        PayProTriggerCallSysCombRspBo rspBo = new PayProTriggerCallSysCombRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        String busiCode = reqBo.getBusiCode();
        String outOrderId = reqBo.getOutOrderId();
        String orderId = reqBo.getOrderId();
        Long orderIdLong = 0L;
        if (!StringUtils.isEmpty((Object)orderId)) {
            orderIdLong = Long.parseLong(orderId);
        } else {
            PayProQueryInfoBusiSystemByConditionBusiInfoRspBo qryBusiCode = this.payProQueryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
            if (!"0000".equals(qryBusiCode.getRespCode())) {
                rspBo.setRespCode(qryBusiCode.getRespCode());
                rspBo.setRespDesc(qryBusiCode.getRespDesc());
                return rspBo;
            }
            PayProOrderQueryBusiReqBo queryOrderBo = new PayProOrderQueryBusiReqBo();
            queryOrderBo.setOutOrderId(outOrderId);
            queryOrderBo.setBusiId(qryBusiCode.getBusiId());
            PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo orderIdRspBo = this.payProOrderQueryBusiService.queryOrderQueryByBusiIdAndOutOrderId(queryOrderBo);
            if (!"0000".equals(orderIdRspBo.getRespCode())) {
                rspBo.setRespCode(orderIdRspBo.getRespCode());
                rspBo.setRespDesc(orderIdRspBo.getRespDesc());
                return rspBo;
            }
            orderId = orderIdRspBo.getOrderId().toString();
            orderIdLong = orderIdRspBo.getOrderId();
        }
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderIdLong);
        if (orderInfo == null) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)orderInfo.getNotifyUrl())) {
            this.LOGGER.debug("\u8ba2\u5355\u65e0notifyUrl\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u5f02\u6b65\u901a\u77e5\uff1borderId = " + orderInfo.getOrderId());
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u8ba2\u5355\u65e0notifyUrl\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u5f02\u6b65\u901a\u77e5\uff1borderId = " + orderInfo.getOrderId());
            return rspBo;
        }
        if (!"01".equals(orderInfo.getOrderType())) {
            this.LOGGER.debug("\u8ba2\u5355\u53f7orderId(" + orderInfo.getOrderId() + ")\u4e0d\u662f\u652f\u4ed8\u8ba2\u5355");
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8ba2\u5355\u53f7orderId(" + orderInfo.getOrderId() + ")\u4e0d\u662f\u652f\u4ed8\u8ba2\u5355");
            return rspBo;
        }
        if ("A00".equals(orderInfo.getOrderStatus())) {
            this.LOGGER.debug("\u8ba2\u5355\u53f7orderId(" + orderInfo.getOrderId() + ")\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u53d1\u8d77\u901a\u77e5");
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8ba2\u5355\u53f7orderId(" + orderInfo.getOrderId() + ")\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u53d1\u8d77\u901a\u77e5");
            return rspBo;
        }
        PorderPayTransPo porderPayTransPo = new PorderPayTransPo();
        porderPayTransPo.setOrderId(orderIdLong);
        porderPayTransPo.setOrderStatus("A10");
        List<PorderPayTransPo> pOrderTrans = this.porderPayTransAtomService.queryOrderPayTrans(porderPayTransPo);
        if (pOrderTrans.size() == 0) {
            this.LOGGER.error("\u8be5\u8ba2\u5355(" + orderId + ")\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f");
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8be5\u8ba2\u5355(" + orderId + ")\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f");
            return rspBo;
        }
        BusiSystemInfoPO busiSystemInfoPO = new BusiSystemInfoPO();
        busiSystemInfoPO.setBusiId(orderInfo.getBusiId());
        List<BusiSystemInfoPO> busiSystem = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiSystemInfoPO);
        if (busiSystem.size() == 0) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230 \u4e1a\u52a1\u7cfb\u7edf\u3010busiId = " + orderInfo.getBusiId() + "\u3011\u7684\u4fe1\u606f");
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230 \u4e1a\u52a1\u7cfb\u7edf\u3010busiId = " + orderInfo.getBusiId() + "\u3011\u7684\u4fe1\u606f");
            return rspBo;
        }
        Object obj = CallBackNoticeServiceImpl.packagPayNoticeData(orderInfo, pOrderTrans);
        String payNotifyTransId = pOrderTrans.get(0).getPayNotifyTransId();
        this.LOGGER.info("\u652f\u4ed8\u4e2d\u5fc3\u56de\u8c03\u7684payNotifyTransId\u4e3a\uff1a" + payNotifyTransId);
        this.LOGGER.info("\u652f\u4ed8\u4e2d\u5fc3\u51c6\u5907\u8c03\u4e86\uff0c\u56de\u8c03\u7c7b\u578b\u4e3a\uff1a" + busiSystem.get(0).getCallType());
        int callType = busiSystem.get(0).getCallType();
        if (3 == callType) {
            JSONObject data = JSONObject.parseObject((String)obj.toString());
            this.assignData(data, pOrderTrans.get(0));
            data.put("callType", (Object)callType);
            data.put("notifyUrl", (Object)orderInfo.getNotifyUrl());
            data.put("payNotifyTransId", (Object)payNotifyTransId);
            this.LOGGER.info("\u652f\u4ed8\u4e2d\u5fc3\u901a\u8fc7http\u56de\u8c03\u7684\u53c2\u6570\uff1a" + data.toJSONString());
            PayProBaseRspBo callRsp = this.dealPayNoticeByHttp(JSONObject.toJSONString((Object)data));
            if (!"0000".equals(callRsp.getRespCode())) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc(callRsp.getRespDesc());
                return rspBo;
            }
        } else {
            this.LOGGER.error("\u4e0d\u652f\u6301\u7684\u5f02\u6b65\u901a\u77e5\u7c7b\u578b\u4e3a\uff1acallType = " + callType + ",\u4ec5\u652f\u6301http\u56de\u8c03");
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u4e0d\u652f\u6301\u7684\u5f02\u6b65\u901a\u77e5\u7c7b\u578b\u4e3a\uff1acallType = " + callType);
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public PayProBaseRspBo dealPayNoticeByHttp(String data) {
        PayProBaseRspBo rspBo = new PayProBaseRspBo();
        this.LOGGER.info("\u652f\u4ed8\u7ed3\u679chttp\u56de\u8c03\uff0c\u63a5\u6536\u5230\u56de\u8c03\u7684\u5165\u53c2\u4e3a\uff1a" + data);
        JSONObject req = JSONObject.parseObject((String)data);
        String busiId = req.getString("busiId");
        String notifyUrl = req.getString("notifyUrl");
        req.remove((Object)"busiId");
        req.remove((Object)"notifyUrl");
        String orderId = req.getString("transactionsId");
        PorderPo tempOrder = this.payOrderAtomService.queryPorderInfo(Long.parseLong(orderId));
        PorderPo pOrder = new PorderPo();
        pOrder.setOrderId(tempOrder.getOrderId());
        try {
            DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
            dataEncryptionReqBo.setBusiId(String.valueOf(tempOrder.getBusiId()));
            dataEncryptionReqBo.setContent(req.toJSONString());
            DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
            this.LOGGER.info("\u6d88\u606f\u53d1\u9001\u7684\u4e3b\u9898\u5185\u5bb9\u4e3a \uff1a" + dataEncryptionRspBo.getEncrypData() + "\u76ee\u6807\u5730\u5740\u4e3a\uff1a" + notifyUrl);
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put("busiId", tempOrder.getBusiId() + "");
            postParams.put("busiCode", tempOrder.getBusiCode());
            postParams.put("content", dataEncryptionRspBo.getEncrypData());
            String resultData = HttpUtil.sendPost((String)notifyUrl, postParams);
            this.LOGGER.info("busiCode = " + busiId + "\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + resultData);
            if (resultData.contains("NOTIFY_RESULT") || resultData.contains("notifyResult")) {
                if (resultData.contains("SUCCESS")) {
                    pOrder.setCustyNotifyCode("0");
                    pOrder.setCustNotifyMsg("SUCCESS");
                } else {
                    pOrder.setCustyNotifyCode("1");
                    pOrder.setCustNotifyMsg("FAIL");
                }
            } else {
                pOrder.setCustyNotifyCode("1");
                pOrder.setCustNotifyMsg("FAIL");
            }
        }
        catch (Exception e) {
            this.LOGGER.error("\u56de\u8c03\u901a\u77e5\u5f02\u5e38\uff1a orderId = " + orderId + "\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), (Throwable)e);
            pOrder.setCustyNotifyCode("1");
            pOrder.setCustNotifyMsg(e.getMessage());
        }
        if (!"0".equals(pOrder.getCustyNotifyCode()) || !"SUCCESS".equals(pOrder.getCustNotifyMsg())) {
            rspBo.setRespDesc(pOrder.getCustNotifyMsg());
            rspBo.setRespCode("8888");
            return rspBo;
        }
        pOrder.setCustNotifyTime(this.queryDBDateBusiService.getDBDate());
        try {
            this.payOrderAtomService.update(pOrder);
        }
        catch (Exception e) {
            this.LOGGER.error("\u56de\u8c03\u6d88\u606f\u961f\u5217\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            rspBo.setRespDesc("\u66f4\u65b0\u56de\u8c03\u7ed3\u679c\u5f02\u5e38\uff1a" + e.getMessage());
            rspBo.setRespCode("8888");
            return rspBo;
        }
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setRespCode("0000");
        return rspBo;
    }

    private void assignData(JSONObject data, PorderPayTransPo payTransPo) {
        MerChantInfoPo merChantInfo;
        Long merchantId = payTransPo.getMerchantId();
        Long payMethod = payTransPo.getPayMethod();
        if (null != merchantId && null != (merChantInfo = this.merchantInfoAtomService.queryMerchantInfoById(merchantId))) {
            data.put("merchantName", (Object)merChantInfo.getMerchantName());
        }
        if (null != payMethod) {
            PayMethodPo methodInfo = this.payMethodAtomService.queryPayMethodById(payMethod);
            if (null != methodInfo) {
                data.put("payMethodName", (Object)methodInfo.getPayMethodName());
            }
            PaymentInsPo paymentInsPo = new PaymentInsPo();
            paymentInsPo.setPaymentInsId(methodInfo.getPaymentInsId());
            List<PaymentInsPo> paymentInsList = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
            if (!CollectionUtils.isEmpty(paymentInsList)) {
                PaymentInsPo paymentInsInfo = paymentInsList.get(0);
                data.put("paymentInsId", (Object)paymentInsInfo.getPaymentInsId());
                data.put("paymentInsName", (Object)paymentInsInfo.getPaymentInsName());
            }
        }
    }

    private String validateArg(PayProTriigerCallSysCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String busiCode = reqBo.getBusiCode();
        String outOrderId = reqBo.getOutOrderId();
        String orderId = reqBo.getOrderId();
        if (!StringUtils.isEmpty((Object)orderId)) {
            try {
                Long.parseLong(orderId);
            }
            catch (NumberFormatException e) {
                return "orderId\u5fc5\u987b\u4e3a\u6570\u5b57";
            }
        } else if (StringUtils.isEmpty((Object)busiCode) || StringUtils.isEmpty((Object)outOrderId)) {
            return "orderId\u4e3a\u7a7a\u65f6\uff0coutOrderId\u548cbusiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

