/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractChinaPayAble;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ChinaPayNoCardPayAbleImpl
extends AbstractChinaPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(ChinaPayNoCardPayAbleImpl.class);
    private String formHead = "<form name=\"message_form\" method=\"post\" action=\"URL\">";
    private String inputItem = "<input type=\"hidden\" name=\"CODE\" value=\"VALUE\">";
    private String submit = "<input type=\"submit\" value=\"\u7acb\u5373\u652f\u4ed8\" style=\"display:none\">";
    private String script = "<script>document.forms[0].submit();</script>";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Value(value="${china.pay.time.out:6}")
    private String payTimeOut;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.CHINA_PAY_NO_CARD.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String chinaPayUrl = this.payPropertiesVo.getValueByKey("china.pay.page.url");
        if (StringUtils.isEmpty((Object)chinaPayUrl)) {
            log.error("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.pay.page.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.pay.page.url");
            return retBo;
        }
        String chinaPayNotifyUrl = this.payPropertiesVo.getValueByKey("china.pay.notify.url");
        if (StringUtils.isEmpty((Object)chinaPayNotifyUrl)) {
            log.error("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u652f\u4ed8\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.pay.notify.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u652f\u4ed8\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.pay.notify.url");
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        String merId = (String)paraMap.get("MerId");
        DateTime nowTime = new DateTime();
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("Version", "20150922");
        requestMap.put("AccessType", "0");
        requestMap.put("MerId", merId);
        requestMap.put("MerOrderNo", reqBo.getPayOrderId());
        requestMap.put("TranDate", nowTime.toString("yyyyMMdd"));
        requestMap.put("TranTime", nowTime.toString("HHmmss"));
        requestMap.put("OrderAmt", reqBo.getPayFee().toString());
        requestMap.put("BusiType", "0001");
        requestMap.put("CurryNo", "CNY");
        requestMap.put("PayTimeOut", this.payTimeOut);
        requestMap.put("MerPageUrl", reqBo.getRedirectUrl());
        requestMap.put("MerBgUrl", chinaPayNotifyUrl);
        requestMap.put("RemoteAddr", reqBo.getCreateIpAddress());
        String signature = super.doSign(paraMap, requestMap);
        requestMap.put("Signature", signature);
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append(this.formHead.replace("URL", chinaPayUrl));
        for (String key : requestMap.keySet()) {
            String input = this.inputItem.replace("CODE", key).replace("VALUE", (String)requestMap.get(key));
            htmlBuilder.append(input);
        }
        htmlBuilder.append(this.submit);
        htmlBuilder.append("</form>");
        htmlBuilder.append(this.script);
        if (log.isDebugEnabled()) {
            log.debug("\u7ec4\u88c5\u597d\u7684HTML\u4e3a\uff1a" + htmlBuilder.toString());
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setHtmlBody(htmlBuilder.toString());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    @Override
    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        PayAbleCallBackRspBo retBo = super.dealCallBack(reqBo);
        if (reqBo.isRefund()) {
            retBo.setRefundOrderId(retBo.getPayOrderId());
            retBo.setRefundNotifyTransId(retBo.getPayNotifyTransId());
        }
        return retBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'reqBo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCreateIpAddress())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'createIpAddress'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRedirectUrl())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'redirectUrl'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return super.validateParaMap(reqBo.getParaMap());
    }
}

