/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.CashierTemplateBoStr;
import com.tydic.payment.pay.web.bo.req.UpdateCashierWebReqBo;
import com.tydic.payment.pay.web.service.UpdateCashierWebService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=UpdateCashierWebService.class)
public class UpdateCashierWebServiceImpl
implements UpdateCashierWebService {
    private static final Logger log = LoggerFactory.getLogger(UpdateCashierWebServiceImpl.class);
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public CashierTemplateBoStr updateCashier(UpdateCashierWebReqBo reqbo) {
        log.info("\u4fee\u6539\u6536\u94f6\u53f0\u6a21\u677f -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqbo));
        CashierTemplateBoStr rspBo = new CashierTemplateBoStr();
        this.validateArg(reqbo);
        CashierTemplatePo qryCa = this.cashierTemplateAtomService.queryCashierTemplateById(Long.valueOf(reqbo.getCashierTemplate()));
        if (qryCa == null) {
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff0c\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u5b58\u5728");
            rspBo.setRspCode("8888");
            return rspBo;
        }
        CashierTemplatePo updCPo = new CashierTemplatePo();
        this.beforeCopy(reqbo, updCPo);
        int updFlag = this.cashierTemplateAtomService.updateCashierTemplate(updCPo);
        CashierTemplatePo qryCaRes = this.cashierTemplateAtomService.queryCashierTemplateById(Long.valueOf(reqbo.getCashierTemplate()));
        if (qryCaRes == null) {
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff0c\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u5b58\u5728");
            rspBo.setRspCode("8888");
            return rspBo;
        }
        BeanUtils.copyProperties((Object)qryCaRes, (Object)rspBo);
        rspBo.setCashierTemplate(qryCaRes.getCashierTemplate() == null ? "" : qryCaRes.getCashierTemplate().toString());
        rspBo.setCreateTime(qryCaRes.getCreateTime() == null ? "" : new DateTime((Object)qryCaRes.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setUpdateTime(qryCaRes.getUpdateTime() == null ? "" : new DateTime((Object)qryCaRes.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        if (updFlag < 1) {
            log.info("\u4fee\u6539\u6536\u94f6\u53f0\u6a21\u677f -> \u5931\u8d25:\u66f4\u65b0\u6570\u636e\u5e93\u8868\u5931\u8d25");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u66f4\u65b0\u6570\u636e\u5931\u8d25");
            return rspBo;
        }
        log.info("\u4fee\u6539\u6536\u94f6\u53f0\u6a21\u677f -> \u66f4\u65b0\u6570\u636e\u6210\u529f");
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u66f4\u65b0\u6570\u636e\u6210\u529f");
        return rspBo;
    }

    private void beforeCopy(UpdateCashierWebReqBo reqbo, CashierTemplatePo updatePo) {
        BeanUtils.copyProperties((Object)reqbo, (Object)updatePo);
        if (StringUtils.isEmpty((Object)reqbo.getOperId())) {
            updatePo.setUpdateOperId(reqbo.getOperId());
        }
        if (!StringUtils.isEmpty((Object)reqbo.getCashierTemplate())) {
            updatePo.setCashierTemplate(Long.valueOf(reqbo.getCashierTemplate()));
        }
        updatePo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
    }

    private void validateArg(UpdateCashierWebReqBo reqbo) {
        if (reqbo == null) {
            log.info("\u4fee\u6539\u6536\u94f6\u53f0\u6a21\u677f -> \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getCashierTemplate())) {
            log.info("\u4fee\u6539\u6536\u94f6\u53f0\u6a21\u677f -> \u5165\u53c2cashierTemplate(\u6536\u94f6\u53f0\u6a21\u677f)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqbo.getCashierTemplateName())) {
            log.info("\u4fee\u6539\u6536\u94f6\u53f0\u6a21\u677f -> \u5165\u53c2cashierTemplateName(\u6536\u94f6\u53f0\u6a21\u677f\u540d\u79f0)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6536\u94f6\u53f0\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public BaseRspInfoBO enableCashier(UpdateCashierWebReqBo reqBo) {
        log.info("\u542f\u7528\u6536\u94f6\u53f0\u6a21\u677f -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        BaseRspInfoBO rspBo = new BaseRspInfoBO();
        if (reqBo == null) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u542f\u7528\u6536\u94f6\u53f0\u6a21\u677f\u7684\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)reqBo.getCashierTemplate())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u542f\u7528\u6536\u94f6\u53f0\u6a21\u677f\u7684\u5165\u53c2cashierTemplate\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBo;
        }
        CashierTemplatePo qryCa = this.cashierTemplateAtomService.queryCashierTemplateById(Long.valueOf(reqBo.getCashierTemplate()));
        if (qryCa == null) {
            rspBo.setRspName("\u542f\u7528\u5931\u8d25\uff0c\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u5b58\u5728");
            rspBo.setRspCode("8888");
            return rspBo;
        }
        if (!qryCa.getFlag().equals("0")) {
            rspBo.setRspName("\u542f\u7528\u5931\u8d25\uff0c\u4e0d\u662f\u65e0\u6548\u72b6\u6001\u7684\u6536\u94f6\u53f0\u6a21\u677f\u65e0\u6cd5\u542f\u7528");
            rspBo.setRspCode("8888");
            return rspBo;
        }
        CashierTemplatePo updCPo = new CashierTemplatePo();
        updCPo.setCashierTemplate(Long.valueOf(reqBo.getCashierTemplate()));
        updCPo.setFlag("1");
        updCPo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
        if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
            updCPo.setUpdateOperId(reqBo.getOperId());
        }
        int updFlag = this.cashierTemplateAtomService.updateCashierTemplate(updCPo);
        CashierTemplatePo qryCaRes = this.cashierTemplateAtomService.queryCashierTemplateById(Long.valueOf(reqBo.getCashierTemplate()));
        if (qryCaRes == null) {
            rspBo.setRspName("\u542f\u7528\u5931\u8d25\uff0c\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u5b58\u5728");
            rspBo.setRspCode("8888");
            return rspBo;
        }
        if (updFlag < 1) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u542f\u7528\u5931\u8d25\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            return rspBo;
        }
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u542f\u7528\u6210\u529f");
        return rspBo;
    }

    public BaseRspInfoBO disableCashier(UpdateCashierWebReqBo reqBo) {
        log.info("\u505c\u7528\u6536\u94f6\u53f0\u6a21\u677f -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        BaseRspInfoBO rspBo = new BaseRspInfoBO();
        if (reqBo == null) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u505c\u7528\u6536\u94f6\u53f0\u6a21\u677f\u7684\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)reqBo.getCashierTemplate())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u505c\u7528\u6536\u94f6\u53f0\u6a21\u677f\u7684\u5165\u53c2cashierTemplate\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBo;
        }
        CashierTemplatePo qryCa = this.cashierTemplateAtomService.queryCashierTemplateById(Long.valueOf(reqBo.getCashierTemplate()));
        if (qryCa == null) {
            rspBo.setRspName("\u505c\u7528\u5931\u8d25\uff0c\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u5b58\u5728");
            rspBo.setRspCode("8888");
            return rspBo;
        }
        if (!qryCa.getFlag().equals("1")) {
            rspBo.setRspName("\u505c\u7528\u5931\u8d25\uff0c\u4e0d\u662f\u6b63\u5e38\u4f7f\u7528\u72b6\u6001\u7684\u6536\u94f6\u53f0\u6a21\u677f\u65e0\u6cd5\u505c\u7528");
            rspBo.setRspCode("8888");
            return rspBo;
        }
        CashierTemplatePo updCPo = new CashierTemplatePo();
        updCPo.setCashierTemplate(Long.valueOf(reqBo.getCashierTemplate()));
        updCPo.setFlag("0");
        updCPo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
        if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
            updCPo.setUpdateOperId(reqBo.getOperId());
        }
        int updFlag = this.cashierTemplateAtomService.updateCashierTemplate(updCPo);
        CashierTemplatePo qryCaRes = this.cashierTemplateAtomService.queryCashierTemplateById(Long.valueOf(reqBo.getCashierTemplate()));
        if (qryCaRes == null) {
            rspBo.setRspName("\u505c\u7528\u5931\u8d25\uff0c\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u4e0d\u5b58\u5728");
            rspBo.setRspCode("8888");
            return rspBo;
        }
        if (updFlag < 1) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u505c\u7528\u5931\u8d25\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            return rspBo;
        }
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u505c\u7528\u6210\u529f");
        return rspBo;
    }
}

