/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ability.CashierUrlEncryptService;
import com.tydic.payment.pay.ability.bo.CashierUrlEncrypReqBo;
import com.tydic.payment.pay.ability.bo.CashierUrlEncrypRspBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.DataValidationService;
import com.tydic.payment.pay.busi.QueryInfoBusiSystemService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.busi.bo.DataValidationReqBO;
import com.tydic.payment.pay.busi.bo.DataValidationRspBO;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemReqBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemRspBo;
import com.tydic.payment.pay.comb.CashierPayUrlCombService;
import com.tydic.payment.pay.comb.bo.CombCashierPayUrlReqBo;
import com.tydic.payment.pay.comb.bo.CombCashierPayUrlRspBo;
import com.tydic.payment.pay.common.util.MapUtils;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=CashierUrlEncryptService.class)
public class CashierUrlEncryptServiceImpl
implements CashierUrlEncryptService {
    private static final Logger log = LoggerFactory.getLogger(CashierUrlEncryptServiceImpl.class);
    @Autowired
    private DataValidationService dataValidationService;
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private QueryInfoBusiSystemService queryInfoBusiSystemService;
    @Autowired
    private CashierPayUrlCombService cashierPayUrlCombService;

    public CashierUrlEncrypRspBo cashierPay(CashierUrlEncrypReqBo cashierUrlEncrypReqBo) {
        if (cashierUrlEncrypReqBo == null) {
            log.info("\u4e0b\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e0b\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("\u6536\u94f6\u53f0\u5165\u53c2\u4e3a\uff1a " + cashierUrlEncrypReqBo.toString());
        if (StringUtils.isEmpty((Object)cashierUrlEncrypReqBo.getContent())) {
            log.info("\u4e0b\u5355\u5165\u53c2\u3010content\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e0b\u5355\u5165\u53c2\u3010content\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)cashierUrlEncrypReqBo.getBusiId())) {
            log.info("\u4e0b\u5355\u5165\u53c2\u3010busiId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e0b\u5355\u5165\u53c2\u3010busiId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String busiId = cashierUrlEncrypReqBo.getBusiId();
        String content = cashierUrlEncrypReqBo.getContent();
        CashierUrlEncrypRspBo cashierUrlEncrypRspBo = new CashierUrlEncrypRspBo();
        QueryInfoBusiSystemReqBo bo = new QueryInfoBusiSystemReqBo();
        bo.setBusiCode(busiId);
        QueryInfoBusiSystemRspBo queryInfoBusiSystemRspBo = this.queryInfoBusiSystemService.queryInfoBusiSystem(bo);
        if ("8888".equals(queryInfoBusiSystemRspBo.getRspCode())) {
            log.info("\u6e05\u7b97\u8ba2\u5355\u4e2d\u5fc3\u4e0b\u5355\u5f02\u5e38\uff1a\u672a\u67e5\u8be2\u5230\u7cfb\u7edf\u7f16\u7801\uff1a" + busiId);
            cashierUrlEncrypRspBo.setRspCode("\u5931\u8d25");
            cashierUrlEncrypRspBo.setRspName("\u4e1a\u52a1\u3010busi_id=" + busiId + "\u3011\u4e0d\u5b58\u5728");
            return cashierUrlEncrypRspBo;
        }
        log.info("\u4e1a\u52a1\u7f16\u7801\u4e3a\uff1a" + busiId + "\uff1b\u5185\u90e8\u7cfb\u7edf\u4e3a\uff1a" + ((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiId());
        DataValidationReqBO req = new DataValidationReqBO();
        req.setBusiId(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiId());
        req.setContent(content);
        try {
            DataEncryptionRspBo encryData;
            DataValidationRspBO dataValidationRspBO = this.dataValidationService.validation(req);
            if (!"0000".equals(dataValidationRspBO.getRspCode())) {
                log.info(dataValidationRspBO.getRspName());
                cashierUrlEncrypRspBo.setRspCode(dataValidationRspBO.getRspCode());
                cashierUrlEncrypRspBo.setRspName(dataValidationRspBO.getRspName());
                return cashierUrlEncrypRspBo;
            }
            if (dataValidationRspBO.isSign()) {
                CombCashierPayUrlReqBo combCashierPayUrlReqBo = (CombCashierPayUrlReqBo)MapUtils.mapToObject((Map)dataValidationRspBO.getContentMap(), CombCashierPayUrlReqBo.class);
                String validate = this.checkParams(combCashierPayUrlReqBo);
                if (!"TRUE".equals(validate)) {
                    log.info(" \u52a0\u5bc6\u4e0b\u5355\u63a5\u53e3\u5f02\u5e38\uff1a \u5b58\u5728\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u4e0d\u8fc7 - " + validate);
                    cashierUrlEncrypRspBo.setRspCode("8888");
                    cashierUrlEncrypRspBo.setRspName(validate);
                    return cashierUrlEncrypRspBo;
                }
                combCashierPayUrlReqBo.setOrderType("01");
                combCashierPayUrlReqBo.setBusiId(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiId());
                combCashierPayUrlReqBo.setBusiCode(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiCode());
                combCashierPayUrlReqBo.setIp(cashierUrlEncrypReqBo.getIp());
                combCashierPayUrlReqBo.setIp(combCashierPayUrlReqBo.getOrderAttrValue1());
                CombCashierPayUrlRspBo combCashierPayUrlRspBo = this.cashierPayUrlCombService.pmcCashierPayUrlComb(combCashierPayUrlReqBo);
                if (!"0000".equals(combCashierPayUrlRspBo.getRspCode())) {
                    cashierUrlEncrypRspBo.setRspCode(combCashierPayUrlRspBo.getRspCode());
                    cashierUrlEncrypRspBo.setRspName(combCashierPayUrlRspBo.getRspName());
                    return cashierUrlEncrypRspBo;
                }
                JSONObject obj = (JSONObject)JSONObject.toJSON((Object)combCashierPayUrlRspBo);
                obj.remove((Object)"rspCode");
                obj.remove((Object)"rspName");
                DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
                dataEncryptionReqBo.setBusiId(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiId());
                dataEncryptionReqBo.setContent(obj.toString());
                encryData = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
                if (!"0000".equals(encryData.getRspCode())) {
                    cashierUrlEncrypRspBo.setRspCode("8888");
                    cashierUrlEncrypRspBo.setRspName(encryData.getRspName());
                    return cashierUrlEncrypRspBo;
                }
            } else {
                log.info("\u8ba2\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7");
                cashierUrlEncrypRspBo.setRspCode("8888");
                cashierUrlEncrypRspBo.setRspName("\u8ba2\u5355\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff0c \u8bf7\u786e\u5b9a\u7b7e\u540d\u5bc6\u94a5\u662f\u5426\u6b63\u786e\uff01");
                return cashierUrlEncrypRspBo;
            }
            cashierUrlEncrypRspBo.setRspCode("0000");
            cashierUrlEncrypRspBo.setRspName("\u6210\u529f");
            cashierUrlEncrypRspBo.setBusiId(busiId);
            cashierUrlEncrypRspBo.setContent(encryData.getEncrypData());
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25\uff1a " + e.getMessage(), (Throwable)e);
            cashierUrlEncrypRspBo.setRspCode("8888");
            cashierUrlEncrypRspBo.setRspName("\u521b\u5efa\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
        }
        return cashierUrlEncrypRspBo;
    }

    public String checkParams(CombCashierPayUrlReqBo combCashierPayUrlReqBo) {
        String errMsg = "TRUE";
        if (StringUtils.isEmpty((Object)combCashierPayUrlReqBo.getCreateOperId())) {
            errMsg = "\u5165\u53c2\u3010createOperId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)combCashierPayUrlReqBo.getDetailName())) {
            errMsg = "\u5165\u53c2\u3010detailName\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)combCashierPayUrlReqBo.getNotifyUrl())) {
            errMsg = "\u5165\u53c2\u3010notifyUrl\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)combCashierPayUrlReqBo.getOutOrderId())) {
            errMsg = "\u5165\u53c2\u3010outOrderId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (combCashierPayUrlReqBo.getOutOrderId() != null && combCashierPayUrlReqBo.getOutOrderId().length() > 32) {
            errMsg = "\u5165\u53c2\u3010outOrderId\u3011 \u957f\u5ea6\u8d85\u957f\u5566";
        }
        if (StringUtils.isEmpty((Object)combCashierPayUrlReqBo.getTotalFee())) {
            errMsg = "\u5165\u53c2\u3010totalFee\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            if (new BigDecimal(combCashierPayUrlReqBo.getTotalFee()).compareTo(new BigDecimal("0")) < 0) {
                errMsg = "\u5165\u53c2\u3010totalFee\u3011 \u91d1\u989d\u5fc5\u987b\u5927\u4e8e0";
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            errMsg = "\u8bf7\u4f20\u5165\u6709\u6548\u3010totalFee\u3011 \u6570\u636e";
        }
        if (!(!StringUtils.isEmpty((Object)combCashierPayUrlReqBo.getReqWay()) && ("2".equals(combCashierPayUrlReqBo.getReqWay()) || "3".equals(combCashierPayUrlReqBo.getReqWay()) || "4".equals(combCashierPayUrlReqBo.getReqWay()) || "6".equals(combCashierPayUrlReqBo.getReqWay()) || "1".equals(combCashierPayUrlReqBo.getReqWay()) || "5".equals(combCashierPayUrlReqBo.getReqWay())))) {
            errMsg = "\u8bf7\u4f20\u5165\u6709\u6548\u7684\u3010reqWay\u3011\u6570\u636e";
        }
        return errMsg;
    }
}

