/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.payment.pay.ability.PayProQryMerchantInfoListAbilityService;
import com.tydic.payment.pay.ability.bo.PayProMerchantInfoDataBo;
import com.tydic.payment.pay.ability.bo.PayProQryMerchantInfoListReqBo;
import com.tydic.payment.pay.ability.bo.PayProQryMerchantInfoListRspBo;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.busi.QueryCodeListByTypecodeService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.PCodeListBoStr;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeReqBo;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeRspBo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProQryMerchantInfoListAbilityService.class)
public class PayProQryMerchantInfoListAbilityServiceImpl
implements PayProQryMerchantInfoListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PayProQryMerchantInfoListAbilityServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private QueryCodeListByTypecodeService queryCodeListByTypecodeService;
    @Autowired
    private QueryPCodeInfoService queryPCodeInfoService;

    public PayProQryMerchantInfoListRspBo qryMerchantInfos(PayProQryMerchantInfoListReqBo reqBo) {
        log.debug("==\u5546\u6237\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)reqBo);
        PayProQryMerchantInfoListRspBo retBo = new PayProQryMerchantInfoListRspBo();
        ArrayList<PayProMerchantInfoDataBo> merchantInfos = new ArrayList<PayProMerchantInfoDataBo>();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setMerchantInfos(merchantInfos);
        MerChantInfoPo qryPo = new MerChantInfoPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        qryPo.setFlag(reqBo.getStatus());
        List<MerChantInfoPo> queryRspList = this.merchantInfoAtomService.queryMerChantInfoByCondition(qryPo);
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        for (MerChantInfoPo tempPo : queryRspList) {
            PayProMerchantInfoDataBo dataBo = new PayProMerchantInfoDataBo();
            BeanUtils.copyProperties((Object)tempPo, (Object)dataBo);
            dataBo.setStatus(tempPo.getFlag());
            dataBo.setMerchantTypeDesc(dicMap.get("MERCHANT_TYPE").get(dataBo.getMerchantType().toString()));
            dataBo.setStatusDesc(dicMap.get("MERCHANT_FLAG").get(dataBo.getStatus()));
            dataBo.setCreateTime(tempPo.getCreateTime() == null ? "" : new DateTime((Object)tempPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            dataBo.setUpdateTime(tempPo.getUpdateTime() == null ? "" : new DateTime((Object)tempPo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            merchantInfos.add(dataBo);
        }
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap() {
        List codesL;
        List codeL;
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        HashMap<String, String> typeMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryPCode = new QueryCodeListByTypecodeReqBo();
        qryPCode.setTypeCode("MERCHANT_TYPE");
        QueryCodeListByTypecodeRspBo qryPCodeRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryPCode);
        if (qryPCodeRsp.getRspCode().equals("0000") && !CollectionUtils.isEmpty((Collection)(codeL = qryPCodeRsp.getCodeList()))) {
            for (PCodeListBoStr tcode : codeL) {
                typeMap.put(tcode.getCodeValue(), tcode.getCodeName());
            }
        }
        dicMap.put("MERCHANT_TYPE", typeMap);
        HashMap<String, String> flagMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryPCFlagode = new QueryCodeListByTypecodeReqBo();
        qryPCFlagode.setTypeCode("MERCHANT_FLAG");
        QueryCodeListByTypecodeRspBo qryPCFlagodeRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryPCFlagode);
        if (qryPCFlagodeRsp.getRspCode().equals("0000") && !CollectionUtils.isEmpty((Collection)(codesL = qryPCFlagodeRsp.getCodeList()))) {
            for (PCodeListBoStr tcode : codesL) {
                flagMap.put(tcode.getCodeValue(), tcode.getCodeName());
            }
        }
        dicMap.put("MERCHANT_FLAG", flagMap);
        return dicMap;
    }
}

