/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.ability.PrepareOrderAbilityService;
import com.tydic.payment.pay.ability.bo.PrepareOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PrepareOrderAbilityServiceRspBo;
import com.tydic.payment.pay.comb.PrepareOrderCombService;
import com.tydic.payment.pay.comb.bo.PrepareOrderCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PrepareOrderCombServiceRspBo;
import com.tydic.payment.pay.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PrepareOrderAbilityService.class)
public class PrepareOrderAbilityServiceImpl
implements PrepareOrderAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(PrepareOrderAbilityServiceImpl.class);
    private static final String SERVICE_NAME = "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1";
    @Autowired
    private PrepareOrderCombService prepareOrderCombService;

    public PrepareOrderAbilityServiceRspBo dealOrder(PrepareOrderAbilityServiceReqBo reqBo) {
        LoggerProUtils.debug(LOG, "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        this.validateArg(reqBo);
        PrepareOrderAbilityServiceRspBo retBo = new PrepareOrderAbilityServiceRspBo();
        PrepareOrderCombServiceReqBo dealOrderBo = new PrepareOrderCombServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)dealOrderBo);
        PrepareOrderCombServiceRspBo prepareOrderCombServiceRspBo = this.prepareOrderCombService.dealOrder(dealOrderBo);
        if (prepareOrderCombServiceRspBo == null) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 :\u8c03\u7528\u9884\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u8fd4\u56de\u4e3a\u7a7a\u5bf9\u8c61");
        }
        BeanUtils.copyProperties((Object)prepareOrderCombServiceRspBo, (Object)retBo);
        return retBo;
    }

    private void validateArg(PrepareOrderAbilityServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 ->\u5165\u53c2\u6821\u9a8c\uff1a\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 ->\u5165\u53c2\u6821\u9a8c\uff1a\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027BusiId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 ->\u5165\u53c2\u6821\u9a8c\uff1a\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 ->\u5165\u53c2\u6821\u9a8c\uff1a\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027outOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 ->\u5165\u53c2\u6821\u9a8c\uff1a\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 ->\u5165\u53c2\u6821\u9a8c\uff1a\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027totalFee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 ->\u5165\u53c2\u6821\u9a8c\uff1a\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027detailName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getRedirectUrl())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 ->\u5165\u53c2\u6821\u9a8c\uff1a\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027RedirectUrl\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getIp())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9884\u8ba2\u5355\u4e0b\u5355ability\u670d\u52a1 ->\u5165\u53c2\u6821\u9a8c\uff1a\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027ip\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

