/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.ReceiveQrCodeAbilityService;
import com.tydic.payment.pay.ability.bo.ReceiveQrCodeAbilityReqBo;
import com.tydic.payment.pay.ability.bo.ReceiveQrCodeAbilityRspBo;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.busi.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.QueryInfoBusiSystemService;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemReqBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemRspBo;
import com.tydic.payment.pay.comb.UniPayCombService;
import com.tydic.payment.pay.comb.bo.UniPayCombReqBO;
import com.tydic.payment.pay.comb.bo.UniPayCombRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.math.BigDecimal;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=ReceiveQrCodeAbilityService.class)
public class ReceiveQrCodeAbilityServiceImpl
implements ReceiveQrCodeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ReceiveQrCodeAbilityServiceImpl.class);
    @Autowired
    private QueryInfoBusiSystemService queryInfoBusiSystemService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private UniPayCombService uniPayCombService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;

    public ReceiveQrCodeAbilityRspBo dealReceiveQrCode(ReceiveQrCodeAbilityReqBo reqBo) {
        ReceiveQrCodeAbilityRspBo rspBo = new ReceiveQrCodeAbilityRspBo();
        try {
            BaseRspInfoBO checkRspBo = this.checkRequestLegal(reqBo);
            String qrCodeLink = null;
            String timeOut = null;
            if (!checkRspBo.getRspCode().equals("0000")) {
                rspBo.setRspCode("0000");
                rspBo.setRspName("\u6210\u529f");
                rspBo.setResultCode("FAIL");
                rspBo.setMsg(checkRspBo.getRspName());
                return rspBo;
            }
            String orderId = checkRspBo.getRspName();
            PorderPo orderInfo = this.payOrderAtomService.queryByOrderId(Long.valueOf(orderId));
            UniPayCombReqBO uniPayCombReqBO = new UniPayCombReqBO();
            uniPayCombReqBO.setOrderId(orderId);
            uniPayCombReqBO.setPayMethod(reqBo.getPayMethod());
            BigDecimal totalFee = MoneyUtils.haoToFen((String)orderInfo.getTotalFee().toString());
            uniPayCombReqBO.setRealFee(totalFee.toPlainString());
            UniPayCombRspBO uniPayCombRspBO = this.uniPayCombService.dealUniPay(uniPayCombReqBO);
            log.info("\u8c03\u7528\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uniPayCombRspBO));
            qrCodeLink = uniPayCombRspBO.getQrCode();
            timeOut = uniPayCombRspBO.getEffectiveSeconds();
            log.info("\u652f\u4ed8\u94fe\u63a5qrCodeLink=" + qrCodeLink + ",\u4e8c\u7ef4\u7801\u5931\u6548\u65f6\u95f4\uff1atimeOut=" + timeOut);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u6210\u529f");
            rspBo.setBusiCode(reqBo.getBusiCode());
            rspBo.setOutOrderId(reqBo.getOutOrderId());
            if (StringUtils.isEmpty((Object)qrCodeLink)) {
                rspBo.setResultCode("FAIL");
                rspBo.setQrCode(qrCodeLink);
                rspBo.setTimeOut(timeOut);
                rspBo.setMsg("\u751f\u6210\u652f\u4ed8\u673a\u6784\u4e8c\u7ef4\u7801\u5931\u8d25");
            } else {
                rspBo.setResultCode("SUCCESS");
                rspBo.setQrCode(qrCodeLink);
                rspBo.setTimeOut(timeOut);
            }
            return rspBo;
        }
        catch (Exception e) {
            log.error("\u8fd4\u56de\u4e8c\u7ef4\u7801\u63a5\u53e3\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u6210\u529f");
            rspBo.setBusiCode(reqBo.getBusiCode());
            rspBo.setResultCode("FAIL");
            rspBo.setMsg("\u83b7\u53d6\u652f\u4ed8\u673a\u6784\u4e8c\u7ef4\u7801\u94fe\u63a5\u670d\u52a1\u3010ReceiveQrCodeAbilityService\u3011\u5f02\u5e38");
            rspBo.setOutOrderId(reqBo.getOutOrderId());
            return rspBo;
        }
    }

    private BaseRspInfoBO checkRequestLegal(ReceiveQrCodeAbilityReqBo reqBo) {
        BaseRspInfoBO checkRsp = new BaseRspInfoBO();
        checkRsp.setRspCode("8888");
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            checkRsp.setRspName("\u4e0b\u5355\u5931\u8d25,\u5165\u53c2\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return checkRsp;
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            checkRsp.setRspName("\u4e0b\u5355\u5931\u8d25,\u5165\u53c2\u5916\u90e8\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return checkRsp;
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            checkRsp.setRspName("\u4e0b\u5355\u5931\u8d25,\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            return checkRsp;
        }
        if (!reqBo.getPayMethod().equals("21") && !reqBo.getPayMethod().equals("11")) {
            checkRsp.setRspName("\u4e0b\u5355\u5931\u8d25,\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u4e0d\u7b26\u5408\u7ea6\u5b9a\u89c4\u8303");
            return checkRsp;
        }
        QueryInfoBusiSystemReqBo qryBusiSysReq = new QueryInfoBusiSystemReqBo();
        qryBusiSysReq.setBusiCode(reqBo.getBusiCode());
        QueryInfoBusiSystemRspBo qryBusiSysRsp = this.queryInfoBusiSystemService.queryInfoBusiSystem(qryBusiSysReq);
        if (!"0000".equals(qryBusiSysRsp.getRspCode())) {
            log.info("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25");
            checkRsp.setRspName("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38");
            return checkRsp;
        }
        if (CollectionUtils.isEmpty((Collection)qryBusiSysRsp.getInfoBusiBoList())) {
            log.info("\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801\u4e0d\u5b58\u5728");
            checkRsp.setRspName("\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801\u4e0d\u5b58\u5728");
            return checkRsp;
        }
        Long busiId = Long.valueOf(((QueryInfoBusiSystemBo)qryBusiSysRsp.getInfoBusiBoList().get(0)).getBusiId());
        OrderQueryConstructionReqBo orderQueryReqBo = new OrderQueryConstructionReqBo();
        orderQueryReqBo.setBusiId(busiId);
        orderQueryReqBo.setOutOrderId(reqBo.getOutOrderId());
        OrderQueryConstructionRspBo orderQueryRspBo = this.orderQueryConstructionBusiService.queryConstruction(orderQueryReqBo);
        if (!orderQueryRspBo.getRspCode().equals("0000")) {
            log.info("\u67e5\u8be2\u5931\u8d25\uff0c\u8c03\u7528OrderQueryConstructionBusiService\u670d\u52a1\u5f02\u5e38");
            checkRsp.setRspName("\u67e5\u8be2\u5931\u8d25,\u5916\u90e8\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
            return checkRsp;
        }
        checkRsp.setRspCode("0000");
        checkRsp.setRspName(orderQueryRspBo.getOrderId().toString());
        log.info("\u6821\u9a8c\u5165\u53c2\u6210\u529f\uff0c\u8fd4\u56de\u6b63\u786e\u8ba2\u5355\u53f7\uff1aorderId=" + checkRsp.getRspName());
        return checkRsp;
    }
}

