/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.payment.pay.comb.PayProQueryBillCombService;
import com.tydic.payment.pay.comb.bo.PayProQueryBillCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProQueryBillCombRspBo;
import com.tydic.payment.pay.comb.bo.PayProQueryBillCombRspDataBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.po.PorderQueryBillPo;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProQueryBillCombService.class)
public class PayProQueryBillCombServiceImpl
implements PayProQueryBillCombService {
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final String DEFAULT_REQUEST_CODE = "payCenter";
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public PayProQueryBillCombRspBo queryBill(PayProQueryBillCombReqBo reqBo) {
        PayProQueryBillCombRspBo rspBo = new PayProQueryBillCombRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        ArrayList<PayProQueryBillCombRspDataBo> datas = new ArrayList<PayProQueryBillCombRspDataBo>();
        PorderQueryBillPo queryPo = new PorderQueryBillPo();
        this.sortData(reqBo, queryPo);
        List<PorderQueryBillPo> porderQueryBillPos = this.porderMapper.queryPayBillData(queryPo);
        for (PorderQueryBillPo po : porderQueryBillPos) {
            PayProQueryBillCombRspDataBo bo = new PayProQueryBillCombRspDataBo();
            this.sortRspData(po, bo);
            datas.add(bo);
        }
        rspBo.setDatas(datas);
        rspBo.setSize(datas.size() + "");
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void sortRspData(PorderQueryBillPo po, PayProQueryBillCombRspDataBo bo) {
        BeanUtils.copyProperties((Object)po, (Object)bo);
        bo.setCreateTime(new DateTime((Object)po.getCreateTime()).toString(TIME_PATTERN));
        bo.setMerchantId(po.getMerchantId().toString());
        bo.setOrderId(po.getOrderId().toString());
        if (po.getRefundFee() != null) {
            bo.setRefundFee(MoneyUtils.haoToFen((Long)po.getRefundFee()).toString());
        }
        if (po.getTotalFee() != null) {
            bo.setTotalFee(MoneyUtils.haoToFen((Long)po.getTotalFee()).toString());
        }
        bo.setCustNotifyTime(new DateTime((Object)po.getCustNotifyTime()).toString(TIME_PATTERN));
    }

    private void sortData(PayProQueryBillCombReqBo reqBo, PorderQueryBillPo queryPo) {
        BeanUtils.copyProperties((Object)reqBo, (Object)queryPo);
        queryPo.setBeginTime(DateTime.parse((String)reqBo.getStartDate(), (DateTimeFormatter)FORMATTER).toDate());
        queryPo.setEndTime(DateTime.parse((String)reqBo.getEndDate(), (DateTimeFormatter)FORMATTER).toDate());
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            queryPo.setMerchantId(Long.parseLong(reqBo.getMerchantId()));
        }
    }

    private String validateArg(PayProQueryBillCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String requestCode = reqBo.getRequestCode();
        if (StringUtils.isEmpty((Object)reqBo.getRequestCode())) {
            return "\u8bf7\u6c42\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String queryPayBillRequestCode = this.payPropertiesVo.getQueryPayBillRequestCode();
        if (!queryPayBillRequestCode.isEmpty() ? !queryPayBillRequestCode.equals(requestCode) : !DEFAULT_REQUEST_CODE.equals(requestCode)) {
            return "requestCode\u9519\u8bef";
        }
        String startDate = reqBo.getStartDate();
        if (StringUtils.isEmpty((Object)startDate)) {
            return "\u5165\u53c2\u5c5e\u6027startDate\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            DateTime.parse((String)startDate, (DateTimeFormatter)FORMATTER);
        }
        catch (Exception e) {
            return "startDate\u4e0d\u7b26\u5408\u89c4\u8303,\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss";
        }
        String endDate = reqBo.getEndDate();
        if (StringUtils.isEmpty((Object)endDate)) {
            return "\u5165\u53c2\u5c5e\u6027endDate\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            DateTime.parse((String)endDate, (DateTimeFormatter)FORMATTER);
        }
        catch (Exception e) {
            return "endDate\u4e0d\u7b26\u5408\u89c4\u8303,\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss";
        }
        String orderStatus2 = reqBo.getOrderStatus();
        if (!(StringUtils.isEmpty((Object)orderStatus2) || "A10".equals(orderStatus2) || "A00".equals(orderStatus2))) {
            return "orderStatus\u5fc5\u987b\u4e3aA10\u6216\u8005A00";
        }
        String merchantId = reqBo.getMerchantId();
        if (!StringUtils.isEmpty((Object)merchantId)) {
            try {
                Long.parseLong(merchantId);
            }
            catch (NumberFormatException e) {
                return "merchantId\u5fc5\u987b\u4e3a\u6570\u5b57";
            }
        }
        return null;
    }
}

