/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.bo.PayAbleBusiReqDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractChinaBankPayAble;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankBodyReqBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankHeadReqBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankRequestBo;
import com.tydic.payment.pay.payable.impl.transbo.ChinaBankResponseBo;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="chinaBankRealPayAbleImpl")
public class ChinaBankRealPayAbleImpl
extends AbstractChinaBankPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(ChinaBankRealPayAbleImpl.class);
    private static final String STATE_CODE_SUCCESS = "OK";
    private static final String REAL_PAY_STATE_CODE_SUCCESS = "1";
    private static final String REAL_PAY_STATE_CODE_FAIL = "2";
    private static final String REAL_PAY_STATE_CODE_DEALING = "3";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.CHINA_BANK_REAL_PAY.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.info("\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        String realPayPath = this.payPropertiesVo.getValueByKey("china.bank.real.pay.url");
        log.debug("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u63a5\u53e3\u7684\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)realPayPath);
        if (StringUtils.isEmpty((Object)realPayPath)) {
            log.error("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u5730\u5740'china.bank.real.pay.url'\u672a\u914d\u7f6e");
            retBo.setRespCode("212063");
            retBo.setRespDesc("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u5730\u5740'china.bank.real.pay.url'\u672a\u914d\u7f6e");
            return retBo;
        }
        Map<String, Object> reqMap = this.assembleData(reqBo);
        log.debug("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u63a5\u53e3\u7684\u8bf7\u6c42\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString(reqMap));
        if (reqMap == null) {
            log.error("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u8868\u5355\u5931\u8d25");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u8868\u5355\u5931\u8d25");
            return retBo;
        }
        String retStr = HttpUtil.post((String)realPayPath, reqMap);
        log.debug("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u63a5\u53e3\u7684\u51fa\u53c2\u4e3a\uff1a{}", (Object)retStr);
        if (retStr.indexOf("<html>") != -1) {
            log.error("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u670d\u52a1\u5668\u8fd4\u56de\u9875\u9762\u5185\u5bb9\uff1a{}", (Object)retStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u5b9e\u73b0\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u4e2d\u884c\u7cfb\u7edf\u6545\u969c");
            return retBo;
        }
        ChinaBankResponseBo responseBo = super.base64DeCode(retStr);
        if (responseBo == null) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u5b9e\u73b0\u63a5\u53e3\uff0c\u8fd4\u56de\u53c2\u6570\u9a8c\u7b7e\u5931\u8d25");
            return retBo;
        }
        if (!STATE_CODE_SUCCESS.equals(responseBo.getHead().getResponseCode())) {
            log.error("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)responseBo.getHead().getResponseInfo());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u884c\u5546\u6237\u5b9e\u4ed8\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + responseBo.getHead().getResponseInfo());
            return retBo;
        }
        String payResultCode = "success";
        if (REAL_PAY_STATE_CODE_FAIL.equals(responseBo.getBody().getTranStatus())) {
            payResultCode = "failed";
        }
        if (REAL_PAY_STATE_CODE_DEALING.equals(responseBo.getBody().getTranStatus())) {
            payResultCode = "dealing";
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setTradeTime(responseBo.getBody().getTranTime());
        retBo.setPayNotifyTransId(responseBo.getBody().getTranSeq());
        retBo.setPayResultCode(payResultCode);
        retBo.setPayResultMsg(responseBo.getHead().getResponseInfo());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getPayFee() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        PayAbleBusiReqDataBo busiReqJson = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        if (StringUtils.isEmpty((Object)busiReqJson.getTraceNo())) {
            return "\u6269\u5c55\u5165\u53c2'busiReqData\u2018\u4e2d\u7684'traceNo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return super.validateParaMap(reqBo.getParaMap());
    }

    private Map<String, Object> assembleData(PayAbleDealPayReqBo reqBo) {
        PayAbleBusiReqDataBo busiReqJson = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        ChinaBankRequestBo chinaBankRequestBo = new ChinaBankRequestBo();
        ChinaBankHeadReqBo headReqBo = new ChinaBankHeadReqBo();
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        headReqBo.setRequestTime(new DateTime((Object)dbDate).toString("yyyyMMddHHmmss"));
        chinaBankRequestBo.setHead(headReqBo);
        ChinaBankBodyReqBo bodyReqBo = new ChinaBankBodyReqBo();
        bodyReqBo.setOrderNo(reqBo.getPayOrderId());
        bodyReqBo.setCurrency("156");
        bodyReqBo.setAmount(reqBo.getPayFee().toString());
        bodyReqBo.setInterestFlag("0");
        bodyReqBo.setTraceNo(busiReqJson.getTraceNo());
        bodyReqBo.setPayeeActNum("");
        bodyReqBo.setPayeeActNam("");
        chinaBankRequestBo.setBody(bodyReqBo);
        log.debug("\u4e2d\u884c-\u5b9e\u4ed8\u652f\u4ed8\u63a5\u53e3\u7684\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)chinaBankRequestBo));
        String messageId = "0000116";
        return super.assembleFormData(chinaBankRequestBo, messageId);
    }
}

