/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractUnionPayAble;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UnionPayAcpPayAbleImpl
extends AbstractUnionPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(UnionPayAcpPayAbleImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Resource
    private FileClient fileClient;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.UNION_PAY_ACP.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        String html;
        if (LOG.isDebugEnabled()) {
            LOG.info("\u8fdb\u5165\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\uff1a" + reqBo);
        }
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validataArgStr = this.validataArg(reqBo);
        if (!StringUtils.isEmpty((Object)validataArgStr)) {
            retBo.setRespCode("212027");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validataArgStr);
            return retBo;
        }
        this.loadProperties(reqBo);
        String payOrderId = reqBo.getPayOrderId();
        PorderPayTransAtomRspBo orderInfo = super.getOrderPayTrans(payOrderId);
        Map<String, String> payReqContent = this.createPayReqContent(reqBo, orderInfo);
        Map submitFromData = AcpService.sign(payReqContent, (String)"UTF-8");
        String requestFrontUrl = SdkConfig.getConfig().getFrontRequestUrl();
        if (StringUtils.isEmpty((Object)requestFrontUrl)) {
            LOG.error("\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u63a5\u53e3\u5730\u5740\u672a\u914d\u7f6e");
            throw new BusinessException("216024", "\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u63a5\u53e3\u5730\u5740\u672a\u914d\u7f6e");
        }
        try {
            html = AcpService.createAutoFormHtml((String)requestFrontUrl, (Map)submitFromData, (String)"UTF-8");
        }
        catch (Exception e) {
            LOG.error("\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u83b7\u53d6html\u8868\u5355\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("216024", "\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u83b7\u53d6html\u8868\u5355\u5f02\u5e38\uff1a" + e);
        }
        if (StringUtils.isEmpty((Object)html)) {
            LOG.error("\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u7684html\u8868\u5355\u4e3a\u7a7a");
            throw new BusinessException("216024", "\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u7684html\u8868\u5355\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setHtmlBody(html);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u94f6\u8054\u7f51\u5173\u652f\u4ed8\u8bf7\u6c42\u6210\u529f");
        return retBo;
    }

    private Map<String, String> createPayReqContent(PayAbleDealPayReqBo reqBo, PorderPayTransAtomRspBo orderInfo) {
        String merId = (String)reqBo.getParaMap().get("merId");
        HashMap<String, String> payReqContent = new HashMap<String, String>(64);
        payReqContent.put("version", SdkConfig.getConfig().getVersion());
        payReqContent.put("encoding", "UTF-8");
        payReqContent.put("signMethod", SdkConfig.getConfig().getSignMethod());
        payReqContent.put("txnType", "01");
        payReqContent.put("txnSubType", "01");
        payReqContent.put("bizType", "000201");
        payReqContent.put("channelType", "07");
        payReqContent.put("merId", merId);
        payReqContent.put("accessType", "0");
        payReqContent.put("orderId", reqBo.getPayOrderId());
        payReqContent.put("txnTime", DateUtils.dateToStr((Date)orderInfo.getCreateTime(), (String)"yyyyMMddHHmmss"));
        payReqContent.put("currencyCode", "156");
        payReqContent.put("txnAmt", String.valueOf(reqBo.getPayFee()));
        payReqContent.put("reqReserved", "");
        payReqContent.put("riskRateInfo", "{commodityName=}");
        payReqContent.put("frontUrl", SdkConfig.getConfig().getFrontUrl());
        payReqContent.put("backUrl", SdkConfig.getConfig().getBackUrl());
        payReqContent.put("payTimeout", new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis() + 900000L));
        return payReqContent;
    }

    private void loadProperties(PayAbleDealPayReqBo reqBo) {
        Map paraMap = reqBo.getParaMap();
        HashMap<String, String> payParaMap = new HashMap<String, String>(paraMap.size());
        paraMap.forEach((key, value) -> payParaMap.put((String)key, (String)value));
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, payParaMap);
    }

    private String validataArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String merId = (String)reqBo.getParaMap().get("merId");
        if (StringUtils.isEmpty((Object)merId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e2d(merid)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

