/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.PCodeListAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PCodeListPO;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.RefundOrderDetailQryReqBO;
import com.tydic.payment.pay.web.bo.rsp.PorderRefundBo;
import com.tydic.payment.pay.web.bo.rsp.RefundOrderDetailQryRspBO;
import com.tydic.payment.pay.web.bo.rsp.RefundTransListRspBO;
import com.tydic.payment.pay.web.service.RefundOrderDetailQryWebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=RefundOrderDetailQryWebService.class)
public class RefundOrderDetailQryWebServiceImpl
implements RefundOrderDetailQryWebService {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderDetailQryWebServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private PCodeListAtomService pCodeListAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;

    public RefundOrderDetailQryRspBO qryRefundOrderDetail(RefundOrderDetailQryReqBO reqBo) {
        log.info("\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        RefundOrderDetailQryRspBO rspBO = new RefundOrderDetailQryRspBO();
        ArrayList<RefundTransListRspBO> rspList = new ArrayList<RefundTransListRspBO>();
        this.validateArg(reqBo);
        PorderPo orderPo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(reqBo.getOrderId()));
        if (orderPo == null) {
            log.info("\u5728p_order\u8868\u4e2d\u65e0\u6cd5\u67e5\u627e\u5230\u7b26\u5408\u6761\u4ef6[orderId:" + reqBo.getOrderId() + "\u7684\u9000\u6b3e\u8bb0\u5f55");
            rspBO.setRspCode("0000");
            rspBO.setRspName("\u6ca1\u6709\u9000\u6b3e\u8bb0\u5f55");
            return rspBO;
        }
        if (!orderPo.getOrderType().equals("02")) {
            rspBO.setRspCode("8888");
            rspBO.setRspName("\u8be5\u8ba2\u5355\u4e0d\u662f\u9000\u6b3e\u8ba2\u5355");
            return rspBO;
        }
        PorderRefundBo porderRsp = new PorderRefundBo();
        this.copyPayOrder(orderPo, porderRsp);
        rspBO.setPorderRefundBo(porderRsp);
        log.info("\u67e5\u8be2p_order\u8868\u53c2\u6570\u8f6c\u6362\u540e\uff1a" + JSON.toJSONString((Object)porderRsp));
        Page page = new Page();
        page.setPageNo(reqBo.getPageNo());
        PorderRefundTransPo refundPo = new PorderRefundTransPo();
        refundPo.setOrderId(Long.valueOf(reqBo.getOrderId()));
        List<PorderRefundTransPo> refundList = this.porderRefundTransAtomService.queryOrderRefundTrans(refundPo);
        if (refundList == null || refundList.isEmpty()) {
            log.info("\u5728p_order_refund_trans\u8868\u4e2d\u65e0\u6cd5\u67e5\u627e\u5230\u7b26\u5408\u6761\u4ef6[orderId:" + reqBo.getOrderId() + "\u7684\u9000\u6b3e\u8bb0\u5f55");
            rspBO.setRspCode("8888");
            rspBO.setRspName("\u9000\u6b3e\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return rspBO;
        }
        log.info("\u67e5\u8be2\u9000\u6b3e\u8868\u4fe1\u606f\u51fa\u53c2:" + JSON.toJSONString(refundList));
        RefundTransListRspBO rListRspBO = new RefundTransListRspBO();
        for (PorderRefundTransPo temp : refundList) {
            rListRspBO.setRefundOrderId(temp.getRefundOrderId());
            if (temp.getCreateTime() != null) {
                rListRspBO.setCreateTime(new DateTime((Object)temp.getCreateTime()).toString("yyyy-MM-dd hh:mm:ss"));
            }
            if (temp.getPayMethod() != null) {
                rListRspBO.setPayMethod(String.valueOf(temp.getPayMethod()));
                PayMethodPo qryPayMPo = new PayMethodPo();
                qryPayMPo.setPayMethod(temp.getPayMethod());
                List<PayMethodPo> qryPayML = this.payMethodAtomService.queryPayMethod(qryPayMPo);
                if (qryPayML == null || qryPayML.size() < 1) {
                    log.info("\u67e5\u8be2\u51fa\u53c2\u5c01\u88c5\u62a5\u9519\uff0c\u6570\u636e\u5b57\u5178\u65e0\u6cd5\u7ffb\u8bd1payMethod(\u652f\u4ed8\u65b9\u5f0f)" + temp.getPayMethod());
                    rspBO.setRspCode("8888");
                    rspBO.setRspName("\u67e5\u8be2\u51fa\u53c2\u5c01\u88c5\u62a5\u9519");
                    return rspBO;
                }
                rListRspBO.setPayMethodName(qryPayML.get(0).getPayMethodName());
            }
            rListRspBO.setOrgRefundOrderId(temp.getPayNotifyTransId());
            if (temp.getPayFee() != null) {
                BigDecimal payFB = MoneyUtils.haoToYuan((Long)temp.getPayFee());
                rListRspBO.setPayFee(payFB.toPlainString());
            }
            rListRspBO.setOrderStatus(temp.getOrderStatus());
            if (temp.getUpdateTime() != null) {
                rListRspBO.setUpdateTime(new DateTime((Object)temp.getUpdateTime()).toString("yyyy-MM-dd hh:mm:ss"));
            }
            rListRspBO.setRefundDesc(temp.getPayMsg());
            if (temp.getPayIntegral() != null) {
                rListRspBO.setPayScore(String.valueOf(temp.getPayIntegral()));
            }
            rListRspBO.setPayCoupons(temp.getCouponNo());
            rListRspBO.setExchangeId(temp.getExchangeId());
            rListRspBO.setDealTime(new DateTime((Object)orderPo.getCreateTime()).toString("yyyy-MM-dd hh:mm:ss"));
            if (!StringUtils.isEmpty((Object)temp.getOrderStatus())) {
                PCodeListPO qryPCodePo_z = new PCodeListPO();
                qryPCodePo_z.setTypeCode("P_ORDER_ORDER_STATUS");
                qryPCodePo_z.setCodeValue(temp.getOrderStatus());
                List<PCodeListPO> qryPCL_z = this.pCodeListAtomService.queryPCodeListByCondition(qryPCodePo_z);
                if (qryPCL_z == null || qryPCL_z.size() < 1) {
                    log.info("\u67e5\u8be2\u51fa\u53c2\u5c01\u88c5\u62a5\u9519\uff0c\u6570\u636e\u5b57\u5178\u65e0\u6cd5\u7ffb\u8bd1orderStatus" + qryPCodePo_z.getCodeValue());
                    rspBO.setRspCode("8888");
                    rspBO.setRspName("\u67e5\u8be2\u51fa\u53c2\u5c01\u88c5\u62a5\u9519");
                    return rspBO;
                }
                rListRspBO.setOrderStatusName(qryPCL_z.get(0).getCodeName());
            }
            rspList.add(rListRspBO);
        }
        rspBO.setPageSize(reqBo.getPageSize());
        rspBO.setPageNo(reqBo.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(rspList);
        rspBO.setRspCode("0000");
        rspBO.setRspName("\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
        log.info("\u9000\u6b3e\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBO));
        return rspBO;
    }

    private void copyPayOrder(PorderPo orderPo, PorderRefundBo oRefundBo) {
        BeanUtils.copyProperties((Object)orderPo, (Object)oRefundBo);
        if (orderPo.getOrderId() != null) {
            oRefundBo.setOrderId(orderPo.getOrderId().toString());
        }
        if (orderPo.getMerchantId() != null) {
            oRefundBo.setMerchantId(orderPo.getMerchantId().toString());
        }
        if (orderPo.getCreateTime() != null) {
            oRefundBo.setCreateTime(new DateTime((Object)orderPo.getCreateTime()).toString("yyyy-MM-dd hh:mm:ss"));
        }
        if (orderPo.getExpTime() != null) {
            oRefundBo.setExpTime(new DateTime((Object)orderPo.getExpTime()).toString("yyyy-MM-dd hh:mm:ss"));
        }
        if (orderPo.getUpdateTime() != null) {
            oRefundBo.setUpdateTime(new DateTime((Object)orderPo.getUpdateTime()).toString("yyyy-MM-dd hh:mm:ss"));
        }
        PCodeListPO qryPCodePo = new PCodeListPO();
        qryPCodePo.setTypeCode("P_ORDER_ORDER_TYPE");
        qryPCodePo.setCodeValue(orderPo.getOrderType());
        List<PCodeListPO> qryPCL = this.pCodeListAtomService.queryPCodeListByCondition(qryPCodePo);
        if (qryPCL != null && qryPCL.size() > 0) {
            oRefundBo.setOrderTypeName(qryPCL.get(0).getCodeName());
        }
        PCodeListPO qryPCodePo2 = new PCodeListPO();
        qryPCodePo2.setTypeCode("P_ORDER_ORDER_STATUS");
        qryPCodePo2.setCodeValue(orderPo.getOrderStatus());
        List<PCodeListPO> qryPCL2 = this.pCodeListAtomService.queryPCodeListByCondition(qryPCodePo2);
        if (qryPCL2 != null && qryPCL2.size() > 0) {
            oRefundBo.setOrderStatusName(qryPCL2.get(0).getCodeName());
        }
        if (orderPo.getTotalFee() != null) {
            BigDecimal totalFB = MoneyUtils.haoToYuan((Long)orderPo.getTotalFee());
            oRefundBo.setTotalFee(totalFB.toPlainString());
        }
        if (orderPo.getDiscountFee() != null) {
            String discountFB = MoneyUtils.haoToYuan((Long)orderPo.getDiscountFee()).toPlainString();
            oRefundBo.setDiscountFee(discountFB);
        }
        if (orderPo.getBalanceFee() != null) {
            String balanceFB = MoneyUtils.haoToYuan((Long)orderPo.getBalanceFee()).toPlainString();
            oRefundBo.setBalanceFee(balanceFB);
        }
        if (orderPo.getOnlineFee() != null) {
            String onlineFB = MoneyUtils.haoToYuan((Long)orderPo.getOnlineFee()).toPlainString();
            oRefundBo.setOnlineFee(onlineFB);
        }
        if (orderPo.getRealFee() != null) {
            String realFB = MoneyUtils.haoToYuan((Long)orderPo.getRealFee()).toPlainString();
            oRefundBo.setRealFee(realFB);
        }
    }

    private void validateArg(RefundOrderDetailQryReqBO reqBo) {
        if (StringUtils.isEmpty((Object)reqBo)) {
            log.info("\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            log.info("\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684orderId\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

