/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.support.cebpay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.able.BillDownAndTransAble;
import com.tydic.payment.bill.able.BillFile;
import com.tydic.payment.bill.able.BillFileInfo;
import com.tydic.payment.bill.busi.BillPaymentParamQueryBusiService;
import com.tydic.payment.bill.busi.BillPaymentTransRemoveBusiService;
import com.tydic.payment.bill.busi.bo.BillCebPayParam;
import com.tydic.payment.bill.busi.bo.BillPaymentTransRemoveBusiReqBO;
import com.tydic.payment.bill.comb.BillCebPayTransInputCombService;
import com.tydic.payment.bill.comb.bo.BillCebPayTransInputCombReqBo;
import com.tydic.payment.bill.constant.BillFileManager;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.support.cebpay.bo.CebPayResultNativeBo;
import com.tydic.payment.bill.util.BillPropertiesVo;
import com.tydic.payment.bill.util.HttpUtils;
import com.tydic.payment.bill.util.HttpUtilsRspBo;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.busi.TransCebPayBusiService;
import com.tydic.payment.pay.busi.bo.TransCebPayBusiServiceReqBo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service(value="billCEBPayDownAndTrans")
public class BillCebPayDownAndTrans
implements BillDownAndTransAble {
    private static final Logger LOG = LoggerFactory.getLogger(BillCebPayDownAndTrans.class);
    private static final String SERVICE_NAME = "\u5e7f\u5927\u94f6\u884c\u8d26\u5355\u4e0b\u8f7d/\u5165\u5e93\u670d\u52a1";
    @Autowired
    private BillPropertiesVo billPropertiesVo;
    @Autowired
    private BillPaymentParamQueryBusiService billPaymentParamQueryBusiService;
    @Autowired
    private BillCebPayTransInputCombService billCebPayTransInputCombService;
    @Autowired
    private BillPaymentTransRemoveBusiService billPaymentTransRemoveBusiService;
    @Autowired
    private TransCebPayBusiService transCebPayBusiService;

    @Override
    public BillFileInfo doDown(BillExecuteRequest request) throws BillDownAndTransException {
        LoggerProUtils.debug(LOG, "\u5e7f\u5927\u94f6\u884c\u8d26\u5355\u4e0b\u8f7d/\u5165\u5e93\u670d\u52a1 -> \u8d26\u5355\u4e0b\u8f7d\u5165\u53c2\uff1a" + JSON.toJSONString((Object)request));
        BillCebPayParam payParam = this.getPayParam(request);
        String filePath = this.downBillFile(request, payParam);
        return this.readBillFile(request, filePath);
    }

    private BillFileInfo readBillFile(BillExecuteRequest request, String filePath) {
        BillFileInfo billFileInfo = new BillFileInfo();
        billFileInfo.setBillExecuteRequest(request);
        ArrayList<BillFile> billFileList = new ArrayList<BillFile>(1);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            LOG.error("\u5149\u5927\u94f6\u884c\u8d26\u5355\u6587\u4ef6\u8bfb\u53d6\u65f6\u672a\u53d1\u73b0\u5199\u5165\u7684\u6587\u4ef6(\u96be\u9053\u88ab\u5220\u4e86\uff1f)");
            throw new BillDownAndTransException("\u5149\u5927\u94f6\u884c\u8d26\u5355\u6587\u4ef6\u8bfb\u53d6\u65f6\u672a\u53d1\u73b0\u5199\u5165\u7684\u6587\u4ef6(\u96be\u9053\u88ab\u5220\u4e86\uff1f)");
        }
        BillFile billFile = new BillFile();
        billFile.setInputStream(inputStream);
        String sepa = File.separator;
        String fileName = filePath.substring(filePath.lastIndexOf(sepa) + 1, filePath.length());
        billFile.setFileName(fileName);
        billFileList.add(billFile);
        billFileInfo.setBillFileList(billFileList);
        return billFileInfo;
    }

    private String downBillFile(BillExecuteRequest request, BillCebPayParam payParam) {
        String data;
        String merId = payParam.getMerid();
        String dateStr = this.convertLongDateToString(request.getBillDate());
        String sign = DigestUtils.md5DigestAsHex((byte[])(payParam.getKey() + merId).getBytes()).toUpperCase();
        String cebBillUrl = this.billPropertiesVo.getCebBillUrl();
        LOG.info("\u4ece\u914d\u7f6e\u6587\u4ef6\u83b7\u53d6\u5230\u7684\u5149\u5927\u94f6\u884c\u8d26\u5355\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a" + cebBillUrl);
        String url = cebBillUrl + "?merid=" + merId + "&today=" + dateStr + "&sign=" + sign;
        HttpUtilsRspBo httpUtilsRspBo = HttpUtils.sendGet(url);
        if (!"0000".equals(httpUtilsRspBo.getRespCode())) {
            LOG.error("\u5149\u5927\u94f6\u884c\u8d26\u5355\u4e0b\u8f7d\u9519\u8bef\uff1a" + httpUtilsRspBo.getRespDesc());
            throw new BillDownAndTransException("\u5149\u5927\u94f6\u884c\u8d26\u5355\u4e0b\u8f7d\u9519\u8bef\uff1a" + httpUtilsRspBo.getRespDesc());
        }
        String result = httpUtilsRspBo.getResult();
        Map map = (Map)JSONObject.parseObject((String)result, HashMap.class);
        if (map.get(data = "data") == null) {
            String errorInfo = (String)map.get("info");
            LOG.error("\u5149\u5927\u94f6\u884c\u8d26\u5355\u4e0b\u8f7d\u8fd4\u56de\u9519\u8bef\uff1a" + errorInfo + ",status=" + (String)map.get("status"));
            throw new BillDownAndTransException("\u5149\u5927\u94f6\u884c\u8d26\u5355\u4e0b\u8f7d\u8fd4\u56de\u9519\u8bef\uff1a" + errorInfo + ",status=" + (String)map.get("status"));
        }
        String filePath = this.getFilePath(request, payParam);
        File file = this.createFileByPath(filePath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fw);
            out.write(result);
            out.close();
            fw.close();
        }
        catch (IOException e) {
            LOG.error("\u5149\u5927\u94f6\u884c\u4fdd\u5b58\u5230\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BillDownAndTransException("\u5149\u5927\u94f6\u884c\u4fdd\u5b58\u5230\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return file.getAbsolutePath();
    }

    private File createFileByPath(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        } else if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            LOG.error("\u5149\u5927\u94f6\u884c\u4fdd\u5b58\u5230\u6587\u4ef6\u5f02\u5e38\uff08\u521b\u5efa\u6587\u4ef6\u65f6\uff09\uff1a" + e.getMessage());
            throw new BillDownAndTransException("\u5149\u5927\u94f6\u884c\u4fdd\u5b58\u5230\u6587\u4ef6\u5f02\u5e38\uff08\u521b\u5efa\u6587\u4ef6\u65f6\uff09\uff1a" + e.getMessage(), (Throwable)e);
        }
        return file;
    }

    private String getFilePath(BillExecuteRequest request, BillCebPayParam payParam) {
        String sepa = File.separator;
        String tempDir = BillFileManager.getMerchantSavePath();
        tempDir = tempDir + "cebPay" + sepa;
        StringBuilder filePath = new StringBuilder(16);
        filePath.append(tempDir);
        filePath.append(payParam.getMerid());
        filePath.append("-");
        filePath.append(request.getBillDate());
        filePath.append(".data");
        return filePath.toString();
    }

    private String convertLongDateToString(Long longValue) {
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"yyyyMMdd");
        DateTime dateTime = DateTime.parse((String)(longValue + ""), (DateTimeFormatter)format);
        return dateTime.toString("yyyy-MM-dd");
    }

    @Override
    public void doTrans(BillFileInfo billFileInfo) throws BillDownAndTransException {
        List<BillFile> billFileList = billFileInfo.getBillFileList();
        for (BillFile bFile : billFileList) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bFile.getInputStream()));
            String line = null;
            try {
                line = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (IOException e) {
                LOG.error("\u5e7f\u5927\u94f6\u884c\u8d26\u5355\u4e0b\u8f7d/\u5165\u5e93\u670d\u52a1-> \u4ece\u751f\u6210\u7684\u6587\u4ef6\u8bfb\u53d6\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
                throw new BillDownAndTransException("\u5e7f\u5927\u94f6\u884c\u8d26\u5355\u4e0b\u8f7d/\u5165\u5e93\u670d\u52a1-> \u4ece\u751f\u6210\u7684\u6587\u4ef6\u8bfb\u53d6\u4fe1\u606f\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            }
            CebPayResultNativeBo cebPayBo = (CebPayResultNativeBo)JSONObject.parseObject((String)line, CebPayResultNativeBo.class);
            BillCebPayTransInputCombReqBo inputTransBo = new BillCebPayTransInputCombReqBo();
            inputTransBo.setCebPayResultNativeBo(cebPayBo);
            this.billCebPayTransInputCombService.trans(inputTransBo);
        }
    }

    @Override
    public void doDownAndTransClean(BillExecuteRequest request) throws BillDownAndTransException {
        BillPaymentTransRemoveBusiReqBO paymentReqBO = new BillPaymentTransRemoveBusiReqBO();
        paymentReqBO.setBillDate(request.getBillDate());
        paymentReqBO.setPaymentInsId(request.getPaymentInsId());
        paymentReqBO.setPaymentMchId(request.getPaymentMchId());
        this.billPaymentTransRemoveBusiService.removeBatch(paymentReqBO);
        TransCebPayBusiServiceReqBo deleteBo = new TransCebPayBusiServiceReqBo();
        deleteBo.setMerId(request.getPaymentMchId());
        deleteBo.setBillDate(request.getBillDate());
        this.transCebPayBusiService.deleteTrans(deleteBo);
    }

    private BillCebPayParam getPayParam(BillExecuteRequest request) {
        Collection paymentMchList = this.billPaymentParamQueryBusiService.query(BillCebPayParam.class, request.getPaymentInsId());
        if (paymentMchList == null || paymentMchList.size() < 1) {
            throw new BillDownAndTransException("\u4e0b\u8f7d\u652f\u4ed8\u5b9d\u8d26\u5355\u5931\u8d25\uff0c\u67e5\u8be2\u5546\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        for (BillCebPayParam payParam : paymentMchList) {
            if (!Objects.equals(request.getPaymentMchId(), payParam.getMerid())) continue;
            return payParam;
        }
        throw new BillDownAndTransException("\u4e0b\u8f7d\u652f\u4ed8\u5b9d\u8d26\u5355\u5931\u8d25\uff0c\u67e5\u8be2[" + request.getPaymentMchId() + "]\u5546\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
    }
}

