/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProImmediatelyAbilityService;
import com.tydic.payment.pay.ability.bo.PayProImmediatelyAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProImmediatelyAbilityRspBo;
import com.tydic.payment.pay.busi.PayProOrderQueryBusiService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.comb.PayAbleDealPayCombService;
import com.tydic.payment.pay.comb.bo.PayAbleDealPayCombReqBo;
import com.tydic.payment.pay.comb.bo.PayAbleDealPayCombRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.PayProImmediatelyAbilityService"})
public class PayProImmediatelyAbilityServiceImpl
implements PayProImmediatelyAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProImmediatelyAbilityServiceImpl.class);
    @Autowired
    private PayAbleDealPayCombService payAbleDealPayCombService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private PayProOrderQueryBusiService payProOrderQueryBusiService;

    @PostMapping(value={"dealPay"})
    public PayProImmediatelyAbilityRspBo dealPay(@RequestBody PayProImmediatelyAbilityReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u5373\u65f6\u652f\u4ed8ability\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProImmediatelyAbilityRspBo retBo = new PayProImmediatelyAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("214015");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("214015");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("214015");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        Long busiId = busiCodeRspBo.getBusiId();
        PayProOrderQueryBusiReqBo qryOrderBo = new PayProOrderQueryBusiReqBo();
        qryOrderBo.setBusiId(busiId);
        qryOrderBo.setOutOrderId(reqBo.getOriOutOrderId());
        PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo qryOrderRetBo = this.payProOrderQueryBusiService.queryOrderQueryByBusiIdAndOutOrderId(qryOrderBo);
        if (!"0000".equals(qryOrderRetBo.getRespCode())) {
            retBo.setRespCode("214015");
            retBo.setRespDesc("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        PayAbleDealPayCombReqBo dealOrderBo = new PayAbleDealPayCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)dealOrderBo);
        dealOrderBo.setOrderId(qryOrderRetBo.getOrderId());
        dealOrderBo.setPayMethod(Long.valueOf(Long.parseLong(reqBo.getPayMethod())));
        PayAbleDealPayCombRspBo payAbleDealPayCombRspBo = this.payAbleDealPayCombService.dealOrder(dealOrderBo);
        if (!"0000".equals(payAbleDealPayCombRspBo.getRespCode())) {
            retBo.setRespCode("214015");
            retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5931\u8d25:" + payAbleDealPayCombRspBo.getRespDesc());
            return retBo;
        }
        BeanUtils.copyProperties((Object)payAbleDealPayCombRspBo, (Object)retBo);
        retBo.setOutOrderId(reqBo.getOriOutOrderId());
        retBo.setPayFee(payAbleDealPayCombRspBo.getPayFee() != null ? payAbleDealPayCombRspBo.getPayFee() + "" : "");
        retBo.setOrderId(payAbleDealPayCombRspBo.getOrderId() != null ? payAbleDealPayCombRspBo.getOrderId() + "" : "");
        return retBo;
    }

    private String validateArg(PayProImmediatelyAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOriOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027oriOutOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String payMethod = reqBo.getPayMethod();
        if (StringUtils.isEmpty((Object)payMethod)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payMethod\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        String wxBarCodePayMethod = PayProConstants.PayMethod.WX_BAR.getPayMethod() + "";
        String aliPayBarCodePayMethod = PayProConstants.PayMethod.ALI_BAR.getPayMethod() + "";
        if (wxBarCodePayMethod.equals(payMethod) || aliPayBarCodePayMethod.equals(payMethod)) {
            if (StringUtils.isEmpty((Object)reqBo.getAuthCode())) {
                return "\u5fae\u4fe1\uff0c\u652f\u4ed8\u5b9d\u6761\u7801\u652f\u4ed8\u65f6\uff0cauthCode\u5fc5\u4f20";
            }
            reqBo.setAuthCode(reqBo.getAuthCode().trim());
        }
        return null;
    }
}

