/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ali.model.AlipayF2FPrecreateResult;
import com.tydic.payment.pay.ali.model.AlipayTradePrecreateRequestBuilder;
import com.tydic.payment.pay.ali.model.ExtendParams;
import com.tydic.payment.pay.ali.model.GoodsDetail;
import com.tydic.payment.pay.ali.service.impl.AlipayTradeServiceImpl;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.AliQrCodePayBusiService;
import com.tydic.payment.pay.busi.bo.AliQrCodePayReqBO;
import com.tydic.payment.pay.busi.bo.AlipayQrCodeRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.busi.AliQrCodePayBusiService"})
public class AliQrCodePayBusiServiceImpl
implements AliQrCodePayBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliQrCodePayBusiServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    @PostMapping(value={"dealAliQrCodePay"})
    public AlipayQrCodeRspBo dealAliQrCodePay(@RequestBody AliQrCodePayReqBO alipayQrCodeReq) {
        if (alipayQrCodeReq == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)alipayQrCodeReq.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d orderId\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)alipayQrCodeReq.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d merchantId\u80fd\u4e3a\u7a7a");
        }
        if (alipayQrCodeReq.getParamMap().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (alipayQrCodeReq.getTotalFee() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u91d1\u989d\u80fd\u4e3a\u7a7a");
        }
        AlipayQrCodeRspBo alipayQrCodeRsp = new AlipayQrCodeRspBo();
        try {
            PorderPo pOrder = this.payOrderAtomService.queryPorderInfo(Long.parseLong(alipayQrCodeReq.getOrderId()));
            if (pOrder == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            if ("A10".equals(pOrder.getOrderStatus())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8");
            }
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setOrderId(pOrder.getOrderId());
            orderPayTransAtomReq.setBusiId(pOrder.getBusiId());
            orderPayTransAtomReq.setMerchantId(pOrder.getMerchantId());
            orderPayTransAtomReq.setOrderStatus(pOrder.getOrderStatus());
            orderPayTransAtomReq.setPayMethod(Long.parseLong("21"));
            orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)alipayQrCodeReq.getTotalFee()));
            String outTradeNo = this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
            ArrayList<GoodsDetail> goodsDetailList = new ArrayList<GoodsDetail>();
            String notifyUrl = this.payPropertiesVo.getAliNotifyUrl();
            LOGGER.info("\u652f\u4ed8\u5b9d\u901a\u77e5\u5730\u5740\uff1a" + notifyUrl);
            String totalAmount = MoneyUtils.fenToYuan((BigDecimal)alipayQrCodeReq.getTotalFee()).toString();
            String undiscountableAmount = "0.00";
            String sellerId = "";
            String body = pOrder.getDetailName();
            String operatorId = pOrder.getCreateOperId();
            String storeId = String.valueOf(pOrder.getMerchantId());
            ExtendParams extendParams = null;
            String timeoutExpress = "3m";
            AlipayTradePrecreateRequestBuilder builder = new AlipayTradePrecreateRequestBuilder().setSubject(body).setTotalAmount(totalAmount).setOutTradeNo(outTradeNo).setUndiscountableAmount(undiscountableAmount).setSellerId(sellerId).setBody(body).setOperatorId(operatorId).setStoreId(storeId).setExtendParams(extendParams).setTimeoutExpress(timeoutExpress).setGoodsDetailList(goodsDetailList).setNotifyUrl(notifyUrl);
            AlipayTradeServiceImpl tradeService = new AlipayTradeServiceImpl.ClientBuilder().build(String.valueOf(alipayQrCodeReq.getParamMap().get("appid")), String.valueOf(alipayQrCodeReq.getParamMap().get("privateKey")), String.valueOf(alipayQrCodeReq.getParamMap().get("publicKey")), "");
            AlipayF2FPrecreateResult result = tradeService.tradePrecreate(builder);
            if (result == null) {
                LOGGER.info("\u652f\u4ed8\u5b9d\u4e0b\u5355\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u652f\u4ed8\u5b9d\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
            }
            switch (result.getTradeStatus()) {
                case SUCCESS: {
                    JSONObject json = JSONObject.parseObject((String)result.getResponse().getBody()).getJSONObject("alipay_trade_precreate_response");
                    alipayQrCodeRsp.setRspCode("0000");
                    alipayQrCodeRsp.setQrCode(json.getString("qr_code"));
                    alipayQrCodeRsp.setRspName("\u652f\u4ed8\u5b9d\u4e0b\u5355\u6210\u529f");
                    break;
                }
                case FAILED: {
                    JSONObject json2 = JSONObject.parseObject((String)result.getResponse().getBody()).getJSONObject("alipay_trade_precreate_response");
                    alipayQrCodeRsp.setRspCode("8888");
                    alipayQrCodeRsp.setRspName(json2.getString("msg"));
                    break;
                }
                case UNKNOWN: {
                    alipayQrCodeRsp.setRspCode("8888");
                    alipayQrCodeRsp.setRspName("\u672a\u80fd\u8bc6\u522b\u7684\u8fd4\u56de\u9519\u8bef");
                    break;
                }
                default: {
                    alipayQrCodeRsp.setRspCode("8888");
                    alipayQrCodeRsp.setRspName("\u4ea4\u6613\u8fd4\u56de\u72b6\u6001\u5f02\u5e38");
                }
            }
            alipayQrCodeRsp.setEffectiveSeconds(String.valueOf(new BigDecimal(3).multiply(new BigDecimal(60))));
            alipayQrCodeRsp.setPayOrderId(outTradeNo);
        }
        catch (Exception e) {
            LOGGER.error("\u652f\u4ed8\u5b9d\u4e0b\u5355\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            alipayQrCodeRsp.setRspCode("8888");
            alipayQrCodeRsp.setRspName("\u8c03\u7528\u652f\u4ed8\u5b9d\u4e0b\u5355\u5f02\u5e38" + e.getMessage());
        }
        return alipayQrCodeRsp;
    }
}

