/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.ohaotian.plugin.base.bo.TopologyBO;
import com.tydic.payment.bill.busi.QueryRefundBusiService;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundTransByGroupNameReqBO;
import com.tydic.payment.pay.dao.PorderRefundTransMapper;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryRefundBusiService")
public class QueryRefundBusiServiceImpl
implements QueryRefundBusiService {
    @Autowired
    private PorderRefundTransMapper porderRefundTransMapper;

    public QueryRefundRspBO queryByRefundOrderId(String refundOrderId) {
        PorderRefundTransPo reqPO = new PorderRefundTransPo();
        reqPO.setRefundOrderId(refundOrderId);
        PorderRefundTransPo rspPO = this.porderRefundTransMapper.getOrderRfundTransByRefundOrderId(reqPO);
        if (null == rspPO) {
            return null;
        }
        QueryRefundRspBO rspBO = new QueryRefundRspBO();
        BeanUtils.copyProperties((Object)rspPO, (Object)rspBO);
        return rspBO;
    }

    public QueryRefundRspBO queryRefund(Long orderId) {
        PorderRefundTransPo reqPO = new PorderRefundTransPo();
        reqPO.setOrderId(orderId);
        PorderRefundTransPo rspPO = this.porderRefundTransMapper.getOrderRfundTransByRefundOrderId(reqPO);
        if (null == rspPO) {
            return null;
        }
        QueryRefundRspBO rspBO = new QueryRefundRspBO();
        BeanUtils.copyProperties((Object)rspPO, (Object)rspBO);
        return rspBO;
    }

    public List<QueryRefundRspBO> listByOrderId(Long orderId) {
        List<PorderRefundTransPo> pos = this.porderRefundTransMapper.listSuccessByOrderId(orderId);
        if (pos == null || pos.size() < 1) {
            return new ArrayList<QueryRefundRspBO>();
        }
        ArrayList<QueryRefundRspBO> bos = new ArrayList<QueryRefundRspBO>(pos.size());
        for (PorderRefundTransPo po : pos) {
            QueryRefundRspBO bo = new QueryRefundRspBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    public LinkedList<TopologyBO> listDrdsGroupNames() {
        return this.porderRefundTransMapper.listDrdsGroupNames();
    }

    public List<QueryRefundRspBO> listSuccessTransByGroupName(QueryRefundTransByGroupNameReqBO reqBO, String payOrderIdLikeprojectName) {
        List<PorderRefundTransPo> pos = this.porderRefundTransMapper.listSuccessTransByGroupName(reqBO.getPayMethods(), reqBO.getMerchantIds(), reqBO.getBillDate(), reqBO.getGroupName(), payOrderIdLikeprojectName);
        if (pos == null || pos.size() < 1) {
            return new ArrayList<QueryRefundRspBO>();
        }
        ArrayList<QueryRefundRspBO> bos = new ArrayList<QueryRefundRspBO>(pos.size());
        for (PorderRefundTransPo po : pos) {
            QueryRefundRspBO bo = new QueryRefundRspBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    public List<QueryRefundRspBO> listSuccessTransSingleDataBase(QueryRefundTransByGroupNameReqBO reqBO, String payOrderIdLikeprojectName) {
        List<PorderRefundTransPo> pos = this.porderRefundTransMapper.listSuccessTransSingleDataBase(reqBO.getPayMethods(), reqBO.getMerchantIds(), reqBO.getBillDate(), payOrderIdLikeprojectName);
        if (pos == null || pos.size() < 1) {
            return new ArrayList<QueryRefundRspBO>();
        }
        ArrayList<QueryRefundRspBO> bos = new ArrayList<QueryRefundRspBO>(pos.size());
        for (PorderRefundTransPo po : pos) {
            QueryRefundRspBO bo = new QueryRefundRspBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }
}

