/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.comb.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.busi.BillCompareDiffCreateBusiService;
import com.tydic.payment.bill.busi.BillCompareDiffQueryBusiService;
import com.tydic.payment.bill.busi.BillPayBillDayCreateBusiService;
import com.tydic.payment.bill.busi.BillPayTransUpdateSuccessBusiService;
import com.tydic.payment.bill.busi.BillRefundTransUpdateSuccessBusiService;
import com.tydic.payment.bill.busi.QueryPayTransBusiService;
import com.tydic.payment.bill.busi.QueryRefundBusiService;
import com.tydic.payment.bill.busi.bo.BillCompareDiffQueryReqBO;
import com.tydic.payment.bill.busi.bo.BillCompareDiffQueryRspBO;
import com.tydic.payment.bill.busi.bo.BillPayBillDayCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillPayTransUpdateSuccessReqBO;
import com.tydic.payment.bill.busi.bo.BillRefundTransUpdateSuccessReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.bill.comb.BillPayBalanceCombService;
import com.tydic.payment.bill.exception.BillBalanceException;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.TransPaymentMapper;
import com.tydic.payment.pay.dao.po.TransPaymentPO;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billPayBalanceCombService")
public class BillPayBalanceCombServiceImpl
implements BillPayBalanceCombService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private BillCompareDiffQueryBusiService billCompareDiffQueryBusiService;
    private BillPayBillDayCreateBusiService billPayBillDayCreateBusiService;
    private BillPayTransUpdateSuccessBusiService billPayTransUpdateSuccessBusiService;
    private BillRefundTransUpdateSuccessBusiService billRefundTransUpdateSuccessBusiService;
    private BillCompareDiffCreateBusiService billCompareDiffCreateBusiService;
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private QueryPayTransBusiService queryPayTransBusiService;
    @Autowired
    private QueryRefundBusiService queryRefundBusiService;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private TransPaymentMapper transPaymentMapper;

    @Autowired
    public BillPayBalanceCombServiceImpl(BillCompareDiffQueryBusiService billCompareDiffQueryBusiService, BillPayBillDayCreateBusiService billPayBillDayCreateBusiService, BillPayTransUpdateSuccessBusiService billPayTransUpdateSuccessBusiService, BillRefundTransUpdateSuccessBusiService billRefundTransUpdateSuccessBusiService, BillCompareDiffCreateBusiService billCompareDiffCreateBusiService, CallBackNoticeService callBackNoticeService) {
        this.billCompareDiffQueryBusiService = billCompareDiffQueryBusiService;
        this.billPayBillDayCreateBusiService = billPayBillDayCreateBusiService;
        this.billPayTransUpdateSuccessBusiService = billPayTransUpdateSuccessBusiService;
        this.billRefundTransUpdateSuccessBusiService = billRefundTransUpdateSuccessBusiService;
        this.billCompareDiffCreateBusiService = billCompareDiffCreateBusiService;
        this.callBackNoticeService = callBackNoticeService;
    }

    public void doBalanceClean(BillExecuteRequest request) throws BillBalanceException {
    }

    public void doBalance(BillExecuteRequest request) throws BillBalanceException {
        BillCompareDiffQueryReqBO billCompareDiffQueryReqBO = new BillCompareDiffQueryReqBO();
        billCompareDiffQueryReqBO.setBillDate(request.getBillDate());
        billCompareDiffQueryReqBO.setPaymentInsId(request.getPaymentInsId());
        billCompareDiffQueryReqBO.setPaymentMchId(request.getPaymentMchId());
        List billCompareDiffQueryRspBoS = this.billCompareDiffQueryBusiService.query(billCompareDiffQueryReqBO);
        if (billCompareDiffQueryRspBoS == null || billCompareDiffQueryRspBoS.size() < 1) {
            LoggerProUtils.debug(this.logger, "\u67e5\u8be2\u5f02\u5e38\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a" + request.toString());
            return;
        }
        for (BillCompareDiffQueryRspBO diff : billCompareDiffQueryRspBoS) {
            if (!Objects.equals(0L, diff.getDealFlag())) continue;
            if (2 == diff.getDiffType()) {
                this.updateDiffDealFlagTodo(diff);
                this.updatePayBillDayFlag(diff, "2");
                continue;
            }
            if (3 == diff.getDiffType()) {
                this.billDayCreate(diff, request.getPaymentMchId());
                continue;
            }
            if (4 != diff.getDiffType()) continue;
            this.updateDiffDealFlagTodo(diff);
            this.updatePayBillDayFlag(diff, "4");
        }
    }

    private void updatePayBillDayFlag(BillCompareDiffQueryRspBO diff, String flag) {
        BillPayBillDayCreateReqBO reqBO = new BillPayBillDayCreateReqBO();
        reqBO.setOrderId(diff.getOrderId());
        reqBO.setPayOrderId(diff.getPayOrderId());
        reqBO.setRefundOrderId(diff.getRefundOrderId());
        reqBO.setFlag(flag);
        this.billPayBillDayCreateBusiService.updateFlag(reqBO);
    }

    private void updateDiffDealFlagTodo(BillCompareDiffQueryRspBO diff) {
        this.billCompareDiffCreateBusiService.updateDealFlag(diff.getId(), diff.getOrderId(), Long.valueOf(-1L));
    }

    private void billDayCreate(BillCompareDiffQueryRspBO diff, String paymentMchId) {
        if ("01".equals(diff.getOrderType())) {
            BillPayTransUpdateSuccessReqBO reqBO = new BillPayTransUpdateSuccessReqBO();
            QueryPayTransRspBO queryPayTransRspBO = this.queryPayTransBusiService.queryByPayOrderId(diff.getPayOrderId());
            if (queryPayTransRspBO != null && !"A10".equals(queryPayTransRspBO.getOrderStatus())) {
                TransPaymentPO qryTrans = new TransPaymentPO();
                qryTrans.setOrderType(diff.getOrderType());
                qryTrans.setTypeOrderId(diff.getPayOrderId());
                List<TransPaymentPO> query = this.transPaymentMapper.query(qryTrans);
                diff.setOrderId(queryPayTransRspBO.getOrderId());
                reqBO.setOrderId(queryPayTransRspBO.getOrderId());
                reqBO.setPayOrderId(diff.getPayOrderId());
                reqBO.setPayNotifyTransId(diff.getBillTransId());
                reqBO.setPayMsg("\u4ea4\u6613\u6210\u529f");
                reqBO.setRealFee(diff.getPayTotalFee());
                reqBO.setTradeTime(!CollUtil.isEmpty(query) && query.get(0) != null && !StrUtil.isEmpty((CharSequence)query.get(0).getTradeTime()) ? query.get(0).getTradeTime() : diff.getBillDate().toString());
                this.billPayTransUpdateSuccessBusiService.updateSuccess(reqBO);
                try {
                    this.addPayBillDataPayTrans(queryPayTransRspBO.getOrderId(), queryPayTransRspBO, diff, paymentMchId);
                }
                catch (Exception e) {
                    throw new BillBalanceException("\u5e73\u8d26\u5904\u7406\u5f02\u5e38\uff0c\u63d2\u5165paybill-day\u8868(\u652f\u4ed8)\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                }
                this.updatePayBillDayFlag(diff, "3");
                this.billCompareDiffCreateBusiService.updateDealFlag(diff.getId(), diff.getOrderId(), Long.valueOf(1L));
                return;
            }
        } else if ("02".equals(diff.getOrderType())) {
            BillRefundTransUpdateSuccessReqBO reqBO = new BillRefundTransUpdateSuccessReqBO();
            QueryRefundRspBO queryRefundRspBO = this.queryRefundBusiService.queryByRefundOrderId(diff.getRefundOrderId());
            if (queryRefundRspBO != null && !"B10".equals(queryRefundRspBO.getOrderStatus())) {
                TransPaymentPO qryTrans = new TransPaymentPO();
                qryTrans.setOrderType(diff.getOrderType());
                qryTrans.setTypeOrderId(diff.getRefundOrderId());
                List<TransPaymentPO> query = this.transPaymentMapper.query(qryTrans);
                diff.setOrderId(queryRefundRspBO.getOrderId());
                reqBO.setOrderId(queryRefundRspBO.getOrderId());
                reqBO.setRefundOrderId(diff.getRefundOrderId());
                reqBO.setPayNotifyTransId(diff.getBillTransId());
                reqBO.setPayMsg("\u4ea4\u6613\u6210\u529f");
                reqBO.setRealFee(diff.getPayTotalFee());
                reqBO.setTradeTime(!CollUtil.isEmpty(query) && query.get(0) != null && !StrUtil.isEmpty((CharSequence)query.get(0).getTradeTime()) ? query.get(0).getTradeTime() : diff.getBillDate().toString());
                this.billRefundTransUpdateSuccessBusiService.updateSuccess(reqBO);
                try {
                    this.addPayBillDataRefundTrans(queryRefundRspBO.getOrderId(), queryRefundRspBO, diff, paymentMchId);
                }
                catch (Exception e) {
                    throw new BillBalanceException("\u5e73\u8d26\u5904\u7406\u5f02\u5e38\uff0c\u63d2\u5165paybill-day\u8868(\u9000\u6b3e)\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                }
                this.updatePayBillDayFlag(diff, "3");
                this.billCompareDiffCreateBusiService.updateDealFlag(diff.getId(), diff.getOrderId(), Long.valueOf(1L));
                return;
            }
        }
        this.updateDiffDealFlagTodo(diff);
    }

    private void addPayBillDataPayTrans(Long orderId, QueryPayTransRspBO trans, BillCompareDiffQueryRspBO diff, String paymentMchId) throws Exception {
        BillPayBillDayCreateReqBO createReqBO = new BillPayBillDayCreateReqBO();
        createReqBO.setOrderId(orderId);
        createReqBO.setPayOrderId(trans.getPayOrderId());
        createReqBO.setBillDate(diff.getBillDate());
        createReqBO.setBillTransId(trans.getPayNotifyTransId());
        createReqBO.setPayMethod(trans.getPayMethod());
        createReqBO.setCreateTime(this.payMethodMapper.getDBDate().getDate());
        createReqBO.setTradeTime(trans.getTradeTime());
        createReqBO.setPaymentInsId(diff.getPaymentInsId());
        createReqBO.setPaymentMchId(paymentMchId);
        createReqBO.setRealFee(Long.valueOf(MoneyUtils.haoToFen((Long)trans.getPayFee()).longValue()));
        this.billPayBillDayCreateBusiService.createTrans(createReqBO);
    }

    private void addPayBillDataRefundTrans(Long orderId, QueryRefundRspBO trans, BillCompareDiffQueryRspBO diff, String paymentMchId) throws Exception {
        BillPayBillDayCreateReqBO createReqBO = new BillPayBillDayCreateReqBO();
        createReqBO.setOrderId(orderId);
        createReqBO.setPayOrderId(trans.getPayOrderId());
        createReqBO.setRefundOrderId(trans.getRefundOrderId());
        createReqBO.setBillDate(diff.getBillDate());
        createReqBO.setBillTransId(trans.getPayNotifyTransId());
        createReqBO.setPayMethod(trans.getPayMethod());
        createReqBO.setCreateTime(this.payMethodMapper.getDBDate().getDate());
        createReqBO.setTradeTime(trans.getTradeTime());
        createReqBO.setPaymentInsId(diff.getPaymentInsId());
        createReqBO.setPaymentMchId(paymentMchId);
        createReqBO.setRealFee(Long.valueOf(MoneyUtils.haoToFen((Long)trans.getPayFee()).longValue()));
        this.billPayBillDayCreateBusiService.createTrans(createReqBO);
    }
}

