/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.support.alipay;

import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.able.BillDownAndTransAble;
import com.tydic.payment.bill.able.BillFile;
import com.tydic.payment.bill.able.BillFileInfo;
import com.tydic.payment.bill.busi.AliPayBillDownloadBusiService;
import com.tydic.payment.bill.busi.BillAliPayTransRemoveBusiService;
import com.tydic.payment.bill.busi.BillPaymentParamQueryBusiService;
import com.tydic.payment.bill.busi.BillPaymentTransRemoveBusiService;
import com.tydic.payment.bill.busi.bo.AliPayBillDownloadBusiServiceReqBO;
import com.tydic.payment.bill.busi.bo.BillAliPayParam;
import com.tydic.payment.bill.busi.bo.BillAliPayTransRemoveBusiReqBO;
import com.tydic.payment.bill.busi.bo.BillPaymentTransRemoveBusiReqBO;
import com.tydic.payment.bill.comb.BillAliPayTransCombService;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.util.BillFileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="billAliPayDownAndTrans")
public class BillAliPayDownAndTrans
implements BillDownAndTransAble {
    private static final Logger logger = LoggerFactory.getLogger(BillAliPayDownAndTrans.class);
    private boolean isDebug = logger.isDebugEnabled();
    @Autowired
    private BillPaymentTransRemoveBusiService billPaymentTransRemoveBusiService;
    @Autowired
    private BillAliPayTransRemoveBusiService billAliPayTransRemoveBusiService;
    @Autowired
    private AliPayBillDownloadBusiService aliPayBillDownloadBusiService;
    @Autowired
    private BillPaymentParamQueryBusiService billPaymentParamQueryBusiService;
    @Autowired
    private BillAliPayTransCombService billAliPayTransCombService;

    @Override
    public void doTrans(BillFileInfo billFileInfo) throws BillDownAndTransException {
        String paymentMchId = billFileInfo.getBillExecuteRequest().getPaymentMchId();
        for (BillFile billFile : billFileInfo.getBillFileList()) {
            InputStreamReader reader = new InputStreamReader(billFile.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(reader);
            try {
                String content;
                bufferedReader.readLine();
                bufferedReader.readLine();
                bufferedReader.readLine();
                bufferedReader.readLine();
                bufferedReader.readLine();
                while ((content = bufferedReader.readLine()) != null && !content.contains("-----")) {
                    this.billAliPayTransCombService.trans(content, paymentMchId);
                }
            }
            catch (Exception ex) {
                throw new BillDownAndTransException("\u652f\u4ed8\u5b9d\u8d26\u5355\u6570\u636e\u5165\u5e93\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
            }
            try {
                bufferedReader.close();
                ((Reader)reader).close();
                billFile.getInputStream().close();
            }
            catch (IOException ex) {
                logger.warn("\u5173\u95ed\u652f\u4ed8\u5b9d\u8d26\u5355\u6570\u636e\u8bfb\u53d6\u6d41\u5f02\u5e38\uff1a" + ex.getMessage());
            }
        }
    }

    @Override
    public void doDownAndTransClean(BillExecuteRequest request) throws BillDownAndTransException {
        BillPaymentTransRemoveBusiReqBO paymentReqBO = new BillPaymentTransRemoveBusiReqBO();
        paymentReqBO.setBillDate(request.getBillDate());
        paymentReqBO.setPaymentInsId(request.getPaymentInsId());
        paymentReqBO.setPaymentMchId(request.getPaymentMchId());
        this.billPaymentTransRemoveBusiService.removeBatch(paymentReqBO);
        BillAliPayTransRemoveBusiReqBO reqBO = new BillAliPayTransRemoveBusiReqBO();
        reqBO.setBillDate(request.getBillDate());
        reqBO.setPaymentInsId(request.getPaymentInsId());
        reqBO.setPaymentMchId(request.getPaymentMchId());
        this.billAliPayTransRemoveBusiService.removeBatch(reqBO);
    }

    @Override
    public BillFileInfo doDown(BillExecuteRequest request) throws BillDownAndTransException {
        BillAliPayParam payParam = this.getPayParam(request);
        String filePath = this.downBillFile(request, payParam);
        return this.readBillFile(request, filePath);
    }

    private BillFileInfo readBillFile(BillExecuteRequest request, String filePath) {
        BillFileInfo billFileInfo = new BillFileInfo();
        billFileInfo.setBillExecuteRequest(request);
        ArrayList<BillFile> billFileList = new ArrayList<BillFile>(1);
        try {
            ZipEntry entry;
            ZipFile zf = new ZipFile(filePath, Charset.forName("GBK"));
            FileInputStream in = new FileInputStream(filePath);
            ZipInputStream zin = new ZipInputStream((InputStream)in, Charset.forName("GBK"));
            while ((entry = zin.getNextEntry()) != null && !entry.isDirectory()) {
                String line;
                long size;
                if (entry.getName().lastIndexOf("\u4e1a\u52a1\u660e\u7ec6.csv") == -1 || (size = entry.getSize()) <= 0L) continue;
                StringBuilder builder = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(entry), "GBK"));
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                    builder.append("\n");
                }
                br.close();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(builder.toString().getBytes());
                String fileName = BillFileUtils.buildBillFileNameByRequest(request);
                BillFile billFile = new BillFile();
                billFile.setFileName(fileName);
                billFile.setInputStream(inputStream);
                billFileList.add(billFile);
            }
            zin.closeEntry();
            zin.close();
            zf.close();
            in.close();
            File file = new File(filePath);
            logger.debug("\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)filePath);
            if (file.delete()) {
                logger.debug("\u6587\u4ef6\u5df2\u7ecf\u5220\u9664");
            } else {
                logger.debug("\u6587\u4ef6\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.debug("\u5904\u7406\u538b\u7f29\u6587\u4ef6\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new BillDownAndTransException("\u5904\u7406\u538b\u7f29\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        billFileInfo.setBillFileList(billFileList);
        return billFileInfo;
    }

    private String downBillFile(BillExecuteRequest request, BillAliPayParam payParam) {
        String filename;
        AliPayBillDownloadBusiServiceReqBO downReqBO = new AliPayBillDownloadBusiServiceReqBO();
        downReqBO.setBillDate(request.getBillDate().toString());
        downReqBO.setAppid(payParam.getAppid());
        downReqBO.setPrivateKey(payParam.getPrivateKey());
        downReqBO.setPublicKey(payParam.getPublicKey());
        try {
            filename = this.aliPayBillDownloadBusiService.dealAliPayBillDownload(downReqBO);
        }
        catch (Exception e) {
            if (this.isDebug) {
                logger.debug("\u652f\u4ed8\u5b9d\u8d26\u5355\u4e0b\u8f7d\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            throw new BillDownAndTransException("\u8d26\u5355\u4e0b\u8f7d\u5f02\u5e38", (Throwable)e);
        }
        if (StringUtils.isEmpty((Object)filename)) {
            throw new BillDownAndTransException("\u8d26\u5355\u4e0b\u8f7d\u5f02\u5e38");
        }
        return filename;
    }

    private BillAliPayParam getPayParam(BillExecuteRequest request) {
        Collection paymentMchList = this.billPaymentParamQueryBusiService.query(BillAliPayParam.class, request.getPaymentInsId());
        if (paymentMchList == null || paymentMchList.size() < 1) {
            throw new BillDownAndTransException("\u4e0b\u8f7d\u652f\u4ed8\u5b9d\u8d26\u5355\u5931\u8d25\uff0c\u67e5\u8be2\u5546\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        for (BillAliPayParam payParam : paymentMchList) {
            if (!Objects.equals(request.getPaymentMchId(), payParam.getAppid())) continue;
            return payParam;
        }
        throw new BillDownAndTransException("\u4e0b\u8f7d\u652f\u4ed8\u5b9d\u8d26\u5355\u5931\u8d25\uff0c\u67e5\u8be2[" + request.getPaymentMchId() + "]\u5546\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
    }
}

