/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.support.cashpay;

import com.ohaotian.plugin.base.bo.TopologyBO;
import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.able.BillDownAndTransAble;
import com.tydic.payment.bill.able.BillFile;
import com.tydic.payment.bill.able.BillFileInfo;
import com.tydic.payment.bill.busi.BillPaymentTransCreateBusiService;
import com.tydic.payment.bill.busi.BillPaymentTransRemoveBusiService;
import com.tydic.payment.bill.busi.PaymentInsIdBusiService;
import com.tydic.payment.bill.busi.QueryPayTransBusiService;
import com.tydic.payment.bill.busi.QueryRefundBusiService;
import com.tydic.payment.bill.busi.bo.BillPaymentTransCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillPaymentTransRemoveBusiReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransByGroupNameReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundTransByGroupNameReqBO;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.exception.BillSyncPayDayException;
import com.tydic.payment.pay.busi.BusiPaymentMerchantQueryBusiService;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantInfoBusiBO;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantQueryBusiReqBO;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantQueryBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="billCashPayDownAndTrans")
public class BillCashPayDownAndTrans
implements BillDownAndTransAble {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PaymentInsIdBusiService paymentInsIdBusiService;
    private QueryRefundBusiService queryRefundBusiService;
    private QueryPayTransBusiService queryPayTransBusiService;
    private BillPaymentTransRemoveBusiService billPaymentTransRemoveBusiService;
    private BillPaymentTransCreateBusiService billPaymentTransCreateBusiService;
    private BusiPaymentMerchantQueryBusiService busiPaymentMerchantQueryBusiService;

    @Autowired
    public BillCashPayDownAndTrans(PaymentInsIdBusiService paymentInsIdBusiService, QueryRefundBusiService queryRefundBusiService, QueryPayTransBusiService queryPayTransBusiService, BillPaymentTransRemoveBusiService billPaymentTransRemoveBusiService, BillPaymentTransCreateBusiService billPaymentTransCreateBusiService, BusiPaymentMerchantQueryBusiService busiPaymentMerchantQueryBusiService) {
        this.paymentInsIdBusiService = paymentInsIdBusiService;
        this.queryRefundBusiService = queryRefundBusiService;
        this.queryPayTransBusiService = queryPayTransBusiService;
        this.billPaymentTransRemoveBusiService = billPaymentTransRemoveBusiService;
        this.billPaymentTransCreateBusiService = billPaymentTransCreateBusiService;
        this.busiPaymentMerchantQueryBusiService = busiPaymentMerchantQueryBusiService;
    }

    @Override
    public void doTrans(BillFileInfo billFileInfo) throws BillDownAndTransException {
        BillExecuteRequest request = billFileInfo.getBillExecuteRequest();
        BusiPaymentMerchantQueryBusiReqBO queryBusiReqBO = new BusiPaymentMerchantQueryBusiReqBO();
        queryBusiReqBO.setPaymentInsId(request.getPaymentInsId());
        queryBusiReqBO.setPaymentMchId(request.getPaymentMchId());
        BusiPaymentMerchantQueryBusiRspBO queryBusiRspBO = this.busiPaymentMerchantQueryBusiService.query(queryBusiReqBO);
        if (queryBusiRspBO == null) {
            this.logger.debug("\u67e5\u8be2\u4e1a\u52a1\u5546\u6237ID\u96c6\u5408\u4e3a\u7a7a\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)queryBusiReqBO);
            throw new BillSyncPayDayException("\u67e5\u8be2\u4e1a\u52a1\u5546\u6237ID\u96c6\u5408\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)queryBusiRspBO.getMerchantInfoList())) {
            this.logger.debug("\u67e5\u8be2\u4e1a\u52a1\u5546\u6237ID\u96c6\u5408\u4e3a\u7a7a\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)queryBusiReqBO);
            throw new BillSyncPayDayException("\u67e5\u8be2\u4e1a\u52a1\u5546\u6237ID\u96c6\u5408\u4e3a\u7a7a");
        }
        Collection merchantInfoList = queryBusiRspBO.getMerchantInfoList();
        ArrayList<Long> merchantIdList = new ArrayList<Long>(merchantInfoList.size());
        for (BusiPaymentMerchantInfoBusiBO tempBO : merchantInfoList) {
            merchantIdList.add(tempBO.getMerchantId());
        }
        List payMethods = this.paymentInsIdBusiService.listPayMethodByPaymentInsId(request.getPaymentInsId());
        this.transPay(request, payMethods, merchantIdList);
        this.transRefund(request, payMethods, merchantIdList);
    }

    @Override
    public void doDownAndTransClean(BillExecuteRequest request) throws BillDownAndTransException {
        BillPaymentTransRemoveBusiReqBO paymentReqBO = new BillPaymentTransRemoveBusiReqBO();
        paymentReqBO.setBillDate(request.getBillDate());
        paymentReqBO.setPaymentInsId(request.getPaymentInsId());
        paymentReqBO.setPaymentMchId(request.getPaymentMchId());
        this.billPaymentTransRemoveBusiService.removeBatch(paymentReqBO);
    }

    @Override
    public BillFileInfo doDown(BillExecuteRequest request) throws BillDownAndTransException {
        BillFileInfo billFileInfo = new BillFileInfo();
        billFileInfo.setBillExecuteRequest(request);
        billFileInfo.setBillFileList(new ArrayList<BillFile>(0));
        return billFileInfo;
    }

    private void transRefund(BillExecuteRequest request, List<Long> payMethods, List<Long> merchantIds) {
        LinkedList groupNames = this.queryRefundBusiService.listDrdsGroupNames();
        QueryRefundTransByGroupNameReqBO queryReqBO = new QueryRefundTransByGroupNameReqBO();
        queryReqBO.setBillDate(request.getBillDate());
        queryReqBO.setPayMethods(payMethods);
        queryReqBO.setMerchantIds(merchantIds);
        for (TopologyBO topology : groupNames) {
            queryReqBO.setGroupName(topology.getGroupName());
            List transRefundList = this.queryRefundBusiService.listSuccessTransByGroupName(queryReqBO, null);
            if (CollectionUtils.isEmpty((Collection)transRefundList)) {
                this.logger.debug("\u73b0\u91d1\u652f\u4ed8\uff1a\u9000\u6b3e\u6570\u636e\u5165\u5e93\uff0c\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)queryReqBO);
                continue;
            }
            this.createByTransRefund(transRefundList, request);
        }
    }

    private void createByTransRefund(List<QueryRefundRspBO> transRefundList, BillExecuteRequest request) {
        for (QueryRefundRspBO trans : transRefundList) {
            BillPaymentTransCreateReqBO createReqBO = new BillPaymentTransCreateReqBO();
            createReqBO.setOrderId(trans.getOrderId());
            createReqBO.setOrderType("02");
            createReqBO.setTypeOrderId(trans.getRefundOrderId());
            createReqBO.setBusiId(trans.getBusiId());
            createReqBO.setBillDate(request.getBillDate());
            createReqBO.setPaymentInsId(request.getPaymentInsId());
            createReqBO.setPaymentMchId(request.getPaymentMchId());
            createReqBO.setTypeTransId(trans.getRefundOrderId());
            createReqBO.setRealFee(Long.valueOf(MoneyUtils.haoToFen((Long)trans.getPayFee()).longValue()));
            createReqBO.setBillFlag("0");
            this.billPaymentTransCreateBusiService.create(createReqBO);
        }
    }

    private void transPay(BillExecuteRequest request, List<Long> payMethods, List<Long> merchantIds) {
        LinkedList groupNames = this.queryPayTransBusiService.listDrdsGroupNames();
        QueryPayTransByGroupNameReqBO queryReqBO = new QueryPayTransByGroupNameReqBO();
        queryReqBO.setBillDate(request.getBillDate());
        queryReqBO.setPayMethods(payMethods);
        queryReqBO.setMerchantIds(merchantIds);
        for (TopologyBO topology : groupNames) {
            queryReqBO.setGroupName(topology.getGroupName());
            List transPayList = this.queryPayTransBusiService.listSuccessTransByGroupName(queryReqBO, null);
            if (CollectionUtils.isEmpty((Collection)transPayList)) {
                this.logger.debug("\u73b0\u91d1\u652f\u4ed8\uff1a\u652f\u4ed8\u6570\u636e\u5165\u5e93\uff0c\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)queryReqBO);
                continue;
            }
            this.createByTransPay(transPayList, request);
        }
    }

    private void createByTransPay(List<QueryPayTransRspBO> transPayList, BillExecuteRequest request) {
        for (QueryPayTransRspBO trans : transPayList) {
            BillPaymentTransCreateReqBO createReqBO = new BillPaymentTransCreateReqBO();
            createReqBO.setOrderId(trans.getOrderId());
            createReqBO.setOrderType("01");
            createReqBO.setTypeOrderId(trans.getPayOrderId());
            createReqBO.setBusiId(trans.getBusiId());
            createReqBO.setBillDate(request.getBillDate());
            createReqBO.setPaymentInsId(request.getPaymentInsId());
            createReqBO.setPaymentMchId(request.getPaymentMchId());
            createReqBO.setTypeTransId(trans.getPayOrderId());
            createReqBO.setRealFee(Long.valueOf(MoneyUtils.haoToFen((Long)trans.getPayFee()).longValue()));
            createReqBO.setBillFlag("0");
            this.billPaymentTransCreateBusiService.create(createReqBO);
        }
    }
}

