/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.tydic.payment.pay.atom.PayProMerchantQueryCacheAtomService;
import com.tydic.payment.pay.config.PayProCacheManager;
import com.tydic.payment.pay.constant.PayProCacheKeys;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayProMerchantQueryCacheAtomServiceImpl
implements PayProMerchantQueryCacheAtomService {
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;
    @Autowired
    private PayProCacheManager payProCacheManager;

    @Override
    public List<MerChantInfoPo> queryMerchantWithCache(MerChantInfoPo reqPo) {
        Long merchantId;
        ArrayList<MerChantInfoPo> retList = new ArrayList<MerChantInfoPo>();
        if (reqPo == null) {
            reqPo = new MerChantInfoPo();
        }
        if ((merchantId = reqPo.getMerchantId()) != null) {
            String cacheKey = PayProCacheKeys.PAY_CACHE_MERCHANT_ID.getKey() + merchantId;
            MerChantInfoPo cachedMerchant = this.payProCacheManager.get(cacheKey, MerChantInfoPo.class);
            if (cachedMerchant != null) {
                retList.add(cachedMerchant);
                return retList;
            }
            MerChantInfoPo qryMerchantPo = new MerChantInfoPo();
            qryMerchantPo.setMerchantId(merchantId);
            MerChantInfoPo merChantInfoPo = this.merChantInfoMapper.queryMerChantInfoById(qryMerchantPo);
            if (merChantInfoPo == null) {
                throw new BusinessException("215002", "\u8be5\u5546\u6237\u4e0d\u5b58\u5728");
            }
            this.payProCacheManager.set(cacheKey, merChantInfoPo, true, null);
            retList.add(merChantInfoPo);
            return retList;
        }
        return this.merChantInfoMapper.queryMerChantInfoByCondition(reqPo);
    }
}

