/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.payment.pay.atom.AbilityToPayPlatformService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.bo.PayProBaseRspBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.common.util.HttpUtil;
import com.tydic.payment.pay.config.quartz.CallBackSender;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.CodeTypeValueConstants;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CallBackNoticeConsume
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(CallBackNoticeConsume.class);
    @Value(value="${send.post.way:0}")
    private String sendPostWay;
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private AbilityToPayPlatformService abilityToPayPlatformService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private CallBackSender callBackSender;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    public void dealPayNoticeByAbility(String data) {
        log.info("\u652f\u4ed8\u4e2d\u5fc3\u6d88\u8d39\u8005\u542f\u52a8\uff0c\u5165\u53c2\u4e3a\uff1a" + data);
        JSONObject req = JSONObject.parseObject((String)data);
        String busiId = req.getString("busiId");
        String busiData = req.getString("busiData");
        req.remove((Object)"busiId");
        req.remove((Object)"notifyUrl");
        String orderId = req.getString("transactionsId");
        PorderPo pOrder = this.payOrderAtomService.queryPorderInfo(Long.parseLong(orderId));
        try {
            DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
            dataEncryptionReqBo.setBusiId(String.valueOf(pOrder.getBusiId()));
            dataEncryptionReqBo.setContent(data);
            DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
            JSONObject reqData = new JSONObject();
            reqData.put("BUSI_ID", (Object)busiId);
            reqData.put("CONTENT", (Object)dataEncryptionRspBo.getEncrypData());
            JSONObject json = new JSONObject();
            json.put("CALL_BACK_NOTICE_REQ", (Object)reqData);
            log.info("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u7684\u76ee\u6807\u5730\u5740\u4e3a\uff1a" + this.payPropertiesVo.getAbilityPayNotifyUrl());
            log.info("\u8c03\u7528\u53c2\u6570\u4e3a\uff1a" + json);
            String resultData = this.abilityToPayPlatformService.abilityToPayPlatform(this.payPropertiesVo.getAbilityPayNotifyUrl() + busiId + "/v1", json);
            JSONObject result = JSONObject.parseObject((String)resultData);
            String backMessage = result.getJSONObject("UNI_BSS_BODY").getJSONObject("CALL_BACK_NOTICE_RSP").getString("NOTIFY_RESULT");
            if ("SUCCESS".equalsIgnoreCase(backMessage)) {
                pOrder.setCustyNotifyCode("0");
                pOrder.setCustNotifyMsg("SUCCESS");
            } else {
                pOrder.setCustyNotifyCode("1");
                pOrder.setCustNotifyMsg("FAIL");
            }
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u901a\u77e5\u5f02\u5e38\uff1a orderId = " + orderId + "\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), (Throwable)e);
            pOrder.setCustyNotifyCode("1");
            pOrder.setCustNotifyMsg(e.getMessage());
        }
        pOrder.setCustNotifyTime(this.queryDBDateBusiService.getDBDate());
        this.payOrderAtomService.update(pOrder);
    }

    public void dealPayNoticeByHttp(String data) {
        log.info("\u652f\u4ed8\u7ed3\u679chttp\u56de\u8c03\uff0c\u63a5\u6536\u5230\u56de\u8c03\u7684\u5165\u53c2\u4e3a\uff1a" + data);
        JSONObject req = JSONObject.parseObject((String)data);
        String busiId = req.getString("busiId");
        String notifyUrl = req.getString("notifyUrl");
        req.remove((Object)"busiId");
        req.remove((Object)"notifyUrl");
        String orderIdStr = req.getString("transactionsId");
        String paymentInsReturnData = req.getString("paymentInsReturnData");
        Long orderId = Long.parseLong(orderIdStr);
        PorderPo tempOrder = this.payOrderAtomService.queryPorderInfo(orderId);
        PorderPayTransPo porderPayTransPo = new PorderPayTransPo();
        porderPayTransPo.setOrderId(orderId);
        porderPayTransPo.setOrderStatus("A10");
        List<PorderPayTransPo> pOrderTrans = this.porderPayTransAtomService.queryOrderPayTrans(porderPayTransPo);
        if (!CollectionUtils.isEmpty(pOrderTrans)) {
            String payOrderId = pOrderTrans.get(0).getPayOrderId();
            req.put("payOrderId", (Object)payOrderId);
            req.put("paymentInsReturnData", (Object)paymentInsReturnData);
            if (!StringUtils.isEmpty((Object)paymentInsReturnData)) {
                PorderPayTransAtomReqBo updateTransPo = new PorderPayTransAtomReqBo();
                updateTransPo.setPayMsg(paymentInsReturnData);
                updateTransPo.setOrderId(orderId);
                updateTransPo.setPayOrderId(payOrderId);
                try {
                    this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(updateTransPo);
                }
                catch (Exception e) {
                    throw new BusinessException("216033", "\u56de\u8c03\u66f4\u65b0payMsg\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        PorderPo pOrder = new PorderPo();
        pOrder.setOrderId(tempOrder.getOrderId());
        Date dbDate = this.queryDBDateBusiService.getDBDate();
        try {
            String resultData;
            DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
            dataEncryptionReqBo.setBusiId(String.valueOf(tempOrder.getBusiId()));
            dataEncryptionReqBo.setContent(req.toJSONString());
            DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
            log.info("\u6d88\u606f\u53d1\u9001\u7684\u4e3b\u9898\u5185\u5bb9\u4e3a \uff1a" + dataEncryptionRspBo.getEncrypData() + "\u76ee\u6807\u5730\u5740\u4e3a\uff1a" + notifyUrl);
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put("busiId", tempOrder.getBusiId() + "");
            postParams.put("busiCode", tempOrder.getBusiCode());
            postParams.put("content", dataEncryptionRspBo.getEncrypData());
            if ("1".equals(this.sendPostWay)) {
                JSONObject paramJson = new JSONObject();
                for (Map.Entry entry : postParams.entrySet()) {
                    paramJson.put((String)entry.getKey(), entry.getValue());
                }
                log.info("\u53d1\u9001\u65b9\u5f0f\u4e3a(json)\uff1a" + this.sendPostWay + "\u53d1\u9001\u53c2\u6570\uff1a" + paramJson.toJSONString());
                resultData = HttpUtil.sendPost((String)notifyUrl, (String)paramJson.toJSONString());
            } else {
                log.info("\u53d1\u9001\u65b9\u5f0f\u4e3a(form-data)\uff1a" + this.sendPostWay);
                resultData = HttpUtil.sendPost((String)notifyUrl, postParams);
            }
            log.info("busiCode = " + busiId + "\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + resultData);
            if (resultData.contains("NOTIFY_RESULT") || resultData.contains("notifyResult")) {
                if (resultData.contains("SUCCESS")) {
                    pOrder.setCustyNotifyCode("0");
                    pOrder.setCustNotifyMsg("SUCCESS");
                } else {
                    pOrder.setCustyNotifyCode("1");
                    pOrder.setCustNotifyMsg("FAIL");
                }
            } else {
                pOrder.setCustyNotifyCode("1");
                pOrder.setCustNotifyMsg("FAIL");
            }
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u901a\u77e5\u5f02\u5e38\uff1a orderId = " + orderIdStr + "\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), (Throwable)e);
            pOrder.setCustyNotifyCode("1");
            pOrder.setCustNotifyMsg(e.getMessage());
        }
        pOrder.setCustNotifyTime(dbDate);
        if (!(!this.payPropertiesVo.isUseMulitpleCallBack() || tempOrder.getCurrentNoticeTime() >= CodeTypeValueConstants.P_ORDER_CURRENT_NOTICE_TIME_MAX || "0".equals(pOrder.getCustyNotifyCode()) && "SUCCESS".equals(pOrder.getCustNotifyMsg()))) {
            PayProBaseRspBo rspBo = this.callBackSender.sendTask(orderIdStr);
            log.info("\u9996\u6b21\u56de\u8c03\u5931\u8d25\uff0c\u591a\u6b21\u56de\u8c03\u673a\u5236\u89e6\u53d1\uff0c\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + JSONObject.toJSONString((Object)rspBo));
        }
        try {
            this.payOrderAtomService.update(pOrder);
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u6d88\u606f\u961f\u5217\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        JSONObject data = JSONObject.parseObject((String)message.getContent());
        if (2 == Integer.parseInt(data.getString("callType"))) {
            log.info("------------------------------------\u6d88\u606f\u5373\u5c06\u8fd4\u56de\u80fd\u529b\u5e73\u53f0---------------------------------------");
            data.remove((Object)"callType");
            this.dealPayNoticeByAbility(data.toJSONString());
        } else if (3 == Integer.parseInt(data.getString("callType"))) {
            log.info("------------------------------------\u6d88\u606f\u5373\u5c06\u8fd4\u56de-http_start------------------------------------");
            data.remove((Object)"callType");
            this.dealPayNoticeByHttp(data.toJSONString());
            log.info("------------------------------------\u6d88\u606f\u5373\u5c06\u8fd4\u56de-http_end------------------------------------");
        } else {
            log.info("\u672a\u914d\u7f6e\u7684\u56de\u8c03\u65b9\u5f0f");
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        log.info("------------------------------------\u6d88\u606f\u5373\u5c06\u8fd4\u56de------------------------------------");
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

