/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.busi.ChinaBankRealPayBusiService;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PayProOrderQueryBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.bo.ChinaBankRealPayBusiReqBo;
import com.tydic.payment.pay.busi.bo.ChinaBankRealPayBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleBusiReqDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.PayAbleManager;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="chinaBankRealPayBusiService")
public class ChinaBankRealPayBusiServiceImpl
implements ChinaBankRealPayBusiService {
    private static final Logger log = LoggerFactory.getLogger(ChinaBankRealPayBusiServiceImpl.class);
    private static final String REAL_PAY_STATUS_SUCCESS = "success";
    @Autowired
    private PayAbleManager payAbleManager;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PayProOrderQueryBusiService payProOrderQueryBusiService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;

    public ChinaBankRealPayBusiRspBo realPay(ChinaBankRealPayBusiReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u4e2d\u884c-\u8ba2\u5355\u652f\u4ed8-\u5b9e\u4ed8busi\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        ChinaBankRealPayBusiRspBo retBo = new ChinaBankRealPayBusiRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("212064");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String outOrderId = reqBo.getOutOrderId();
        PayProOrderQueryBusiReqBo qryOrderQueryBo = new PayProOrderQueryBusiReqBo();
        qryOrderQueryBo.setBusiId(reqBo.getBusiId());
        qryOrderQueryBo.setOutOrderId(outOrderId);
        PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo orderQueryBo = this.payProOrderQueryBusiService.queryOrderQueryByBusiIdAndOutOrderId(qryOrderQueryBo);
        if ("8888".equals(orderQueryBo.getRespCode())) {
            retBo.setRespCode("212064");
            retBo.setRespDesc("\u5916\u90e8\u8ba2\u5355\u53f7\uff08" + outOrderId + "\uff09\u5b9e\u4ed8\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u8be5\u8ba2\u5355");
            return retBo;
        }
        Long orderId = orderQueryBo.getOrderId();
        PayOrderRspBo payOrderRspBo = this.payOrderBusiService.selectOrderByOrderId(orderId);
        if ("A10".equals(payOrderRspBo.getOrderStatus())) {
            retBo.setRespCode("212064");
            retBo.setRespDesc("\u5916\u90e8\u8ba2\u5355\u53f7\uff08" + outOrderId + "\uff09\u5df2\u7ecf\u5b9e\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u5b9e\u4ed8");
            return retBo;
        }
        if ("A20".equals(payOrderRspBo.getOrderStatus())) {
            retBo.setRespCode("212064");
            retBo.setRespDesc("\u5916\u90e8\u8ba2\u5355\u53f7\uff08" + outOrderId + "\uff09\u5df2\u7ecf\u5931\u6548\u8fc7\u671f\u4e86");
            return retBo;
        }
        PorderPayTransPo porderPayTransPo = new PorderPayTransPo();
        porderPayTransPo.setOrderId(orderId);
        List<PorderPayTransPo> pOrderTrans = this.porderPayTransAtomService.queryOrderPayTrans(porderPayTransPo);
        if (CollectionUtils.isEmpty(pOrderTrans)) {
            retBo.setRespCode("212064");
            retBo.setRespDesc("\u5916\u90e8\u8ba2\u5355\u53f7\uff08" + outOrderId + "\uff09\u5b9e\u4ed8\u5931\u8d25\u4e86\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u652f\u4ed8\u6570\u636e");
            return retBo;
        }
        String payOrderId = pOrderTrans.get(pOrderTrans.size() - 1).getPayOrderId();
        Long amount = MoneyUtils.haoToFen((Long)payOrderRspBo.getTotalFee()).longValue();
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        Long merchantId = payOrderRspBo.getMerchantId();
        PayProQueryPayParaBusiReqBo qryParaBo = new PayProQueryPayParaBusiReqBo();
        qryParaBo.setMerchantId(merchantId);
        qryParaBo.setPayMethod(reqBo.getPayMethod());
        PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryParaBo);
        if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
            retBo.setRespCode("212064");
            retBo.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u9519\u8bef\uff1a" + payProQueryPayParaBusiRspBo.getRespDesc());
            return retBo;
        }
        Map detailAttrs = payProQueryPayParaBusiRspBo.getDetailAttrs();
        PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(reqBo.getPayMethod());
        PayAbleDealPayReqBo payAbleDealPayReqBo = new PayAbleDealPayReqBo();
        payAbleDealPayReqBo.setPayOrderId(payOrderId);
        payAbleDealPayReqBo.setPayFee(amount);
        PayAbleBusiReqDataBo busiReqData = new PayAbleBusiReqDataBo();
        busiReqData.setTraceNo(new DateTime((Object)dbDate).toString("HHmmss") + payOrderId.substring(7));
        payAbleDealPayReqBo.setBusiReqData(JSON.toJSONString((Object)busiReqData));
        payAbleDealPayReqBo.setParaMap(detailAttrs);
        PayAbleDealPayRspBo payAbleDealPayRspBo = payAble.dealPay(payAbleDealPayReqBo);
        if (!"0000".equals(payAbleDealPayRspBo.getRespCode())) {
            retBo.setRespCode("212064");
            retBo.setRespDesc(payAbleDealPayRspBo.getRespDesc());
            return retBo;
        }
        BeanUtils.copyProperties((Object)payAbleDealPayRspBo, (Object)retBo);
        retBo.setOrderId(String.valueOf(orderId));
        retBo.setOutOrderId(outOrderId);
        retBo.setPayOrderId(payOrderId);
        retBo.setMerchantId(String.valueOf(merchantId));
        retBo.setPayFee(String.valueOf(amount));
        retBo.setTradeTime(payAbleDealPayRspBo.getTradeTime());
        retBo.setTranSeq(payAbleDealPayRspBo.getPayNotifyTransId());
        retBo.setPayResultCode(payAbleDealPayRspBo.getPayResultCode());
        retBo.setPayResultMsg(payAbleDealPayRspBo.getPayResultMsg());
        if (!REAL_PAY_STATUS_SUCCESS.equals(payAbleDealPayRspBo.getPayResultCode())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc(payAbleDealPayRspBo.getRespDesc());
            return retBo;
        }
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderId);
        if (orderInfo == null) {
            log.info("\u5b9e\u4ed8\u6210\u529f\u6839\u636e\u3010orderId={}\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e", (Object)orderId);
            retBo.setRespCode("214030");
            retBo.setRespDesc("\u5b9e\u4ed8\u6210\u529f\u6839\u636e\u3010orderId=" + orderId + "\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e");
            return retBo;
        }
        orderInfo.setTradeTime(payAbleDealPayRspBo.getTradeTime());
        orderInfo.setOrderStatus("A10");
        orderInfo.setUpdateTime(dbDate);
        orderInfo.setOrderAttrValue1(payAbleDealPayRspBo.getPayNotifyTransId());
        int updateOrderCount = this.porderMapper.update(orderInfo);
        if (updateOrderCount < 1) {
            throw new BusinessException("216028", "\u5b9e\u4ed8\u6210\u529f\u5904\u7406busi\u670d\u52a1\u5f02\u5e38\uff0c\u66f4\u65b0p_order\u8fd4\u56de\u6570\u636e\u5c0f\u4e8e1");
        }
        PorderPayTransPo updateTransPo = new PorderPayTransPo();
        updateTransPo.setOrderId(orderId);
        updateTransPo.setPayOrderId(payOrderId);
        updateTransPo.setOrderStatus("A10");
        updateTransPo.setTradeTime(payAbleDealPayRspBo.getTradeTime());
        updateTransPo.setPayNotifyTransId(payAbleDealPayRspBo.getPayNotifyTransId());
        updateTransPo.setUpdateTime(dbDate);
        int updateTransCount = this.porderPayTransMapper.update(updateTransPo);
        if (updateTransCount < 1) {
            throw new BusinessException("216028", "\u5b9e\u4ed8\u6210\u529f\u5904\u7406busi\u670d\u52a1\u5f02\u5e38\uff0c\u66f4\u65b0p_order_pay_trans\u8fd4\u56de\u6570\u636e\u5c0f\u4e8e1");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u5b9e\u4ed8\u6210\u529f");
        return retBo;
    }

    private String validateArg(ChinaBankRealPayBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payMethod\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027outOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

