/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.bo.PayOrderReqBo;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.busi.PayOrderBusiService"})
public class PayOrderBusiServiceImpl
implements PayOrderBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayOrderAtomService payOrderAtomService;

    @PostMapping(value={"update"})
    public PayOrderRspBo update(@RequestBody PayOrderReqBo payOrderReqBo) {
        PayOrderRspBo payOrderRspBo = new PayOrderRspBo();
        try {
            PorderPo orderOld = new PorderPo();
            BeanUtils.copyProperties((Object)payOrderReqBo, (Object)orderOld);
            int count = this.payOrderAtomService.update(orderOld);
            if (count == 0) {
                System.out.println("\u66f4\u65b0\u6570\u636e\u5f02\u5e38");
            }
            payOrderRspBo.setRspCode("0000");
            payOrderRspBo.setRspName("\u6210\u529f");
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            payOrderRspBo.setRspCode("8888");
            payOrderRspBo.setRspName(e.getMessage());
        }
        return payOrderRspBo;
    }

    @PostMapping(value={"selectOrderByOrderId"})
    public PayOrderRspBo selectOrderByOrderId(@RequestBody Long orderId) {
        PayOrderRspBo payOrderRspBo = new PayOrderRspBo();
        PorderPo porderPo = this.payOrderAtomService.queryPorderInfo(orderId);
        if (porderPo == null) {
            payOrderRspBo.setRspCode("8888");
            payOrderRspBo.setRspName("\u672a\u67e5\u8be2\u5230\u8ba2\u5355orderId =" + orderId);
            return payOrderRspBo;
        }
        BeanUtils.copyProperties((Object)porderPo, (Object)payOrderRspBo);
        payOrderRspBo.setRspCode("0000");
        payOrderRspBo.setRspName("\u6210\u529f");
        return payOrderRspBo;
    }

    @PostMapping(value={"dealDelay"})
    public PayOrderRspBo dealDelay(@RequestBody Long orderId) {
        PayOrderRspBo rsp = new PayOrderRspBo();
        rsp.setRspCode("0000");
        rsp.setRspName("\u6210\u529f");
        return rsp;
    }

    @PostMapping(value={"selectOrder"})
    public List<PayOrderRspBo> selectOrder(@RequestBody Map<String, Object> paramMap) {
        ArrayList<PayOrderRspBo> rsp = new ArrayList<PayOrderRspBo>();
        List<PorderPo> orderList = this.payOrderAtomService.selectPorder(paramMap);
        BeanUtils.copyProperties(orderList, rsp);
        return rsp;
    }
}

