/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import cn.hutool.core.collection.CollUtil;
import com.tydic.payment.pay.busi.PayProCreateOrderBusiService;
import com.tydic.payment.pay.busi.PayProMerchantBusiService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProMerchantBusiQryByIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.busi.bo.PorderDetallPo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.dao.POrderRelPayMethodMapper;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.po.POrderRelPayMethodPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PayProCreateOrderBusiServiceImpl
implements PayProCreateOrderBusiService {
    @Value(value="${pay.order.exptime:30}")
    private Integer expTime;
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService payProQueryInfoBusiSystemByConditionService;
    @Autowired
    private PayProMerchantBusiService payProMerchantBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private POrderRelPayMethodMapper pOrderRelPayMethodMapper;
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";

    public PayProCreateOrderBusiRspBo createOrder(PayProCreateOrderBusiReqBo reqBo) {
        PorderPo pOrderPo;
        PayProCreateOrderBusiRspBo retBo;
        block16: {
            String validateGoodDetailsFeeStr;
            retBo = new PayProCreateOrderBusiRspBo();
            String validateArgStr = this.validateArg(reqBo);
            if (!StringUtils.isEmpty((Object)validateArgStr)) {
                retBo.setRespCode("212002");
                retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
                return retBo;
            }
            pOrderPo = new PorderPo();
            Date dbDate = this.queryDBDateBusiService.getDBDate();
            List goodDetails = reqBo.getGoodDetails();
            if (goodDetails != null && !goodDetails.isEmpty() && !StringUtils.isEmpty((Object)(validateGoodDetailsFeeStr = this.validateGoodDetailsFee(goodDetails, reqBo.getTotalFee())))) {
                retBo.setRespCode("212002");
                retBo.setRespDesc(validateGoodDetailsFeeStr);
                return retBo;
            }
            this.convertFee(reqBo);
            BeanUtils.copyProperties((Object)reqBo, (Object)pOrderPo);
            String orderType = reqBo.getOrderType().trim();
            Long merchantId = reqBo.getMerchantId();
            String orderStatus2 = null;
            String busiCode = null;
            if ("01".equals(orderType) || "07".equals(orderType)) {
                orderStatus2 = "A00";
            } else if ("02".equals(orderType) || "06".equals(orderType)) {
                orderStatus2 = "B00";
            }
            pOrderPo.setOrderStatus(orderStatus2);
            PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiRspBo = this.payProQueryInfoBusiSystemByConditionService.queryBusiSysByBusiId(reqBo.getBusiId());
            if (!"0000".equals(busiRspBo.getRespCode())) {
                retBo.setRespCode("212002");
                retBo.setRespDesc("\u4e0b\u5355\u9519\u8bef\uff1a" + busiRspBo.getRespDesc());
                return retBo;
            }
            busiCode = busiRspBo.getBusiCode();
            pOrderPo.setBusiCode(busiCode);
            PayProMerchantBusiQryByIdBusiRspBo payProMerchantBusiQryByIdBusiRspBo = this.payProMerchantBusiService.queryMerchantByMerchantId(merchantId);
            if (!"0000".equals(payProMerchantBusiQryByIdBusiRspBo.getRespCode())) {
                retBo.setRespCode("212002");
                retBo.setRespDesc("\u67e5\u8be2\u5546\u6237\u4fe1\u606f\u5931\u8d25" + payProMerchantBusiQryByIdBusiRspBo.getRespDesc());
                return retBo;
            }
            pOrderPo.setMerchantName(payProMerchantBusiQryByIdBusiRspBo.getMerchantName());
            pOrderPo.setMerchantNameAbb(payProMerchantBusiQryByIdBusiRspBo.getMerchantNameAbb());
            pOrderPo.setCreateTime(dbDate);
            if (reqBo.getRefundFee() == null) {
                pOrderPo.setRefundFee(0L);
            } else {
                pOrderPo.setRefundFee(MoneyUtils.fenToHao((Long)reqBo.getRefundFee()).longValue());
            }
            long orderId = PayProSequence.nextId();
            pOrderPo.setOrderId(orderId);
            pOrderPo.setRealFee(pOrderPo.getTotalFee());
            pOrderPo.setExpTime(new DateTime((Object)dbDate).plusMinutes(this.expTime.intValue()).toDate());
            try {
                Long count = this.porderMapper.insertPorder(pOrderPo);
                if (count != 1L) {
                    retBo.setRespCode("212002");
                    retBo.setRespDesc("\u8ba2\u5355\u521b\u5efa\u5931\u8d25\uff1a\u63d2\u5165\u8fd4\u56de\u503c\u4e0d\u4e3a1");
                    return retBo;
                }
                List orderPayMethods = reqBo.getOrderPayMethods();
                if (!CollUtil.isEmpty((Collection)orderPayMethods)) {
                    for (Long orderPayMethod : orderPayMethods) {
                        POrderRelPayMethodPo insertPo = new POrderRelPayMethodPo();
                        insertPo.setRelId(PayProSequence.nextId());
                        insertPo.setOrderId(orderId);
                        insertPo.setPayMethod(orderPayMethod);
                        insertPo.setOutOrderId(reqBo.getOutOrderId());
                        this.pOrderRelPayMethodMapper.insert(insertPo);
                    }
                }
                if (goodDetails == null || goodDetails.isEmpty()) break block16;
                try {
                    this.goodsInsert(goodDetails, pOrderPo.getOrderId());
                }
                catch (Exception e) {
                    throw new BusinessException("216001", "\u63d2\u5165\u5546\u54c1\u4fe1\u606f\u8868\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new BusinessException("216001", "\u8ba2\u5355\u521b\u5efa\u5f02\u5e38(mapper\u6267\u884c\u5931\u8d25)\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        retBo.setOrderId(pOrderPo.getOrderId() + "");
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u4e0b\u5355\u6210\u529f");
        return retBo;
    }

    private void goodsInsert(List<PorderDetallPo> goodDetails, Long orderId) {
    }

    private String validateGoodDetailsFee(List<PorderDetallPo> goodDetails, Long totalFee) {
        long inputTotalFee = totalFee;
        long goodsFee = 0L;
        for (PorderDetallPo po : goodDetails) {
            long googsTotalFee = po.getGoodsFee();
            BigDecimal goodNum = new BigDecimal(po.getGoodsNum());
            BigDecimal goodPrice = new BigDecimal(po.getGoodsPrice());
            long validateFee = goodPrice.multiply(goodNum).longValue();
            if (googsTotalFee != validateFee) {
                return "\u4f20\u5165\u7684\u5546\u54c1\u4fe1\u606f\u91d1\u989d\u4e0d\u5bf9(\u91d1\u989d * \u6570\u91cf != \u603b\u989d)";
            }
            goodsFee += validateFee;
        }
        if (inputTotalFee != goodsFee) {
            return "\u5546\u54c1\u52a0\u8d77\u6765\u7684\u603b\u4ef7\u683c\u4e0d\u7b49\u4e8e\u4f20\u5165\u7684totalFee";
        }
        return null;
    }

    private String validateArg(PayProCreateOrderBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String orderType = reqBo.getOrderType();
        if (StringUtils.isEmpty((Object)orderType)) {
            return "orderType\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "\u5f53\u4e3a\u652f\u4ed8\u5355\u65f6\uff1aoutOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("01".equals(orderType = orderType.trim()) || "07".equals(orderType)) {
            reqBo.setOutRefundNo(null);
        } else if ("02".equals(orderType) || "06".equals(orderType)) {
            if (StringUtils.isEmpty((Object)reqBo.getOutRefundNo())) {
                return "\u5f53\u4e3a\u9000\u6b3e\u65f6\uff1aoutRefundNo\u4e0d\u80fd\u4e3a\u7a7a";
            }
        } else {
            return "orderType\u53ea\u80fd\u4e3a{01(\u652f\u4ed8),02(\u6574\u5355\u9000\u6b3e),06(\u90e8\u5206\u9000\u6b3e)}\u4e2d\u7684\u4e00\u4e2a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "busiId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "totalFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "detailName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!(StringUtils.isEmpty((Object)reqBo.getRedirectUrl()) || reqBo.getRedirectUrl().trim().startsWith(HTTP_PREFIX) || reqBo.getRedirectUrl().trim().startsWith(HTTPS_PREFIX))) {
            return "redirectUrl\u5fc5\u987b\u4ee5'http://'\u6216\u8005'https://'\u5f00\u5934";
        }
        if (!(StringUtils.isEmpty((Object)reqBo.getNotifyUrl()) || reqBo.getNotifyUrl().trim().startsWith(HTTP_PREFIX) || reqBo.getNotifyUrl().trim().startsWith(HTTPS_PREFIX))) {
            return "notifyUrl\u5fc5\u987b\u4ee5'http://'\u6216\u8005'https://'\u5f00\u5934";
        }
        List goodDetails = reqBo.getGoodDetails();
        if (goodDetails != null && !goodDetails.isEmpty()) {
            for (PorderDetallPo good : goodDetails) {
                if (good == null) {
                    return "\u5546\u54c1\u5355\u4e2a\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (StringUtils.isEmpty((Object)good.getBusiId())) {
                    good.setBusiId(reqBo.getBusiId());
                }
                if (StringUtils.isEmpty((Object)good.getGoodsId())) {
                    return "goodsId\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (StringUtils.isEmpty((Object)good.getGoodsName())) {
                    return "goodsName\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (StringUtils.isEmpty((Object)good.getGoodsFee())) {
                    return "goodsFee\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (StringUtils.isEmpty((Object)good.getGoodsNum())) {
                    return "goodsNum\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (!StringUtils.isEmpty((Object)good.getGoodsPrice())) continue;
                return "goodsPrice\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        return null;
    }

    private void convertFee(PayProCreateOrderBusiReqBo reqBo) {
        reqBo.setTotalFee(Long.valueOf(MoneyUtils.fenToHao((Long)reqBo.getTotalFee()).longValue()));
        if (reqBo.getBalanceFee() != null) {
            reqBo.setBalanceFee(Long.valueOf(MoneyUtils.fenToHao((Long)reqBo.getBalanceFee()).longValue()));
        }
        if (reqBo.getDiscountFee() != null) {
            reqBo.setDiscountFee(Long.valueOf(MoneyUtils.fenToHao((Long)reqBo.getDiscountFee()).longValue()));
        } else {
            reqBo.setDiscountFee(Long.valueOf(0L));
        }
        if (reqBo.getOnlineFee() != null) {
            reqBo.setOnlineFee(Long.valueOf(MoneyUtils.fenToHao((Long)reqBo.getOnlineFee()).longValue()));
        }
    }
}

