/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.AliAppPayBusiService;
import com.tydic.payment.pay.busi.AliH5PayBusiService;
import com.tydic.payment.pay.busi.AliHbfqPayBusiService;
import com.tydic.payment.pay.busi.AliQrCodePayBusiService;
import com.tydic.payment.pay.busi.AliScanPayBusiService;
import com.tydic.payment.pay.busi.AliWebPayBusiService;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.CashPayBusiService;
import com.tydic.payment.pay.busi.GdBank4PayBusiService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.UnionAcpPayBusiService;
import com.tydic.payment.pay.busi.UnionQrCodePayBusiService;
import com.tydic.payment.pay.busi.UnionWapPayBusiService;
import com.tydic.payment.pay.busi.WXAppPayBusiService;
import com.tydic.payment.pay.busi.WXH5PayBusiService;
import com.tydic.payment.pay.busi.WXMicroPayBusiService;
import com.tydic.payment.pay.busi.WXQrCodePayBusiService;
import com.tydic.payment.pay.busi.bo.AliAppPayReqBo;
import com.tydic.payment.pay.busi.bo.AliAppPayRspBo;
import com.tydic.payment.pay.busi.bo.AliH5PayBusiReqBO;
import com.tydic.payment.pay.busi.bo.AliH5PayBusiRspBO;
import com.tydic.payment.pay.busi.bo.AliHbfqPayBusiReqBo;
import com.tydic.payment.pay.busi.bo.AliHbfqPayBusiRspBo;
import com.tydic.payment.pay.busi.bo.AliQrCodePayReqBO;
import com.tydic.payment.pay.busi.bo.AliScanPayReqBO;
import com.tydic.payment.pay.busi.bo.AliScanPayRspBO;
import com.tydic.payment.pay.busi.bo.AliWebPayReqBo;
import com.tydic.payment.pay.busi.bo.AliWebPayRspBo;
import com.tydic.payment.pay.busi.bo.AlipayQrCodeRspBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.CashPayBusiReqBo;
import com.tydic.payment.pay.busi.bo.CashPayBusiRspBo;
import com.tydic.payment.pay.busi.bo.PaymentGdBankReqBo;
import com.tydic.payment.pay.busi.bo.PaymentGdBankRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.bo.UnionAcpPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionAcpPayBusiRspBO;
import com.tydic.payment.pay.busi.bo.UnionQrCodePayBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionQrCodePayBusiRspBO;
import com.tydic.payment.pay.busi.bo.UnionWapPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionWapPayBusiRspBO;
import com.tydic.payment.pay.busi.bo.WXAppPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXAppPayBusiRspBO;
import com.tydic.payment.pay.busi.bo.WXH5PayBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXH5PayBusiRspBO;
import com.tydic.payment.pay.busi.bo.WXMicroPayBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXMicroPayBusiRspBO;
import com.tydic.payment.pay.busi.bo.WXQrCodePayBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXQrCodePayBusiRspBO;
import com.tydic.payment.pay.comb.UniPayCombService;
import com.tydic.payment.pay.comb.bo.UniPayCombReqBO;
import com.tydic.payment.pay.comb.bo.UniPayCombRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.comb.UniPayCombService"})
public class UniPayCombServiceImpl
implements UniPayCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniPayCombServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private WXQrCodePayBusiService wXQrCodePayBusiService;
    @Autowired
    private WXMicroPayBusiService wXMicroPayBusiService;
    @Autowired
    private CashPayBusiService cashPayBusiService;
    @Autowired
    private AliQrCodePayBusiService aliQrCodePayBusiService;
    @Autowired
    private AliScanPayBusiService aliScanPayBusiService;
    @Autowired
    private AliWebPayBusiService aliWebPayBusiService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private WXH5PayBusiService wXH5PayBusiService;
    @Autowired
    private AliH5PayBusiService aliH5PayBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private WXAppPayBusiService wXAppPayBusiService;
    @Autowired
    private AliAppPayBusiService aliAppPayBusiService;
    @Autowired
    private UnionAcpPayBusiService unionAcpPayBusiService;
    @Autowired
    private GdBank4PayBusiService gdBank4PayBusiService;
    @Autowired
    private AliHbfqPayBusiService aliHbfqPayBusiService;
    @Autowired
    private UnionQrCodePayBusiService unionQrCodePayBusiService;
    @Autowired
    private UnionWapPayBusiService unionWapPayBusiService;

    @PostMapping(value={"dealUniPay"})
    public UniPayCombRspBO dealUniPay(@RequestBody UniPayCombReqBO req) throws Exception {
        LOGGER.info("\u7edf\u4e00\u7ec4\u5408\u652f\u4ed8\u5165\u53c2\u4e3a\uff1a" + req);
        UniPayCombRspBO rsp = new UniPayCombRspBO();
        this.checkInputParas(req);
        try {
            HashMap<String, String> params;
            PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(req.getOrderId()));
            if (orderInfo == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
            }
            req.setRealFee(MoneyUtils.haoToFen((Long)orderInfo.getTotalFee()).toString());
            if ("A10".equals(orderInfo.getOrderStatus())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u8be5\u8ba2\u5355\u3010" + req.getOrderId() + "\u3011\u5df2\u7ecf\u652f\u4ed8\u8fc7");
                return rsp;
            }
            if ("B10".equals(orderInfo.getOrderStatus())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u8be5\u8ba2\u5355\u3010" + req.getOrderId() + "\u3011\u5df2\u7ecf\u9000\u6b3e\uff0c\u8bf7\u4e0d\u8981\u518d\u652f\u4ed8\uff01");
                return rsp;
            }
            if ("B20".equals(orderInfo.getOrderStatus())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u8be5\u8ba2\u5355\u3010" + req.getOrderId() + "\u3011\u5df2\u7ecf\u652f\u4ed8\u8fc7\uff0c\u5e76\u5c1d\u8bd5\u8fc7\u9000\u6b3e\u4f46\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u518d\u652f\u4ed8\uff01");
                return rsp;
            }
            if (!this.checkExpTime(orderInfo.getExpTime())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u8ba2\u5355\u3010" + req.getOrderId() + "\u3011\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355\uff01");
                return rsp;
            }
            Long merchant_id = orderInfo.getMerchantId();
            if (StringUtils.isEmpty((Object)merchant_id)) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\u4e2d\u65e0\u5546\u6237\u53f7\uff01");
            }
            if (!StringUtils.isEmpty((Object)req.getAuthCode()) && StringUtils.isEmpty((Object)req.getPayMethod())) {
                String beginTwo = req.getAuthCode().substring(0, 2);
                String aliRegular = "^(2[5-9]|30)$";
                Pattern aliHumpPattern = Pattern.compile(aliRegular);
                Matcher aliMatcher = aliHumpPattern.matcher(beginTwo);
                String wxRegular = "^(1[0-5])$";
                Pattern wxHumpPattern = Pattern.compile(wxRegular);
                Matcher wxMatcher = wxHumpPattern.matcher(beginTwo);
                if (aliMatcher.find()) {
                    req.setPayMethod("20");
                } else if (wxMatcher.find()) {
                    req.setPayMethod("10");
                }
            }
            if ("30".equals(req.getPayMethod())) {
                CashPayBusiReqBo cashPayBusiReq = new CashPayBusiReqBo();
                cashPayBusiReq.setOrderId(req.getOrderId());
                cashPayBusiReq.setMerchantId(String.valueOf(merchant_id));
                cashPayBusiReq.setTotalFee(new BigDecimal(req.getRealFee()));
                CashPayBusiRspBo cashPayBusiRsp = this.cashPayBusiService.dealCashPay(cashPayBusiReq);
                BeanUtils.copyProperties((Object)cashPayBusiRsp, (Object)rsp);
                if ("0000".equals(rsp.getRspCode()) && "SUCCESS".equals(rsp.getPayStatus())) {
                    CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
                    callBackNoticeReqBo.setOrderId(Long.valueOf(Long.parseLong(req.getOrderId())));
                    CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
                    if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                        LOGGER.info(req.getOrderId() + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
                    }
                }
                return rsp;
            }
            QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
            paraReq.setMerchantId(String.valueOf(merchant_id));
            paraReq.setPayMethod(req.getPayMethod());
            QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
            if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
            }
            if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
            }
            Map<String, Object> paramMap = this.getParamMap(paraInfo);
            if ("10".equals(req.getPayMethod())) {
                WXMicroPayBusiReqBO wXMicroPayBusiReq = new WXMicroPayBusiReqBO();
                wXMicroPayBusiReq.setOrderId(req.getOrderId());
                wXMicroPayBusiReq.setMerchantId(String.valueOf(merchant_id));
                wXMicroPayBusiReq.setTotalFee(new BigDecimal(req.getRealFee()));
                wXMicroPayBusiReq.setParamMap(paramMap);
                wXMicroPayBusiReq.setAuthCode(req.getAuthCode());
                WXMicroPayBusiRspBO wXMicroPayBusiRsp = this.wXMicroPayBusiService.dealWXMicroPay(wXMicroPayBusiReq);
                BeanUtils.copyProperties((Object)wXMicroPayBusiRsp, (Object)rsp);
            } else if ("11".equals(req.getPayMethod())) {
                WXQrCodePayBusiReqBO wXQrCodePayBusiReq = new WXQrCodePayBusiReqBO();
                wXQrCodePayBusiReq.setOrderId(req.getOrderId());
                wXQrCodePayBusiReq.setMerchantId(String.valueOf(merchant_id));
                wXQrCodePayBusiReq.setTotalFee(new BigDecimal(req.getRealFee()));
                wXQrCodePayBusiReq.setParamMap(paramMap);
                WXQrCodePayBusiRspBO wXQrCodePayBusiRsp = this.wXQrCodePayBusiService.dealWxQrCodePay(wXQrCodePayBusiReq);
                BeanUtils.copyProperties((Object)wXQrCodePayBusiRsp, (Object)rsp);
            } else if ("20".equals(req.getPayMethod())) {
                AliScanPayReqBO aliScanPayReqBO = new AliScanPayReqBO();
                aliScanPayReqBO.setOrderId(req.getOrderId());
                aliScanPayReqBO.setMerchantId(String.valueOf(merchant_id));
                aliScanPayReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                aliScanPayReqBO.setParamMap(paramMap);
                aliScanPayReqBO.setAuthCode(req.getAuthCode());
                AliScanPayRspBO aliScanPayRspBO = this.aliScanPayBusiService.dealAliScanPay(aliScanPayReqBO);
                BeanUtils.copyProperties((Object)aliScanPayRspBO, (Object)rsp);
            } else if ("21".equals(req.getPayMethod())) {
                AliQrCodePayReqBO aliQrCodePayReqBO = new AliQrCodePayReqBO();
                aliQrCodePayReqBO.setMerchantId(String.valueOf(merchant_id));
                aliQrCodePayReqBO.setOrderId(req.getOrderId());
                aliQrCodePayReqBO.setParamMap(paramMap);
                aliQrCodePayReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                AlipayQrCodeRspBo alipayQrCodeRsp = this.aliQrCodePayBusiService.dealAliQrCodePay(aliQrCodePayReqBO);
                BeanUtils.copyProperties((Object)alipayQrCodeRsp, (Object)rsp);
            } else if ("24".equals(req.getPayMethod())) {
                AliWebPayReqBo aliWebPayReqBo = new AliWebPayReqBo();
                aliWebPayReqBo.setMerchantId(merchant_id);
                aliWebPayReqBo.setOrderId(Long.valueOf(Long.parseLong(req.getOrderId())));
                aliWebPayReqBo.setParamMap(paramMap);
                aliWebPayReqBo.setTotalFee(new BigDecimal(req.getRealFee()));
                AliWebPayRspBo aliWebPayRspBo = this.aliWebPayBusiService.dealAliWebPay(aliWebPayReqBo);
                BeanUtils.copyProperties((Object)aliWebPayRspBo, (Object)rsp);
            } else if ("13".equals(req.getPayMethod())) {
                WXH5PayBusiReqBO wXH5PayBusiReqBO = new WXH5PayBusiReqBO();
                wXH5PayBusiReqBO.setOrderId(req.getOrderId());
                wXH5PayBusiReqBO.setMerchantId(String.valueOf(merchant_id));
                wXH5PayBusiReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                wXH5PayBusiReqBO.setParamMap(paramMap);
                WXH5PayBusiRspBO wXH5PayBusiRspBO = this.wXH5PayBusiService.dealWxH5Pay(wXH5PayBusiReqBO);
                BeanUtils.copyProperties((Object)wXH5PayBusiRspBO, (Object)rsp);
            } else if ("23".equals(req.getPayMethod())) {
                AliH5PayBusiReqBO aliH5PayBusiReq = new AliH5PayBusiReqBO();
                aliH5PayBusiReq.setOrderId(req.getOrderId());
                aliH5PayBusiReq.setMerchantId(String.valueOf(merchant_id));
                aliH5PayBusiReq.setTotalFee(new BigDecimal(req.getRealFee()));
                aliH5PayBusiReq.setParamMap(paramMap);
                AliH5PayBusiRspBO aliH5PayBusiRsp = this.aliH5PayBusiService.dealAliH5Pay(aliH5PayBusiReq);
                BeanUtils.copyProperties((Object)aliH5PayBusiRsp, (Object)rsp);
            } else if ("110".equals(req.getPayMethod())) {
                UnionAcpPayBusiReqBO unionAcpPayBusiReqBO = new UnionAcpPayBusiReqBO();
                unionAcpPayBusiReqBO.setMerchantId(req.getOrderId());
                unionAcpPayBusiReqBO.setOrderId(req.getOrderId());
                unionAcpPayBusiReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                unionAcpPayBusiReqBO.setParamMap(paramMap);
                UnionAcpPayBusiRspBO unionAcpPayBusiRspBO = this.unionAcpPayBusiService.dealUnionAcpPay(unionAcpPayBusiReqBO);
                BeanUtils.copyProperties((Object)unionAcpPayBusiRspBO, (Object)rsp);
            } else if ("22".equals(req.getPayMethod())) {
                AliAppPayReqBo aliAppPayReqBo = new AliAppPayReqBo();
                aliAppPayReqBo.setMerchantId(String.valueOf(merchant_id));
                aliAppPayReqBo.setOrderId(req.getOrderId());
                aliAppPayReqBo.setTotalFee(new BigDecimal(req.getRealFee()));
                aliAppPayReqBo.setParamMap(paramMap);
                AliAppPayRspBo aliAppPayRspBo = this.aliAppPayBusiService.dealPay(aliAppPayReqBo);
                BeanUtils.copyProperties((Object)aliAppPayRspBo, (Object)rsp);
                if ("0000".equals(aliAppPayRspBo.getRspCode()) && "SUCCESS".equals(aliAppPayRspBo.getPayStatus())) {
                    params = new HashMap<String, String>();
                    params.put("body", aliAppPayRspBo.getBody());
                    params.put("redirectUrl", aliAppPayRspBo.getRedirectUrl());
                    rsp.setParams(params);
                }
            } else if ("12".equals(req.getPayMethod())) {
                WXAppPayBusiReqBO wXAppPayBusiReqBO = new WXAppPayBusiReqBO();
                wXAppPayBusiReqBO.setMerchantId(String.valueOf(merchant_id));
                wXAppPayBusiReqBO.setOrderId(req.getOrderId());
                wXAppPayBusiReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                wXAppPayBusiReqBO.setParamMap(paramMap);
                WXAppPayBusiRspBO wXAppPayBusiRspBO = this.wXAppPayBusiService.dealWXAppPay(wXAppPayBusiReqBO);
                BeanUtils.copyProperties((Object)wXAppPayBusiRspBO, (Object)rsp);
                if ("0000".equals(wXAppPayBusiRspBO.getRspCode()) && "SUCCESS".equals(wXAppPayBusiRspBO.getPayStatus())) {
                    params = new HashMap();
                    params.put("appId", wXAppPayBusiRspBO.getAppId());
                    params.put("nonceStr", wXAppPayBusiRspBO.getNonceStr());
                    params.put("package_", wXAppPayBusiRspBO.getPacKage());
                    params.put("partnerId", wXAppPayBusiRspBO.getPartnerId());
                    params.put("prepayId", wXAppPayBusiRspBO.getPrepayId());
                    params.put("sign", wXAppPayBusiRspBO.getSign());
                    params.put("timeStamp", wXAppPayBusiRspBO.getTimeStamp());
                    params.put("redirectUrl", wXAppPayBusiRspBO.getRedirectUrl());
                    rsp.setParams(params);
                }
            } else if ("120".equals(req.getPayMethod())) {
                PaymentGdBankReqBo paymentGdBankReqBo = new PaymentGdBankReqBo();
                paymentGdBankReqBo.setMerchantId(merchant_id.toString());
                paymentGdBankReqBo.setOrderId(req.getOrderId());
                paymentGdBankReqBo.setTotalFee(new BigDecimal(req.getRealFee()));
                paymentGdBankReqBo.setParamMap(paramMap);
                PaymentGdBankRspBo paymentGdBankRspBo = this.gdBank4PayBusiService.dealGdBankPay(paymentGdBankReqBo);
                BeanUtils.copyProperties((Object)paymentGdBankRspBo, (Object)rsp);
            } else if ("26".equals(req.getPayMethod())) {
                AliHbfqPayBusiReqBo aliHbfqReqBo = new AliHbfqPayBusiReqBo();
                aliHbfqReqBo.setMerchantId(merchant_id.toString());
                aliHbfqReqBo.setOrderId(req.getOrderId());
                aliHbfqReqBo.setTotalFee(new BigDecimal(req.getRealFee()));
                aliHbfqReqBo.setParamMap(paramMap);
                aliHbfqReqBo.setHbfqNum(req.getHbfqNum());
                aliHbfqReqBo.setHbfqSellerPercent(req.getHbfqSellerPercent());
                AliHbfqPayBusiRspBo aliHbfqRspBo = this.aliHbfqPayBusiService.dealAliHbfq(aliHbfqReqBo);
                BeanUtils.copyProperties((Object)aliHbfqRspBo, (Object)rsp);
            } else if ("112".equals(req.getPayMethod())) {
                UnionQrCodePayBusiReqBO unionQrCodePayBusiReqBO = new UnionQrCodePayBusiReqBO();
                unionQrCodePayBusiReqBO.setMerchantId(req.getOrderId());
                unionQrCodePayBusiReqBO.setOrderId(req.getOrderId());
                unionQrCodePayBusiReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                unionQrCodePayBusiReqBO.setParamMap(paramMap);
                UnionQrCodePayBusiRspBO unionQrCodePayBusiRspBO = this.unionQrCodePayBusiService.dealUnionQrCodePay(unionQrCodePayBusiReqBO);
                BeanUtils.copyProperties((Object)unionQrCodePayBusiRspBO, (Object)rsp);
            } else if ("113".equals(req.getPayMethod())) {
                UnionWapPayBusiReqBO unionWapPayBusiReqBO = new UnionWapPayBusiReqBO();
                unionWapPayBusiReqBO.setMerchantId(req.getOrderId());
                unionWapPayBusiReqBO.setOrderId(req.getOrderId());
                unionWapPayBusiReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                unionWapPayBusiReqBO.setParamMap(paramMap);
                UnionWapPayBusiRspBO unionWapPayBusiRspBO = this.unionWapPayBusiService.dealUnionWapPay(unionWapPayBusiReqBO);
                BeanUtils.copyProperties((Object)unionWapPayBusiRspBO, (Object)rsp);
            }
            if ("0000".equals(rsp.getRspCode()) && "SUCCESS".equals(rsp.getPayStatus()) && ("20".equals(req.getPayMethod()) || "30".equals(req.getPayMethod()) || "10".equals(req.getPayMethod()))) {
                CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
                callBackNoticeReqBo.setOrderId(Long.valueOf(Long.parseLong(req.getOrderId())));
                CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
                if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                    LOGGER.info(req.getOrderId() + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rsp.setRspCode("8888");
            rsp.setRspName("\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }

    private void checkInputParas(UniPayCombReqBO req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getRealFee())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u652f\u4ed8\u91d1\u989d\u3010RealFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayMethod())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u3010payMethod\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("10".equals(req.getPayMethod()) && StringUtils.isEmpty((Object)req.getAuthCode())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u6761\u7801\u4e32\u3010authCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("14".equals(req.getPayMethod()) && StringUtils.isEmpty((Object)req.getOpenid())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u7528\u6237\u6807\u8bc6\u3010openid\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private Map<String, Object> getParamMap(QueryCashierInfoPayParaAttrRspBo paraInfo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }

    private boolean checkExpTime(Date expTime) {
        if (expTime == null) {
            LOGGER.info("\u8ba2\u5355\u8868\u6ca1\u4fdd\u5b58\u8ba2\u5355\u903e\u671f\u65f6\u95f4");
            return false;
        }
        Date nowDate = this.queryDBDateBusiService.getDBDate();
        LOGGER.info("\u5f53\u524d\u6570\u636e\u5e93\u65f6\u95f4\uff1a{}", (Object)new SimpleDateFormat("yyyyMMddHHmmss").format(nowDate));
        return expTime.after(nowDate);
    }
}

