/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayRuleParaAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PayRuleParaPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.PCodePayMethodBoStr;
import com.tydic.payment.pay.web.bo.PayRuleParaBoStr;
import com.tydic.payment.pay.web.bo.PaymentInsBoStr;
import com.tydic.payment.pay.web.bo.req.UpdatePaymentBaseInfoReqBo;
import com.tydic.payment.pay.web.bo.req.UpdatePaymentPayMethodWebReqBo;
import com.tydic.payment.pay.web.bo.req.UpdatePaymentPayRuleParaWebReqBo;
import com.tydic.payment.pay.web.service.UpdatePaymentInsForPaycenterWebService;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.web.service.UpdatePaymentInsForPaycenterWebService"})
public class UpdatePaymentInsForPaycenterWebServiceImpl
implements UpdatePaymentInsForPaycenterWebService {
    private static final Logger log = LoggerFactory.getLogger(UpdatePaymentInsForPaycenterWebServiceImpl.class);
    private static String SERVICE = "UpdatePaymentInsForPaycenterWebService";
    private static String SERVICE_NAME = "\u652f\u4ed8\u4e2d\u5fc3\u81ea\u7528\u66f4\u65b0\u652f\u4ed8\u673a\u6784\u4e1a\u52a1\u670d\u52a1";
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayRuleParaAtomService payRuleParaAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    QueryPCodeInfoService queryPCodeInfoService;

    @PostMapping(value={"updatePaymentInsBaseInfo"})
    public PaymentInsBoStr updatePaymentInsBaseInfo(@RequestBody UpdatePaymentBaseInfoReqBo reqBo) {
        log.info(SERVICE_NAME + "\u5165\u53c2  -> " + JSON.toJSONString((Object)reqBo));
        PaymentInsBoStr rspBo = new PaymentInsBoStr();
        this.validateArg(reqBo);
        PaymentInsPo qryPayPo = new PaymentInsPo();
        qryPayPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        List<PaymentInsPo> paymentL = this.paymentInsAtomService.queryPaymentInf(qryPayPo);
        if (CollectionUtils.isEmpty(paymentL)) {
            log.info(SERVICE_NAME + " ->  \u5931\u8d25\uff1a\u8be5\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff1a\u8be5\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u4e0d\u5b58\u5728");
            return rspBo;
        }
        PaymentInsPo updPayPo = new PaymentInsPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)updPayPo);
        updPayPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        if (StringUtils.isEmpty((Object)reqBo.getOperId())) {
            updPayPo.setUpdateOperId(reqBo.getOperId());
        }
        updPayPo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
        int updPay = this.paymentInsAtomService.updatePaymentInf(updPayPo);
        if (updPay < 1) {
            log.info(SERVICE_NAME + " -> \u5931\u8d25 \uff1a\u66f4\u65b0\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u5931\u8d25");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff1a\u6570\u636e\u5e93\u9519\u8bef");
            return rspBo;
        }
        PaymentInsPo qryPay2 = new PaymentInsPo();
        qryPay2.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        List<PaymentInsPo> qryL = this.paymentInsAtomService.queryPaymentInf(qryPay2);
        if (CollectionUtils.isEmpty(qryL)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff0c\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
            return rspBo;
        }
        PaymentInsPo resultPo = qryL.get(0);
        BeanUtils.copyProperties((Object)resultPo, (Object)rspBo);
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u66f4\u65b0\u6210\u529f");
        rspBo.setPaymentInsId(resultPo.getPaymentInsId().toString());
        rspBo.setCreateTime(resultPo.getCreateTime() == null ? "" : new DateTime((Object)resultPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setUpdateTime(resultPo.getUpdateTime() == null ? "" : new DateTime((Object)resultPo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setRemark(StringUtils.isEmpty((Object)resultPo.getRemark()) ? "" : resultPo.getRemark());
        return rspBo;
    }

    private void validateArg(UpdatePaymentBaseInfoReqBo reqBo) {
        if (reqBo == null) {
            log.info(SERVICE_NAME + "-> " + SERVICE + " - \u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            log.info(SERVICE_NAME + "-> " + SERVICE + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsName())) {
            log.info(SERVICE_NAME + "-> " + SERVICE + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027PaymentInsName\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @PostMapping(value={"updatePaymentPayRulePara"})
    public PayRuleParaBoStr updatePaymentPayRulePara(@RequestBody UpdatePaymentPayRuleParaWebReqBo reqBo) {
        int updParaF;
        log.info(SERVICE_NAME + "\u5165\u53c2  -> " + JSON.toJSONString((Object)reqBo));
        PayRuleParaBoStr rspBo = new PayRuleParaBoStr();
        this.validateArgPayRulePara(reqBo);
        PaymentInsPo qryPayPo = new PaymentInsPo();
        qryPayPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        List<PaymentInsPo> paymentL = this.paymentInsAtomService.queryPaymentInf(qryPayPo);
        if (CollectionUtils.isEmpty(paymentL)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff1a\u8be5\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u4e0d\u5b58\u5728");
            log.info(SERVICE_NAME + " ->  \u5931\u8d25\uff1a\u8be5\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
            return rspBo;
        }
        PayRuleParaPo qryParaPO = new PayRuleParaPo();
        qryParaPO.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        qryParaPO.setId(Long.valueOf(reqBo.getParaId()));
        List<PayRuleParaPo> qryList = this.payRuleParaAtomService.queryPayRuleParaByCondition(qryParaPO);
        if (CollectionUtils.isEmpty(qryList)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u5220\u9664\u5931\u8d25\uff0c\u8be5\u652f\u4ed8\u53c2\u6570\u4e0d\u5c5e\u4e8e\u8be5\u652f\u4ed8\u673a\u6784");
            return rspBo;
        }
        PayRuleParaPo qryParaPO2 = new PayRuleParaPo();
        qryParaPO2.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        qryParaPO2.setParameterCode(reqBo.getParameterCode());
        List<PayRuleParaPo> qryList2 = this.payRuleParaAtomService.queryPayRuleParaByCondition(qryParaPO2);
        if (!CollectionUtils.isEmpty(qryList2)) {
            PayRuleParaPo tempPo = qryList2.get(0);
            if (!reqBo.getParaId().equals(tempPo.getId().toString())) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u4fee\u6539\u652f\u4ed8\u7f16\u7801\u4e3a\u5df2\u5b58\u5728\u7684\u652f\u4ed8\u7f16\u7801");
                return rspBo;
            }
        }
        PayRuleParaPo updParaPO = new PayRuleParaPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)updParaPO);
        updParaPO.setId(Long.valueOf(reqBo.getParaId()));
        updParaPO.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        updParaPO.setUpdateTime(this.queryDBDateBusiService.getDBDate());
        if (!StringUtils.isEmpty((Object)reqBo.getNoNeedInput())) {
            updParaPO.setNoNeedInput(Integer.valueOf(reqBo.getNoNeedInput()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
            updParaPO.setUpdateOperId(reqBo.getOperId());
        }
        if ((updParaF = this.payRuleParaAtomService.updatePayRulePara(updParaPO)) < 1) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
            return rspBo;
        }
        PayRuleParaPo qryResult = new PayRuleParaPo();
        qryResult.setId(Long.valueOf(reqBo.getParaId()));
        PayRuleParaPo resultPo = this.payRuleParaAtomService.queryPayRuleParaById(qryResult);
        BeanUtils.copyProperties((Object)resultPo, (Object)rspBo);
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u66f4\u65b0\u6210\u529f");
        rspBo.setId(resultPo.getId().toString());
        rspBo.setPaymentInsId(resultPo.getPaymentInsId().toString());
        rspBo.setNoNeedInput(resultPo.getNoNeedInput().toString());
        rspBo.setPaymentInsName(paymentL.get(0).getPaymentInsName());
        rspBo.setCreateTime(resultPo.getCreateTime() == null ? "" : new DateTime((Object)resultPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setUpdateTime(resultPo.getUpdateTime() == null ? "" : new DateTime((Object)resultPo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setRemark(StringUtils.isEmpty((Object)resultPo.getRemark()) ? "" : resultPo.getRemark());
        QueryPCodeInfoReqBO qryNoNeedInput = new QueryPCodeInfoReqBO();
        qryNoNeedInput.setTypeCode("NO_NEED_INPUT_FLAG");
        qryNoNeedInput.setCodeValue(resultPo.getNoNeedInput().toString());
        QueryPCodeInfoRspBO qryNoNeedRsp = this.queryPCodeInfoService.queryPCodeInfo(qryNoNeedInput);
        if (qryNoNeedRsp.getRespCode().equals("0000")) {
            rspBo.setNoNeedInputName(qryNoNeedRsp.getCodeInfo() == null ? "" : qryNoNeedRsp.getCodeInfo());
        }
        QueryPCodeInfoReqBO qryStoreType = new QueryPCodeInfoReqBO();
        qryStoreType.setTypeCode("NO_NEED_INPUT_FLAG");
        qryStoreType.setCodeValue(resultPo.getStoreType());
        QueryPCodeInfoRspBO qryStoreTypeRsp = this.queryPCodeInfoService.queryPCodeInfo(qryStoreType);
        if (qryStoreTypeRsp.getRespCode().equals("0000")) {
            rspBo.setStoreTypeName(qryStoreTypeRsp.getCodeInfo() == null ? "" : qryStoreTypeRsp.getCodeInfo());
        }
        return rspBo;
    }

    private void validateArgPayRulePara(UpdatePaymentPayRuleParaWebReqBo reqBo) {
        if (reqBo == null) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61paymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getParameterCode())) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027ParameterCode\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getParameterName())) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027ParameterName\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getStoreType())) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027storeType\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53c2\u6570\u540d\u79f0storeType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBo.getStoreType().equals("2") && !reqBo.getStoreType().equals("1")) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027storeType\u4e0d\u7b26\u5408\u89c4\u8303");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53c2\u6570\u540d\u79f0storeType\u4e0d\u7b26\u5408\u89c4\u8303");
        }
        if (StringUtils.isEmpty((Object)reqBo.getNoNeedInput())) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027noNeedInput\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u662f\u5426\u9700\u8981\u624b\u52a8\u8f93\u5165noNeedInput\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBo.getNoNeedInput().equals("0") && !reqBo.getNoNeedInput().equals("1")) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027noNeedInput\u4e0d\u7b26\u5408\u89c4\u8303");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u662f\u5426\u9700\u8981\u624b\u52a8\u8f93\u5165noNeedInput\u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }

    @PostMapping(value={"updatePaymentPayMethod"})
    public PCodePayMethodBoStr updatePaymentPayMethod(@RequestBody UpdatePaymentPayMethodWebReqBo reqBo) {
        int updParaF;
        log.info(SERVICE_NAME + "\u5165\u53c2  -> " + JSON.toJSONString((Object)reqBo));
        PCodePayMethodBoStr rspBo = new PCodePayMethodBoStr();
        this.validateArgPayMethod(reqBo);
        PaymentInsPo qryPayPo = new PaymentInsPo();
        qryPayPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        List<PaymentInsPo> paymentL = this.paymentInsAtomService.queryPaymentInf(qryPayPo);
        if (CollectionUtils.isEmpty(paymentL)) {
            rspBo.setRspCode("8888");
            log.info(SERVICE_NAME + " ->  \u5931\u8d25\uff1a\u8be5\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff1a\u8be5\u652f\u4ed8\u673a\u6784\u4fe1\u606f\u4e0d\u5b58\u5728");
            return rspBo;
        }
        PayMethodPo qryPayMethodPo = this.payMethodAtomService.queryPayMethodById(Long.valueOf(reqBo.getPayMethod()));
        if (qryPayMethodPo == null) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u5220\u9664\u5931\u8d25\uff0c\u8be5\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5c5e\u4e8e\u8be5\u652f\u4ed8\u673a\u6784");
            return rspBo;
        }
        PayMethodPo qryPaymPo2 = new PayMethodPo();
        qryPaymPo2.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        qryPaymPo2.setPayMethodName(reqBo.getPayMethodName());
        List<PayMethodPo> qryList2 = this.payMethodAtomService.queryPayMethod(qryPaymPo2);
        if (!CollectionUtils.isEmpty(qryList2)) {
            PayMethodPo tempPo = qryList2.get(0);
            if (!reqBo.getPayMethod().equals(tempPo.getPayMethod().toString())) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff0c\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0\u4e3a\u5df2\u5b58\u5728\u7684\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0");
                return rspBo;
            }
        }
        PayMethodPo updPaymPO = new PayMethodPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)updPaymPO);
        updPaymPO.setPayMethod(Long.valueOf(reqBo.getPayMethod()));
        updPaymPO.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        updPaymPO.setUpdateTime(this.queryDBDateBusiService.getDBDate());
        if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
            updPaymPO.setUpdateOperId(reqBo.getOperId());
        }
        if ((updParaF = this.payMethodAtomService.updatePayMethod(updPaymPO)) < 1) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
            return rspBo;
        }
        PayMethodPo resultPo = this.payMethodAtomService.queryPayMethodById(Long.valueOf(reqBo.getPayMethod()));
        BeanUtils.copyProperties((Object)resultPo, (Object)rspBo);
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u66f4\u65b0\u6210\u529f");
        rspBo.setPayMethod(resultPo.getPayMethod().toString());
        rspBo.setPaymentInsId(resultPo.getPaymentInsId().toString());
        rspBo.setPaymentInsName(paymentL.get(0).getPaymentInsName());
        rspBo.setCreateTime(resultPo.getCreateTime() == null ? "" : new DateTime((Object)resultPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setUpdateTime(resultPo.getUpdateTime() == null ? "" : new DateTime((Object)resultPo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setRemark(StringUtils.isEmpty((Object)resultPo.getRemark()) ? "" : resultPo.getRemark());
        QueryPCodeInfoReqBO qryPayType = new QueryPCodeInfoReqBO();
        qryPayType.setTypeCode("NO_NEED_INPUT_FLAG");
        qryPayType.setCodeValue(resultPo.getPayType().toString());
        QueryPCodeInfoRspBO qryNoNeedRsp = this.queryPCodeInfoService.queryPCodeInfo(qryPayType);
        if (qryNoNeedRsp.getRespCode().equals("0000")) {
            rspBo.setPayTypeName(qryNoNeedRsp.getCodeInfo() == null ? "" : qryNoNeedRsp.getCodeInfo());
        }
        return rspBo;
    }

    private void validateArgPayMethod(UpdatePaymentPayMethodWebReqBo reqBo) {
        if (reqBo == null) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61paymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61payMethodName\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethodName())) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61payMethodName\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayType())) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61payType\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(reqBo.getPayType().equals("1") || reqBo.getPayType().equals("3") || reqBo.getPayType().equals("2") || reqBo.getPayType().equals("4"))) {
            log.info(SERVICE_NAME + "\u5f02\u5e38\uff1a\u5165\u53c2po\u5bf9\u8c61payType\u4e0d\u7b26\u5408\u89c4\u8303");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
        }
    }
}

