/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.AbilityToPayPlatformService;
import com.tydic.payment.pay.busi.WXDownloadBillBusiService;
import com.tydic.payment.pay.busi.WXPayApiBusiService;
import com.tydic.payment.pay.busi.bo.WXDownloadBillBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXDownloadBillBusiRspBO;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.wx.req.bo.WXApiDownloadBillReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiDownloadBillRspBO;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="wXDownloadBillBusiService")
public class WXDownLoadBillBusiServiceImpl
implements WXDownloadBillBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WXDownLoadBillBusiServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private AbilityToPayPlatformService abilityToPayPlatformService;
    @Autowired
    private WXPayApiBusiService wXPayApiBusiService;

    public WXDownloadBillBusiRspBO dealWxDownloadBill(WXDownloadBillBusiReqBO req) throws Exception {
        WXDownloadBillBusiRspBO rsp = new WXDownloadBillBusiRspBO();
        if (req == null) {
            LOGGER.info("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u670d\u52a1\u5165\u53c2 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)req.getAppid())) {
            LOGGER.info("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u670d\u52a1\u5165\u53c2\u3010appid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u670d\u52a1\u5165\u53c2\u3010appid\u3011 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)req.getMchid())) {
            LOGGER.info("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u670d\u52a1\u5165\u53c2\u3010mchid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u670d\u52a1\u5165\u53c2\u3010mchid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)req.getKey())) {
            LOGGER.info("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u670d\u52a1\u5165\u53c2\u3010key\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u670d\u52a1\u5165\u53c2\u3010key\u3011 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String billDate = StringUtils.isEmpty((Object)req.getBillDate()) ? new SimpleDateFormat("yyyyMMdd").format(new Date()) : req.getBillDate();
        String billType = "ALL";
        WXApiDownloadBillReqBO downloadBillReqData = new WXApiDownloadBillReqBO().setAppid(req.getAppid()).setMch_id(req.getMchid()).setSub_mch_id(req.getSubMchId()).setBill_date(billDate).setBill_type(billType).setNonce_str("").setKey(req.getKey());
        if ("1".equals(this.payPropertiesVo.getAbilitySwitch())) {
            rsp = this.dealWxBillByAbility(downloadBillReqData);
        } else if ("0".equals(this.payPropertiesVo.getAbilitySwitch())) {
            rsp = this.dealWxBillByWxApi(downloadBillReqData);
        }
        return rsp;
    }

    private WXDownloadBillBusiRspBO dealWxBillByAbility(WXApiDownloadBillReqBO downloadBillReqData) {
        WXDownloadBillBusiRspBO rsp = new WXDownloadBillBusiRspBO();
        try {
            JSONObject body = new JSONObject();
            JSONObject bodyInfo = new JSONObject();
            bodyInfo.put("APP_ID", (Object)downloadBillReqData.getAppid());
            bodyInfo.put("MCH_ID", (Object)downloadBillReqData.getMch_id());
            bodyInfo.put("NONCE_STR", (Object)downloadBillReqData.getNonce_str());
            bodyInfo.put("SIGN", (Object)downloadBillReqData.getSign());
            bodyInfo.put("BILL_DATE", (Object)downloadBillReqData.getBill_date());
            bodyInfo.put("BILL_TYPE", (Object)downloadBillReqData.getBill_type());
            body.put("DOWNLOAD_BILL_REQ", (Object)bodyInfo);
            String resultStr = this.abilityToPayPlatformService.abilityToPayPlatform(this.payPropertiesVo.getAbilityDownLoadBillUrl(), body);
            LOGGER.info("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u901a\u8fc7\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\uff1a" + resultStr);
            if (StringUtils.isEmpty((Object)resultStr)) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u901a\u8fc7\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
                return rsp;
            }
            JSONObject resultObj = JSONObject.parseObject((String)resultStr);
            JSONObject rspHeadInfo = resultObj.getJSONObject("UNI_BSS_HEAD");
            if (rspHeadInfo == null) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u901a\u8fc7\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010UNI_BSS_HEAD\u3011\u8282\u70b9\u4e3a\u7a7a");
                return rsp;
            }
            String rsp_code = rspHeadInfo.getString("RESP_CODE");
            if (rsp_code == null) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u901a\u8fc7\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u5934\u90e8\u4e2d\u7684\u54cd\u5e94\u7f16\u7801\u3010RESP_CODE\u3011\u8282\u70b9\u4e3a\u7a7a");
                return rsp;
            }
            if (!"00000".equals(rsp_code)) {
                rsp.setRspCode("8888");
                rsp.setRspName(rspHeadInfo.getString("RESP_DESC"));
                return rsp;
            }
            JSONObject rspBodyInfo = resultObj.getJSONObject("UNI_BSS_BODY");
            if (rspBodyInfo == null) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u901a\u8fc7\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010UNI_BSS_BODY\u3011\u8282\u70b9\u4e3a\u7a7a");
                return rsp;
            }
            JSONObject infoDetail = rspBodyInfo.getJSONObject("DOWNLOAD_BILL_RSP");
            if (infoDetail == null) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u5fae\u4fe1\u4e0b\u8f7d\u5bf9\u8d26\u5355\u901a\u8fc7\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u3010DOWNLOAD_BILL_RSP\u3011\u8282\u70b9\u4e3a\u7a7a");
                return rsp;
            }
            String RETURN_CODE = infoDetail.getString("RETURN_CODE");
            String RETURN_MSG = infoDetail.getString("RETURN_MSG");
            if (!StringUtils.isEmpty((Object)RETURN_CODE) && "FAIL".equals(RETURN_CODE)) {
                rsp.setRspCode("8888");
                rsp.setRspName(RETURN_MSG);
                return rsp;
            }
            String zipStr = infoDetail.getString("ZIP");
            if (StringUtils.isEmpty((Object)zipStr)) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u6ca1\u6709\u8d26\u5355\u5185\u5bb9\u8fd4\u56de");
                return rsp;
            }
            String billStr = new String(Base64.decodeBase64((String)zipStr), "UTF-8");
            rsp.setBillContent(billStr);
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rsp.setRspCode("8888");
            rsp.setRspName("\u901a\u8fc7\u80fd\u529b\u5e73\u53f0\u4e0b\u8f7d\u5fae\u4fe1\u5bf9\u8d26\u5355\u5f02\u5e38" + e.getMessage());
        }
        return rsp;
    }

    private WXDownloadBillBusiRspBO dealWxBillByWxApi(WXApiDownloadBillReqBO downloadBillReqData) {
        WXDownloadBillBusiRspBO rsp = new WXDownloadBillBusiRspBO();
        try {
            WXApiDownloadBillRspBO wXApiDownloadBillRspBO = this.wXPayApiBusiService.downloadBill(downloadBillReqData);
            if (!StringUtils.isEmpty((Object)wXApiDownloadBillRspBO.getReturn_code()) && "FAIL".equals(wXApiDownloadBillRspBO.getReturn_code())) {
                rsp.setRspCode("8888");
                rsp.setRspName(wXApiDownloadBillRspBO.getReturn_msg());
                return rsp;
            }
            if (StringUtils.isEmpty((Object)wXApiDownloadBillRspBO.getBillContent())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u6ca1\u6709\u8d26\u5355\u5185\u5bb9\u8fd4\u56de");
                return rsp;
            }
            rsp.setBillContent(wXApiDownloadBillRspBO.getBillContent());
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u901a\u8fc7\u5fae\u4fe1api\u4e0b\u8f7d\u5fae\u4fe1\u5bf9\u8d26\u5355\u5f02\u5e38" + e.getMessage());
        }
        return rsp;
    }
}

