/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.executor.busi;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.bill.BillBusiExecuteRequest;
import com.tydic.payment.bill.able.BillBusiFileGenerateAble;
import com.tydic.payment.bill.able.BillBusiFileGenerateInfo;
import com.tydic.payment.bill.able.BillBusiFileInfo;
import com.tydic.payment.bill.able.BillBusiTransInfo;
import com.tydic.payment.bill.able.BillFile;
import com.tydic.payment.bill.busi.BillCheckConfigQueryBusiService;
import com.tydic.payment.bill.busi.BillCompareParaQueryBusiService;
import com.tydic.payment.bill.busi.bo.BillCheckConfigQueryBusiReqBO;
import com.tydic.payment.bill.busi.bo.BillCheckConfigQueryBusiRspBO;
import com.tydic.payment.bill.busi.bo.BillCompareParaQueryReqBO;
import com.tydic.payment.bill.busi.bo.BillCompareParaQueryRspBO;
import com.tydic.payment.bill.exception.BillBusiException;
import com.tydic.payment.bill.executor.busi.AbstractBillBusiExecutor;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.busi.BusiPaymentMerchantQueryBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantInfoBusiBO;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantQueryBusiReqBO;
import com.tydic.payment.pay.busi.bo.BusiPaymentMerchantQueryBusiRspBO;
import com.tydic.payment.pay.dao.PaySettleBillFileMapper;
import com.tydic.payment.pay.dao.PaySettleTransMapper;
import com.tydic.payment.pay.dao.po.PaySettleBillFilePO;
import com.tydic.payment.pay.dao.po.PaySettleTransPO;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DefaultBillBusiExecutor
extends AbstractBillBusiExecutor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private FileClient fileClient;
    @Autowired
    private PaySettleBillFileMapper paySettleBillFileMapper;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    private BillCompareParaQueryBusiService billCompareParaQueryBusiService;
    private BusiPaymentMerchantQueryBusiService busiPaymentMerchantQueryBusiService;
    private BillCheckConfigQueryBusiService billCheckConfigQueryBusiService;
    private PaySettleTransMapper paySettleTransMapper;
    private BillBusiFileGenerateAble billBusiFileGenerateAble;
    @Autowired
    private CacheClient cacheClient;

    @Autowired
    public DefaultBillBusiExecutor(BillCompareParaQueryBusiService billCompareParaQueryBusiService, BusiPaymentMerchantQueryBusiService busiPaymentMerchantQueryBusiService, BillCheckConfigQueryBusiService billCheckConfigQueryBusiService, PaySettleTransMapper paySettleTransMapper, BillBusiFileGenerateAble billBusiFileGenerateAble) {
        this.billCompareParaQueryBusiService = billCompareParaQueryBusiService;
        this.busiPaymentMerchantQueryBusiService = busiPaymentMerchantQueryBusiService;
        this.billCheckConfigQueryBusiService = billCheckConfigQueryBusiService;
        this.paySettleTransMapper = paySettleTransMapper;
        this.billBusiFileGenerateAble = billBusiFileGenerateAble;
    }

    @Override
    protected void doCheckBusi(BillBusiExecuteRequest request) throws BillBusiException {
        Collection<BusiPaymentMerchantInfoBusiBO> paymentMchId = this.getPaymentMchId(request);
        if (null == paymentMchId || paymentMchId.size() < 1) {
            LoggerProUtils.debug(this.logger, "\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edfID[" + request.getBusiId() + "]\u5173\u8054\u7684\u652f\u4ed8\u5546\u6237ID\u4e3a\u7a7a");
            return;
        }
        for (BusiPaymentMerchantInfoBusiBO merchant : paymentMchId) {
            BillCheckConfigQueryBusiReqBO queryBusiReqBO = new BillCheckConfigQueryBusiReqBO();
            queryBusiReqBO.setPaymentInsId(merchant.getPaymentInsId());
            queryBusiReqBO.setPaymentMchId(merchant.getPaymentMchId());
            BillCheckConfigQueryBusiRspBO queryBusiRspBO = this.billCheckConfigQueryBusiService.query(queryBusiReqBO);
            if (null == queryBusiRspBO) {
                throw new BillBusiException("\u67e5\u8be2\u5bf9\u8d26\u914d\u7f6e\u4e3a\u7a7a\uff0c\u67e5\u8be2\u53c2\u6570\u4e3a\uff1a[" + queryBusiReqBO.toString() + "]");
            }
            if ("0".equals(queryBusiRspBO.getEffFlag()) || "1".equals(queryBusiRspBO.getLastResult())) continue;
            throw new BillBusiException("\u5173\u8054\u7684\u652f\u4ed8\u673a\u6784ID[" + queryBusiRspBO.getPaymentInsId() + "]\u652f\u4ed8\u5546\u6237ID[" + queryBusiRspBO.getPaymentMchId() + "]\u5bf9\u8d26\u5931\u8d25\u4e86");
        }
    }

    private Collection<BusiPaymentMerchantInfoBusiBO> getPaymentMchId(BillBusiExecuteRequest request) {
        BusiPaymentMerchantQueryBusiReqBO queryBusiReqBO = new BusiPaymentMerchantQueryBusiReqBO();
        queryBusiReqBO.setBusiId(request.getBusiId());
        BusiPaymentMerchantQueryBusiRspBO queryBusiRspBO = this.busiPaymentMerchantQueryBusiService.query(queryBusiReqBO);
        if (null == queryBusiRspBO) {
            return null;
        }
        return queryBusiRspBO.getMerchantInfoList();
    }

    @Override
    protected BillBusiFileInfo doCreateBillBusiFile(BillBusiExecuteRequest request) throws BillBusiException {
        int totalCount = this.getTotalCount(request);
        Long splitSize = this.getSplitSize();
        return this.createBillBusiFileInfo(request, totalCount, splitSize);
    }

    private synchronized BillBusiFileInfo createBillBusiFileInfo(BillBusiExecuteRequest request, int totalCount, Long splitSize) throws BillBusiException {
        BillBusiFileInfo billBusiFileInfo = new BillBusiFileInfo();
        ArrayList<BillFile> billFileList = new ArrayList<BillFile>(8);
        boolean isEmpty = totalCount == 0;
        int countFileNo = this.getCountFileNo(Integer.valueOf(totalCount).longValue(), splitSize);
        long startRow = 0L;
        StringBuffer filesStr = new StringBuffer("");
        try {
            for (int i = 0; i < countFileNo; ++i) {
                String fileName = this.getFileName(request, i);
                filesStr.append(fileName + ",");
                InputStream inputStream = this.createBillBusiFile(request, fileName, isEmpty, startRow, i, countFileNo, splitSize.intValue());
                startRow = splitSize * (long)(i + 1);
                BillFile billFile = new BillFile();
                billFile.setFileName(fileName);
                billFile.setInputStream(inputStream);
                billFileList.add(billFile);
                this.fileClient.uploadFileByInputStream("payCenter/billResultFiles/", fileName, inputStream);
                PaySettleBillFilePO qryBillFile = new PaySettleBillFilePO();
                qryBillFile.setFileName(fileName);
                List<PaySettleBillFilePO> paySettleBillFilePOS = this.paySettleBillFileMapper.queryBillFile(qryBillFile);
                if (paySettleBillFilePOS != null && !paySettleBillFilePOS.isEmpty()) {
                    PaySettleBillFilePO deletePo = new PaySettleBillFilePO();
                    deletePo.setFileName(fileName);
                    this.paySettleBillFileMapper.deleteBy(deletePo);
                }
                Date billFileDate = this.queryDBDateBusiService.getDBDate();
                PaySettleBillFilePO createPo = new PaySettleBillFilePO();
                createPo.setBusiId(request.getBusiId());
                createPo.setBillDate(request.getBillDate());
                createPo.setFileName(fileName);
                createPo.setCreateTime(billFileDate);
                createPo.setUploadFlag("1");
                createPo.setUploadTime(billFileDate);
                createPo.setRemark("\u5bf9\u8d26\u6587\u4ef6\u4e0a\u4f20");
                this.paySettleBillFileMapper.createPaySettleBillFileInfo(createPo);
            }
        }
        catch (Exception ex) {
            throw new BillBusiException("\u521b\u5efa\u4e1a\u52a1\u7cfb\u7edf\u8d26\u5355\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
        }
        String fileNamesStr = filesStr.toString();
        this.cacheClient.put("BILL_BUSI_FILENAMES", (Object)fileNamesStr.substring(0, fileNamesStr.length() - 1));
        billBusiFileInfo.setBillFileList(billFileList);
        billBusiFileInfo.setBillBusiExecuteRequest(request);
        return billBusiFileInfo;
    }

    private InputStream createBillBusiFile(BillBusiExecuteRequest request, String fileName, boolean isEmpty, long startRow, int itemFileNo, int countFileNo, int splitSize) throws Exception {
        BillBusiFileGenerateInfo info = new BillBusiFileGenerateInfo();
        info.setBillDate(request.getBillDate());
        info.setBusiCode(request.getBusiCode());
        info.setBusiId(request.getBusiId());
        info.setFileName(fileName);
        info.setIsEmpty(isEmpty);
        info.setCountFileNo(Integer.valueOf(countFileNo).longValue());
        info.setItemFileNo(Integer.valueOf(itemFileNo).longValue());
        info.setTransInfoList(this.getTransInfoList(request, isEmpty, startRow, splitSize));
        return this.billBusiFileGenerateAble.generateFile(info);
    }

    private List<BillBusiTransInfo> getTransInfoList(BillBusiExecuteRequest request, boolean isEmpty, long startRow, int splitSize) {
        if (isEmpty) {
            return new ArrayList<BillBusiTransInfo>(0);
        }
        PaySettleTransPO transPO = new PaySettleTransPO();
        transPO.setBillDate(request.getBillDate());
        transPO.setBusiId(request.getBusiId());
        transPO.setBusiCode(request.getBusiCode());
        List<PaySettleTransPO> transPOList = this.queryDataList(transPO, Long.valueOf(startRow).intValue(), splitSize);
        ArrayList<BillBusiTransInfo> transList = new ArrayList<BillBusiTransInfo>(transPOList.size());
        for (PaySettleTransPO po : transPOList) {
            BillBusiTransInfo trans = new BillBusiTransInfo();
            BeanUtils.copyProperties((Object)po, (Object)trans);
            transList.add(trans);
        }
        return transList;
    }

    private List<PaySettleTransPO> queryDataList(PaySettleTransPO paySettleTransPO, int startRow, int splitSize) {
        this.logger.debug("\u5f00\u59cb\u5206\u9875\u67e5\u8be2start...");
        Page page = new Page();
        page.setLimit(splitSize);
        page.setOffset(startRow);
        paySettleTransPO.setOrderBy("t.TRADE_TIME");
        List<PaySettleTransPO> list = this.paySettleTransMapper.getListPage((Page<PaySettleTransPO>)page, paySettleTransPO);
        this.logger.debug("\u5f00\u59cb\u5206\u9875\u67e5\u8be2end...");
        return list;
    }

    private int getCountFileNo(Long totalCount, Long splitSize) {
        double page2;
        if (0L == totalCount) {
            return 1;
        }
        double page1 = totalCount.doubleValue() / splitSize.doubleValue();
        return page1 > (page2 = (double)(totalCount.intValue() / splitSize.intValue())) ? Double.valueOf(page1).intValue() + 1 : Double.valueOf(page2).intValue();
    }

    private String getFileName(BillBusiExecuteRequest request, int itemFileNo) {
        String pattern = "0000";
        DecimalFormat df = new DecimalFormat(pattern);
        String squStr = df.format(itemFileNo);
        StringBuilder fileName = new StringBuilder(16);
        fileName.append(request.getBillDate());
        fileName.append("_");
        fileName.append(request.getBusiCode());
        fileName.append("_");
        fileName.append("checkBillFile");
        fileName.append("_");
        fileName.append(squStr);
        fileName.append(".REQ");
        return fileName.toString();
    }

    private Long getSplitSize() {
        BillCompareParaQueryReqBO reqBO = new BillCompareParaQueryReqBO();
        reqBO.setAttrCode("busi_bill_split_size");
        BillCompareParaQueryRspBO rspBO = this.billCompareParaQueryBusiService.getOneByAttrCode(reqBO);
        try {
            if (rspBO == null || StringUtils.isEmpty((Object)rspBO.getAttrValue())) {
                return Long.valueOf("100000");
            }
            return Long.valueOf(rspBO.getAttrValue());
        }
        catch (Exception ex) {
            return Long.valueOf("100000");
        }
    }

    private int getTotalCount(BillBusiExecuteRequest request) throws BillBusiException {
        PaySettleTransPO transPO = new PaySettleTransPO();
        transPO.setBillDate(request.getBillDate());
        transPO.setBusiId(request.getBusiId());
        transPO.setBusiCode(request.getBusiCode());
        try {
            return this.paySettleTransMapper.getCheckBy(transPO);
        }
        catch (Exception ex) {
            throw new BillBusiException("\u83b7\u53d6\u4e1a\u52a1\u7cfb\u7edf\u5bf9\u5e94\u6d41\u6c34\u603b\u8bb0\u5f55\u6570\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
        }
    }
}

