/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.busi.CashRefundBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.CashRefundBusiReqBo;
import com.tydic.payment.pay.busi.bo.CashRefundBusiRspBo;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cashRefundBusiService")
public class CashRefundBusiServiceImpl
implements CashRefundBusiService {
    private static final Logger log = LoggerFactory.getLogger(CashRefundBusiServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public CashRefundBusiRspBo dealCashRefund(CashRefundBusiReqBo cashRefundReqBo) {
        CashRefundBusiRspBo cashRefundRspBo = new CashRefundBusiRspBo();
        PorderPo orderNew = new PorderPo();
        orderNew.setOrderId(cashRefundReqBo.getRefundId());
        PorderRefundTransAtomReqBo porderRefundTransAtomReqBo = new PorderRefundTransAtomReqBo();
        porderRefundTransAtomReqBo.setOrderId(cashRefundReqBo.getRefundId());
        porderRefundTransAtomReqBo.setRefundOrderId(cashRefundReqBo.getRefundOrderId());
        orderNew.setOrderStatus("B10");
        orderNew.setRealFee(orderNew.getTotalFee());
        orderNew.setTradeTime(new SimpleDateFormat("yyyyMMddHHmmss").format(this.queryDBDateBusiService.getDBDate()));
        orderNew.setPayNotifyTime(this.queryDBDateBusiService.getDBDate());
        orderNew.setPayNotifyCode("0");
        cashRefundRspBo.setRefundStatus("SUCCESS");
        cashRefundRspBo.setRspCode("0000");
        cashRefundRspBo.setRspName("\u73b0\u91d1\u9000\u6b3e\u6210\u529f");
        cashRefundRspBo.setPayMethod(cashRefundReqBo.getPayMethod());
        cashRefundRspBo.setTradeTime(orderNew.getTradeTime());
        int count = 0;
        try {
            count = this.payOrderAtomService.update(orderNew);
            if (count == 0) {
                log.info("\u9000\u6b3e\u8d26\u5355\u66f4\u65b0\u5f02\u5e38");
                cashRefundRspBo.setMsg("\u9000\u6b3e\u8d26\u5355\u66f4\u65b0\u5f02\u5e38");
            }
            porderRefundTransAtomReqBo.setOrderStatus("B10");
            porderRefundTransAtomReqBo.setTradeTime(new SimpleDateFormat("yyyyMMddHHmmss").format(this.queryDBDateBusiService.getDBDate()));
            count = this.porderRefundTransAtomService.updateOrderRefundTransByRefundOrderId(porderRefundTransAtomReqBo);
            if (count == 0) {
                log.info("\u66f4\u65b0\u9000\u6b3e\u6d41\u6c34\u8ba2\u5355\u6570\u636e\u5f02\u5e38");
                cashRefundRspBo.setMsg("\u66f4\u65b0\u9000\u6b3e\u6d41\u6c34\u8ba2\u5355\u6570\u636e\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("\u73b0\u91d1\u9000\u6b3e\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            cashRefundRspBo.setRspCode("8888");
            cashRefundRspBo.setRspName("\u5931\u8d25");
        }
        return cashRefundRspBo;
    }
}

