/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PayProMerchantBusiService;
import com.tydic.payment.pay.busi.PayProOrderQueryBusiService;
import com.tydic.payment.pay.busi.PayProRealPayOrderBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.PayProMerchantBusiQryByIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryAddBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProRealPayOrderBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProRealPayOrderBusiRspBo;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.Date;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="payProRealPayOrderBusiService")
public class PayProRealPayOrderBusiServiceImpl
implements PayProRealPayOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(PayProRealPayOrderBusiServiceImpl.class);
    @Autowired
    private PayProOrderQueryBusiService payProOrderQueryBusiService;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private PayProMerchantBusiService payProMerchantBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public PayProRealPayOrderBusiRspBo createRealPayOrder(PayProRealPayOrderBusiReqBo reqBo) {
        Long orderId;
        PayProRealPayOrderBusiRspBo retBo = PayProRspUtil.generateRspBo("212065", "\u5931\u8d25", PayProRealPayOrderBusiRspBo.class);
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        Long busiId = reqBo.getBusiId();
        String outOrderId = reqBo.getOutOrderId();
        PorderPo oriOrderInfo = this.porderMapper.selectByOrderId(reqBo.getOriOrderId());
        PayProOrderQueryBusiReqBo qryOrderQueryBo = new PayProOrderQueryBusiReqBo();
        qryOrderQueryBo.setBusiId(busiId);
        qryOrderQueryBo.setOutOrderId(outOrderId);
        PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo orderQueryBo = this.payProOrderQueryBusiService.queryOrderQueryByBusiIdAndOutOrderId(qryOrderQueryBo);
        if ("0000".equals(orderQueryBo.getRespCode())) {
            orderId = orderQueryBo.getOrderId();
            PayOrderRspBo payOrderRspBo = this.payOrderBusiService.selectOrderByOrderId(orderId);
            if ("A10".equals(payOrderRspBo.getOrderStatus())) {
                retBo.setRespDesc("\u5916\u90e8\u8ba2\u5355\u53f7(" + outOrderId + ")\u5df2\u7ecf\u5b9e\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u5355");
                return retBo;
            }
            if ("A20".equals(payOrderRspBo.getOrderStatus())) {
                retBo.setRespDesc("\u5916\u90e8\u8ba2\u5355\u53f7(" + outOrderId + ")\u652f\u4ed8\u5b9e\u4ed8\u5931\u8d25\u4e86\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u5355");
                return retBo;
            }
            String checkResult = this.checkValue(payOrderRspBo, reqBo, busiId);
            if (!StringUtils.isEmpty((Object)checkResult)) {
                retBo.setRespCode("213001");
                retBo.setRespDesc("\u4e0b\u5355(\u91cd\u590d)\u5931\u8d25\uff1a" + checkResult);
                return retBo;
            }
            PayOrderRspBo rspBo = this.payOrderBusiService.dealDelay(payOrderRspBo.getOrderId());
            if (!"0000".equals(rspBo.getRspCode())) {
                retBo.setRespDesc("\u4e0b\u5355(\u91cd\u590d)\u5931\u8d25\uff1a\u5ef6\u957f\u8ba2\u5355\u65f6\u95f4\u5931\u8d25");
                return retBo;
            }
            retBo.setRespDesc("\u4e0b\u5355\u6210\u529f(re)");
        } else {
            orderId = this.createOrderAndQuery(reqBo, retBo, oriOrderInfo, busiId);
            if (null == orderId) {
                return retBo;
            }
            oriOrderInfo.setOrderAttrValue3(reqBo.getOutOrderId());
            int result = this.porderMapper.update(oriOrderInfo);
            if (result < 1) {
                throw new BusinessException("216039", "\u5c06\u5b9e\u4ed8\u5916\u90e8\u8ba2\u5355\u53f7\u5199\u5165\u539f\u652f\u4ed8\u5355\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            retBo.setRespDesc("\u6210\u529f");
        }
        String payOrderId = this.createPayTrans(reqBo, retBo, oriOrderInfo, orderId);
        if (StringUtils.isEmpty((Object)payOrderId)) {
            return retBo;
        }
        retBo.setOrderId(orderId);
        retBo.setPayOrderId(payOrderId);
        retBo.setRespCode("0000");
        return retBo;
    }

    private String checkValue(PayOrderRspBo payOrderRspBo, PayProRealPayOrderBusiReqBo reqBo, Long busiId) {
        if (!StringUtils.isEmpty((Object)payOrderRspBo.getNotifyUrl()) && !payOrderRspBo.getNotifyUrl().equals(reqBo.getNotifyUrl())) {
            return "notifyUrl\u4e0d\u4e00\u81f4";
        }
        return null;
    }

    private String createPayTrans(PayProRealPayOrderBusiReqBo reqBo, PayProRealPayOrderBusiRspBo retBo, PorderPo oriOrderInfo, Long orderId) {
        PorderPayTransPo transPo = new PorderPayTransPo();
        String id = String.valueOf(PayProSequence.nextId());
        String payOrderId = this.payPropertiesVo.getProjectName() + 'T' + id.substring(id.length() - 13);
        transPo.setPayOrderId(payOrderId);
        transPo.setOrderId(orderId);
        transPo.setBusiId(reqBo.getBusiId());
        transPo.setPayMethod(reqBo.getPayMethod());
        transPo.setMerchantId(reqBo.getMerchantId());
        transPo.setPayFee(oriOrderInfo.getTotalFee());
        transPo.setRefundFee(0L);
        transPo.setOrderStatus("A00");
        int count = this.porderPayTransMapper.insert(transPo);
        if (count != 1) {
            log.error("\u63d2\u5165p_order_pay_trans\u5931\u8d25\uff1asql\u8fd4\u56de\u503c\u4e0d\u4e3a1");
            retBo.setRespDesc("\u63d2\u5165p_order_pay_trans\u5931\u8d25\uff1asql\u8fd4\u56de\u503c\u4e0d\u4e3a1");
            return null;
        }
        return payOrderId;
    }

    private Long createOrderAndQuery(PayProRealPayOrderBusiReqBo reqBo, PayProRealPayOrderBusiRspBo retBo, PorderPo oriOrderInfo, Long busiId) {
        long orderId = PayProSequence.nextId();
        PorderPo orderInfo = new PorderPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)orderInfo);
        orderInfo.setOrderId(orderId);
        orderInfo.setOutOrderId(reqBo.getOutOrderId());
        orderInfo.setBusiId(oriOrderInfo.getBusiId());
        orderInfo.setBusiCode(oriOrderInfo.getBusiCode());
        orderInfo.setMerchantId(reqBo.getMerchantId());
        PayProMerchantBusiQryByIdBusiRspBo payProMerchantBusiQryByIdBusiRspBo = this.payProMerchantBusiService.queryMerchantByMerchantId(reqBo.getMerchantId());
        if (!"0000".equals(payProMerchantBusiQryByIdBusiRspBo.getRespCode())) {
            retBo.setRespDesc("\u67e5\u8be2\u5546\u6237\u4fe1\u606f\u5931\u8d25" + payProMerchantBusiQryByIdBusiRspBo.getRespDesc());
            return null;
        }
        orderInfo.setMerchantName(payProMerchantBusiQryByIdBusiRspBo.getMerchantName());
        orderInfo.setMerchantNameAbb(payProMerchantBusiQryByIdBusiRspBo.getMerchantNameAbb());
        orderInfo.setOrderType("01");
        orderInfo.setOrderStatus("A00");
        orderInfo.setTotalFee(oriOrderInfo.getTotalFee());
        orderInfo.setRealFee(oriOrderInfo.getRealFee());
        orderInfo.setDetailName(oriOrderInfo.getDetailName());
        orderInfo.setOutRemark(reqBo.getRemark());
        Date dbDate = this.queryDBDateBusiService.getDBDate();
        orderInfo.setCreateTime(dbDate);
        orderInfo.setExpTime(new DateTime((Object)dbDate).plusMinutes(30).toDate());
        orderInfo.setNotifyUrl(reqBo.getNotifyUrl());
        Long result = this.porderMapper.insertPorder(orderInfo);
        if (result != 1L) {
            throw new BusinessException("216039", "\u5b9e\u4ed8\u8ba2\u5355\u5165\u5e93\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        PayProOrderQueryBusiReqBo addQueryBo = new PayProOrderQueryBusiReqBo();
        addQueryBo.setOutOrderId(reqBo.getOutOrderId());
        addQueryBo.setBusiId(busiId);
        addQueryBo.setOrderId(Long.valueOf(orderId));
        PayProOrderQueryAddBusiRspBo payProOrderQueryAddBusiRspBo = this.payProOrderQueryBusiService.addOrderQuery(addQueryBo);
        if (!"0000".equals(payProOrderQueryAddBusiRspBo.getRespCode())) {
            retBo.setRespCode("213001");
            int deleteCount = this.porderMapper.deletePorderByOrderId(orderId);
            if (deleteCount < 1) {
                log.error("\u5199p_order\u8868\u6210\u529f\uff0c\u4f46\u63d2\u5165p_order_query\u8868\u5931\u8d25\uff0c\u4e14\u5220\u9664\u5df2\u63d2\u5165p_order\u8868\u6570\u636e\u4e5f\u5931\u8d25\uff0corderId=" + orderId);
                retBo.setRespDesc("\u5199p_order\u8868\u6210\u529f\uff0c\u4f46\u63d2\u5165p_order_query\u8868\u5931\u8d25\uff0c\u4e14\u5220\u9664\u5df2\u63d2\u5165p_order\u8868\u6570\u636e\u4e5f\u5931\u8d25\uff0corderId=" + orderId);
            } else {
                log.error("\u5199p_order\u8868\u6210\u529f\uff0c\u4f46\u63d2\u5165p_order_query\u8868\u5931\u8d25\uff0c\u4f46\u5220\u9664\u5df2\u63d2\u5165p_order\u8868\u6570\u636e\u6210\u529f");
                retBo.setRespDesc("\u5199p_order\u8868\u6210\u529f\uff0c\u4f46\u63d2\u5165p_order_query\u8868\u5931\u8d25\uff0c\u4f46\u5220\u9664\u5df2\u63d2\u5165p_order\u8868\u6570\u636e\u6210\u529f");
            }
            return null;
        }
        return orderId;
    }
}

