/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.PayProRealPayOrderBusiService;
import com.tydic.payment.pay.busi.PayProUpdateOrderTransBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProRealPayOrderBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProRealPayOrderBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateOrderTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateOrderTransBusiRspBo;
import com.tydic.payment.pay.comb.PayProQryCertifiedInfoCombService;
import com.tydic.payment.pay.comb.PayProRealPayCombService;
import com.tydic.payment.pay.comb.bo.PayProQryCertifiedInfoCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProQryCertifiedInfoCombServiceRspBo;
import com.tydic.payment.pay.comb.bo.PayProRealPayCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProRealPayCombServiceRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.icbc.util.StringUtils;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.PayAbleManager;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payProRealPayCombService")
public class PayProRealPayCombServiceImpl
implements PayProRealPayCombService {
    private static final Logger log = LoggerFactory.getLogger(PayProRealPayCombServiceImpl.class);
    @Autowired
    private PayProQryCertifiedInfoCombService payProQryCertifiedInfoCombService;
    @Autowired
    private PayAbleManager payAbleManager;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    @Autowired
    private PayProRealPayOrderBusiService payProRealPayOrderBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PayProUpdateOrderTransBusiService payProUpdateOrderTransBusiService;
    private Set<String> realPayMethodSet = new HashSet<String>();

    @PostConstruct
    public void initObject() {
        String realPayMethods = this.payPropertiesVo.getValueByKey("real.pay.method");
        if (!StringUtils.isEmpty((String)realPayMethods)) {
            Collections.addAll(this.realPayMethodSet, realPayMethods.split(","));
        }
    }

    public PayProRealPayCombServiceRspBo dealRealPay(PayProRealPayCombServiceReqBo reqBo) {
        PayProRealPayCombServiceRspBo retBo = PayProRspUtil.generateRspBo("213016", "\u5931\u8d25", PayProRealPayCombServiceRspBo.class);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}" + validateStr);
            return retBo;
        }
        PayProQryCertifiedInfoCombServiceReqBo qryCertifiedReqBo = new PayProQryCertifiedInfoCombServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryCertifiedReqBo);
        PayProQryCertifiedInfoCombServiceRspBo qryCertifiedRetBo = this.payProQryCertifiedInfoCombService.qryCertifiedOrder(qryCertifiedReqBo);
        if (!"0000".equals(qryCertifiedRetBo.getRespCode())) {
            log.error("\u8c03\u7528\u4fdd\u4ed8\u8ba2\u5355\u4fe1\u606fComb\u670d\u52a1\uff1a{}", (Object)qryCertifiedRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)qryCertifiedRetBo, (Object)retBo);
            return retBo;
        }
        Long payMethod = Long.valueOf(reqBo.getPayMethod());
        PayProQueryPayParaBusiReqBo qryParaReqBo = new PayProQueryPayParaBusiReqBo();
        qryParaReqBo.setMerchantId(reqBo.getMerchantId());
        qryParaReqBo.setPayMethod(payMethod);
        PayProQueryPayParaBusiRspBo qryParaRetBo = this.payProQueryPayParaBusiService.queryPayPara(qryParaReqBo);
        if (!"0000".equals(qryParaRetBo.getRespCode())) {
            log.error("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u9519\u8bef\uff1a{}", (Object)qryParaRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)qryParaRetBo, (Object)retBo);
            return retBo;
        }
        PayProRealPayOrderBusiReqBo createOrderReqBo = new PayProRealPayOrderBusiReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)createOrderReqBo);
        createOrderReqBo.setOriOrderId(qryCertifiedRetBo.getOriOrderId());
        createOrderReqBo.setPayMethod(payMethod);
        PayProRealPayOrderBusiRspBo createOrderRetBo = this.payProRealPayOrderBusiService.createRealPayOrder(createOrderReqBo);
        if (!"0000".equals(createOrderRetBo.getRespCode())) {
            log.error("\u8c03\u7528\u5b9e\u4ed8\u8ba2\u5355\u4fe1\u606f\u5165\u5e93busi\u670d\u52a1\u5931\u8d25\uff1a{}", (Object)createOrderRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)createOrderRetBo, (Object)retBo);
            return retBo;
        }
        PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(payMethod);
        PayAbleDealPayReqBo dealPayReqBo = new PayAbleDealPayReqBo();
        this.assignPayAbleBo(dealPayReqBo, qryCertifiedRetBo, reqBo, qryParaRetBo.getDetailAttrs());
        dealPayReqBo.setPayOrderId(createOrderRetBo.getPayOrderId());
        dealPayReqBo.setOrderId(createOrderRetBo.getOrderId());
        PayAbleDealPayRspBo dealPayRetBo = payAble.dealPay(dealPayReqBo);
        if (!"0000".equals(dealPayRetBo.getRespCode())) {
            log.error("\u8c03\u7528\u652f\u4ed8\u65b9\u5f0f{}\u7684\u5b9e\u73b0\u7c7b\u8fdb\u884c\u5b9e\u4ed8\u64cd\u4f5c\u5931\u8d25\uff1a{}", (Object)reqBo.getPayMethod(), (Object)dealPayRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)dealPayRetBo, (Object)retBo);
            return retBo;
        }
        if ("0000".equals(dealPayRetBo.getRespCode()) && "SUCCESS".equals(dealPayRetBo.getPayResultCode())) {
            PayProUpdateOrderTransBusiReqBo updateOrderBo = new PayProUpdateOrderTransBusiReqBo();
            updateOrderBo.setOrderId(createOrderRetBo.getOrderId());
            updateOrderBo.setPayOrderId(createOrderRetBo.getPayOrderId());
            updateOrderBo.setPayNotifyTime(this.queryDBDateBusiService.getDBDate());
            updateOrderBo.setOrderStatus("A10");
            updateOrderBo.setPayNotifyMsg(dealPayRetBo.getPayResultMsg());
            updateOrderBo.setPayNotifyTransId(dealPayRetBo.getPayNotifyTransId());
            updateOrderBo.setTradeTime(dealPayRetBo.getTradeTime());
            updateOrderBo.setPayNotifyCode("0");
            PayProUpdateOrderTransBusiRspBo updateOrderRetBo = this.payProUpdateOrderTransBusiService.updateOrderData(updateOrderBo);
            if (!"0000".equals(updateOrderRetBo.getRespCode())) {
                log.error("\u540c\u6b65\u7684\u5b9e\u4ed8\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a" + updateOrderRetBo.getRespDesc());
                BeanUtils.copyProperties((Object)updateOrderRetBo, (Object)retBo);
                return retBo;
            }
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setOrderId(createOrderRetBo.getOrderId().toString());
        retBo.setMerchantId(reqBo.getMerchantId().toString());
        retBo.setPayOrderId(createOrderRetBo.getPayOrderId());
        retBo.setPayFee(qryCertifiedRetBo.getPayFee().toString());
        retBo.setRealPayStatus(dealPayRetBo.getPayResultCode());
        retBo.setRealPayStatusDesc(dealPayRetBo.getPayResultMsg());
        retBo.setPayNotifyTransId(dealPayRetBo.getPayNotifyTransId());
        retBo.setTradeTime(dealPayRetBo.getTradeTime());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(PayProRealPayCombServiceReqBo reqBo) {
        String result = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((String)result)) {
            return result;
        }
        if (!this.realPayMethodSet.contains(reqBo.getPayMethod())) {
            return "\u6b64\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u6b64\u652f\u4ed8\u65b9\u5f0f\uff1a'payMethod = " + reqBo.getPayMethod() + "'";
        }
        return null;
    }

    private void assignPayAbleBo(PayAbleDealPayReqBo dealPayReqBo, PayProQryCertifiedInfoCombServiceRspBo qryCertifiedRetBo, PayProRealPayCombServiceReqBo reqBo, Map<String, String> detailAttrs) {
        dealPayReqBo.setBusiId(reqBo.getBusiId());
        dealPayReqBo.setMerchantId(reqBo.getMerchantId().toString());
        dealPayReqBo.setPayFee(qryCertifiedRetBo.getPayFee());
        dealPayReqBo.setDetailName(qryCertifiedRetBo.getDetailName() + "\u3010\u5b9e\u4ed8\u3011");
        dealPayReqBo.setRemark(reqBo.getRemark());
        dealPayReqBo.setParaMap(detailAttrs);
        dealPayReqBo.setBusiReqData(qryCertifiedRetBo.getBusiReqData());
    }
}

