/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.bo.PayProFailAsyncNoticeReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.PayProFailAsyncNotice;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.transbo.CnncInstrContentBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncInstrRenBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncInstrReqBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncIssItreasuryBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncQueryContentBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncQueryRenBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncQueryReqBo;
import com.tydic.payment.pay.payable.impl.transbo.CnncRenContentBo;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.payment.pay.util.XmlUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@EnableAsync
public abstract class AbstractCnncCaiQiTongPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractCnncCaiQiTongPayAble.class);
    protected static String CNNC_CAI_QI_TONG_SYSTEM_ID;
    private static final String QUERY_STATIC_TYPE = "3";
    private static final String PAY_RESULT_NOTIFY_TYPE = "4";
    private static final String STATUS_NO_SUCCESS = "01";
    private static final String STATUS_DEC_SUCCESS = "\u6210\u529f";
    protected static final String CNNC_PUBLIC_PAY = "1";
    protected static final String CNNC_PUBLIC_PAY_FAILED = "02";
    protected static final String CNNC_INTERNAL_TRANSFER = "NBZZ";
    protected static final String CNNC_EXTERNAL_TRANSFER = "YHFK";
    protected static final String BAR = "-";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PayProFailAsyncNotice payProFailAsyncNotice;

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        CnncRenContentBo rspContent;
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validateStr = this.validateRefundArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.info("\u8d22\u4f01\u901a\u9000\u6b3e\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        String cnncCaiQiTongUrl = this.payPropertiesVo.getValueByKey("cnnc.caiqitong.url");
        log.debug("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u5bf9\u516c\u4ed8\u6b3e\u63a5\u53e3\u7684\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)cnncCaiQiTongUrl);
        if (StringUtils.isEmpty((Object)cnncCaiQiTongUrl)) {
            log.error("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u5bf9\u516c\u4ed8\u6b3e\u63a5\u53e3\u7684\u8bf7\u6c42\u5730\u5740\u4e3a'cnnc.caiqitong.url'\u672a\u914d\u7f6e");
            retBo.setRespCode("212058");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u5bf9\u516c\u4ed8\u6b3e\u63a5\u53e3\u7684\u8bf7\u6c42\u5730\u5740\u4e3a'cnnc.caiqitong.url'\u672a\u914d\u7f6e");
            return retBo;
        }
        String reqStr = this.assembleRefundData(reqBo);
        if (StringUtils.isEmpty((Object)reqStr)) {
            log.error("CNN\u8d22\u4f01\u901a\u9000\u6b3e\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u5b57\u7b26\u4e32\u5931\u8d25");
            retBo.setRespCode("8888");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u9000\u6b3e\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u7ec4\u88c5\u5165\u53c2\u5b57\u7b26\u4e32\u5931\u8d25");
            return retBo;
        }
        HashMap<String, String> reqMap = new HashMap<String, String>(1);
        reqMap.put("_USER_REQUEST_DATA", reqStr);
        String retStr = ((HttpRequest)HttpRequest.post((String)cnncCaiQiTongUrl).contentType("application/x-www-form-urlencoded;charset=GBK").charset("GBK")).form(reqMap).execute().body();
        log.debug("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u7684\u9000\u6b3e\u54cd\u5e94\u8fd4\u56de\u7684xml\u4e3a\uff1a{}", (Object)retStr);
        try {
            CnncIssItreasuryBo cnncIssItreasuryReqBo = (CnncIssItreasuryBo)XmlUtils.xmlToObj(retStr, CnncIssItreasuryBo.class, "GBK");
            rspContent = cnncIssItreasuryReqBo.getInstrRen().getRenContent().get(0);
        }
        catch (Exception e) {
            log.error("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u7684\u9000\u6b3e\u901a\u8baf\u5931\u8d25,\u5931\u8d25\u539f\u56e0\u4e3a\uff1a{}", (Object)e.getMessage());
            retBo.setRespCode("8888");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u7684\u9000\u6b3e\u901a\u8baf\u5931\u8d25");
            return retBo;
        }
        if (CNNC_PUBLIC_PAY_FAILED.equals(rspContent.getStatusNo())) {
            log.error("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u7684\u9000\u6b3e\u63a5\u6536\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)rspContent.getStatusDec());
            retBo.setRespCode("8888");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u6210\u5458\u5355\u4f4d\u7684\u9000\u6b3e\u63a5\u6536\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + rspContent.getStatusDec());
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc(STATUS_DEC_SUCCESS);
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        CnncIssItreasuryBo renBo;
        PayAbleCallBackRspBo retBo = new PayAbleCallBackRspBo();
        String validateStr = this.validateCallBackArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        String resultMsg = reqBo.getReqData();
        log.debug("\u56de\u8c03\u7684\u4fe1\u606f\u4e32\u4e3a\uff1a{}", (Object)resultMsg);
        try {
            renBo = (CnncIssItreasuryBo)XmlUtils.xmlToObj(resultMsg, CnncIssItreasuryBo.class, "GBK");
        }
        catch (Exception e) {
            log.error("\u5c06\u8d22\u4f01\u901a\u56de\u8c03\u7684\u4fe1\u606f\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25\uff1a{}", (Throwable)e);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5c06\u8d22\u4f01\u901a\u56de\u8c03\u7684\u4fe1\u606f\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25\uff1a" + e);
            return retBo;
        }
        log.info("\u89e3\u6790\u5f97\u5230\u7684\u5bf9\u8c61\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)renBo));
        if (null == renBo || null == renBo.getQueryRen()) {
            log.error("\u8fd4\u56de\u7684\u6d88\u606f\u4f53\u683c\u5f0f\u4e0d\u6b63\u786e");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8fd4\u56de\u7684\u6d88\u606f\u4f53\u683c\u5f0f\u4e0d\u6b63\u786e");
            return retBo;
        }
        List<CnncRenContentBo> renContents = renBo.getQueryRen().getRenContent();
        if (CollectionUtils.isEmpty(renContents)) {
            log.error("\u8fd4\u56de\u7684\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8fd4\u56de\u7684\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            return retBo;
        }
        CnncRenContentBo renContent = renContents.get(0);
        String cnncStatusNo = renContent.getStatusNo();
        log.debug("\u8fd4\u56de\u7684\u4ea4\u6613\u72b6\u6001\u7f16\u7801\u4e3a\uff1a{}\uff0c\u5bf9\u5e94\u72b6\u6001\uff1a{}", (Object)cnncStatusNo, (Object)renContent.getStatusDec());
        this.init();
        String payOrderId = renContent.getApplyCode().substring(CNNC_CAI_QI_TONG_SYSTEM_ID.length());
        if (!"04".equals(cnncStatusNo)) {
            if (STATUS_NO_SUCCESS.equals(cnncStatusNo) || "05".equals(cnncStatusNo)) {
                PayProFailAsyncNoticeReqBo noticeDataBo = new PayProFailAsyncNoticeReqBo();
                noticeDataBo.setTransOrderId(payOrderId);
                noticeDataBo.setOrderStatus("FAIL");
                noticeDataBo.setStatusDesc(renContent.getStatusDec());
                noticeDataBo.setIsRefund(Boolean.valueOf(reqBo.isRefund()));
                this.payProFailAsyncNotice.sendMessage(noticeDataBo);
            }
            retBo.setRespCode("8888");
            retBo.setRespDesc(renContent.getStatusDec());
            return retBo;
        }
        retBo.setPayOrderId(payOrderId);
        retBo.setPayNotifyTransId(renContent.getTransNo());
        String tradeTime = renContent.getDealTime();
        retBo.setTradeTime(DateTime.parse((String)tradeTime, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss")).toString("yyyyMMddHHmmss"));
        retBo.setDealResult(this.assembleNotifyData(renContent));
        retBo.setRespCode("0000");
        retBo.setRespDesc(STATUS_DEC_SUCCESS);
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        CnncIssItreasuryBo cnncIssItreasuryBo;
        PayAbleQryPayStatusRspBo retBo = PayProRspUtil.generateRspBo("8888", "\u5931\u8d25", PayAbleQryPayStatusRspBo.class);
        String validateStr = this.validateQryArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String caiqitongQueryUrl = this.payPropertiesVo.getValueByKey("cnnc.caiqitong.url");
        if (StringUtils.isEmpty((Object)caiqitongQueryUrl)) {
            log.error("CNNC\u8d22\u4f01\u901a\u4e1a\u52a1\u6307\u4ee4\u67e5\u8be2\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"cnnc.caiqitong.url");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u4e1a\u52a1\u6307\u4ee4\u67e5\u8be2\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0cnnc.caiqitong.url");
            return retBo;
        }
        String reqStr = this.assembleData(reqBo);
        if (StringUtils.isEmpty((Object)reqStr)) {
            log.error("CNNC\u8d22\u4f01\u901a\u4e1a\u52a1\u6307\u4ee4\u67e5\u8be2\uff0c\u7ec4\u88c5\u5165\u53c2\u5b57\u7b26\u4e32\u5931\u8d25");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u4e1a\u52a1\u6307\u4ee4\u67e5\u8be2\uff0c\u7ec4\u88c5\u5165\u53c2\u5b57\u7b26\u4e32\u5931\u8d25");
            return retBo;
        }
        HashMap<String, String> reqMap = new HashMap<String, String>(1);
        reqMap.put("_USER_REQUEST_DATA", reqStr);
        String retStr = ((HttpRequest)HttpRequest.post((String)caiqitongQueryUrl).contentType("application/x-www-form-urlencoded;charset=GBK").charset("GBK")).form(reqMap).execute().body();
        log.info("CNNC\u8d22\u4f01\u901a\u4e1a\u52a1\u6307\u4ee4\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)retStr);
        try {
            cnncIssItreasuryBo = (CnncIssItreasuryBo)XmlUtils.xmlToObj(retStr, CnncIssItreasuryBo.class, "GBK");
        }
        catch (Exception e) {
            log.error("\u7ed3\u679c\u8f6c\u6362\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u4e1a\u52a1\u6307\u4ee4\u67e5\u8be2\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u8fd4\u56de\u5185\u5bb9\u4e0d\u7b26\u5408\u8981\u6c42");
            return retBo;
        }
        if (null == cnncIssItreasuryBo || null == cnncIssItreasuryBo.getQueryRen()) {
            log.error("CNNC\u8d22\u4f01\u901a\u4e1a\u52a1\u6307\u4ee4\u67e5\u8be2\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u4e1a\u52a1\u6307\u4ee4\u67e5\u8be2\u63a5\u53e3\u901a\u8baf\u5931\u8d25\uff0c\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
            return retBo;
        }
        this.sortQryStatusRetBo(retBo, cnncIssItreasuryBo.getQueryRen());
        retBo.setOrderId(reqBo.getOrderId());
        retBo.setPayOrderId(reqBo.getPayOrderId());
        return retBo;
    }

    protected String validateRefundArgs(PayAbleRefundReqBo reqBo) {
        String validateConfig = this.init();
        if (!StringUtils.isEmpty((Object)validateConfig)) {
            return validateConfig;
        }
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'RefundOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String cnncPayeeAcctNo = (String)paraMap.get("cnncPayeeAcctNo");
        if (StringUtils.isEmpty((Object)cnncPayeeAcctNo)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d[cnncPayeeAcctNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!cnncPayeeAcctNo.contains(BAR)) {
            return "\u652f\u4ed8\u8ba2\u5355\u6536\u6b3e\u65b9\u975e\u5185\u90e8\u8d26\u6237\uff0c\u4e0d\u652f\u6301\u9000\u6b3e";
        }
        if (StringUtils.isEmpty(paraMap.get("cnncPayeeAcctName"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d[cnncPayeeAcctName]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(paraMap.get("cnncCommitter"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d[cnncCommitter]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map payTransParam = reqBo.getPayTransParam();
        if (null == payTransParam) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payTransParam]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(payTransParam.get("clientName"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payTransParam]\u4e2d\u7684[clientName]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(payTransParam.get("payerAcctNo"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payTransParam]\u4e2d\u7684[payerAcctNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(payTransParam.get("remitCity"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payTransParam]\u4e2d\u7684[remitCity]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty(payTransParam.get("remitProvince"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[payTransParam]\u4e2d\u7684[remitProvince]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String validateQryArgs(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027orderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return this.init();
    }

    private String assembleRefundData(PayAbleRefundReqBo reqBo) {
        Map paraMap = reqBo.getParaMap();
        Map payTransParam = reqBo.getPayTransParam();
        CnncIssItreasuryBo Iss_Itreasury = new CnncIssItreasuryBo();
        CnncInstrReqBo InstrReq = new CnncInstrReqBo();
        ArrayList<CnncInstrContentBo> InstrContent = new ArrayList<CnncInstrContentBo>();
        Iss_Itreasury.setInstrReq(InstrReq);
        InstrReq.setOperationType(CNNC_PUBLIC_PAY);
        InstrReq.setSystemID(CNNC_CAI_QI_TONG_SYSTEM_ID);
        String applyCode = CNNC_CAI_QI_TONG_SYSTEM_ID + reqBo.getRefundOrderId();
        InstrReq.setBatchCode(applyCode);
        InstrReq.setInstrContent(InstrContent);
        CnncInstrContentBo content = new CnncInstrContentBo();
        InstrContent.add(content);
        content.setApplyCode(applyCode);
        content.setAmount(MoneyUtils.fenToYuanToString((BigDecimal)new BigDecimal(reqBo.getRefundFee())));
        Date nowTime = this.payMethodMapper.getDBDate().getDate();
        DateTime nowDateTime = new DateTime((Object)nowTime);
        content.setExcuteDate(nowDateTime.toString("yyyy-MM-dd"));
        content.setClientName((String)paraMap.get("cnncPayeeAcctName"));
        content.setPayerAcctNo((String)paraMap.get("cnncPayeeAcctNo"));
        content.setConfirmUser((String)paraMap.get("cnncCommitter"));
        content.setPayeeAcctNo((String)payTransParam.get("payerAcctNo"));
        content.setPayeeAcctName((String)payTransParam.get("clientName"));
        content.setRemitProvince((String)payTransParam.get("remitProvince"));
        content.setRemitCity((String)payTransParam.get("remitCity"));
        content.setTransType(CNNC_INTERNAL_TRANSFER);
        content.setConfirmTime(nowDateTime.toString("yyyy-MM-dd HH:mm:ss"));
        content.setNote(reqBo.getRefundReason());
        log.debug("\u7ec4\u88c5\u5b8c\u6210\u7684\u5bf9\u8c61\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)Iss_Itreasury));
        String xmlStr = null;
        try {
            xmlStr = XmlUtils.objToXml(Iss_Itreasury, "GBK");
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u8f6cXML\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return xmlStr;
    }

    private String assembleData(PayAbleQryPayStatusReqBo reqBo) {
        CnncIssItreasuryBo Iss_Itreasury = new CnncIssItreasuryBo();
        CnncQueryReqBo queryReq = new CnncQueryReqBo();
        queryReq.setOperationType(QUERY_STATIC_TYPE);
        queryReq.setSystemId(CNNC_CAI_QI_TONG_SYSTEM_ID);
        queryReq.setPackageCode(CNNC_CAI_QI_TONG_SYSTEM_ID + reqBo.getPayOrderId());
        ArrayList<CnncQueryContentBo> queryContentList = new ArrayList<CnncQueryContentBo>(16);
        CnncQueryContentBo queryContent = new CnncQueryContentBo();
        queryContent.setApplyCode(CNNC_CAI_QI_TONG_SYSTEM_ID + reqBo.getPayOrderId());
        queryContentList.add(queryContent);
        queryReq.setQueryContent(queryContentList);
        Iss_Itreasury.setQueryReq(queryReq);
        log.debug("\u7ec4\u88c5\u5b8c\u6210\u7684\u5bf9\u8c61\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)Iss_Itreasury));
        String xmlStr = null;
        try {
            xmlStr = XmlUtils.objToXml(Iss_Itreasury, "GBK");
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u8f6cXML\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return xmlStr;
    }

    private String assembleNotifyData(CnncRenContentBo contentBo) {
        CnncIssItreasuryBo Iss_Itreasury = new CnncIssItreasuryBo();
        CnncInstrRenBo instrRenBo = new CnncInstrRenBo();
        instrRenBo.setOperationType(PAY_RESULT_NOTIFY_TYPE);
        CnncRenContentBo renContentBo = new CnncRenContentBo();
        renContentBo.setApplyCode(contentBo.getApplyCode());
        renContentBo.setStatusNo(STATUS_NO_SUCCESS);
        renContentBo.setStatusDec(STATUS_DEC_SUCCESS);
        ArrayList<CnncRenContentBo> renContentBos = new ArrayList<CnncRenContentBo>();
        renContentBos.add(renContentBo);
        instrRenBo.setRenContent(renContentBos);
        Iss_Itreasury.setInstrRen(instrRenBo);
        log.debug("\u7ec4\u88c5\u5b8c\u6210\u7684\u5bf9\u8c61\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)Iss_Itreasury));
        String xmlStr = null;
        try {
            xmlStr = XmlUtils.objToXml(Iss_Itreasury, "GBK");
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u8f6cXML\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return xmlStr;
    }

    private void sortQryStatusRetBo(PayAbleQryPayStatusRspBo retBo, CnncQueryRenBo cnncQueryRenBo) {
        List<CnncRenContentBo> renContents = cnncQueryRenBo.getRenContent();
        if (CollectionUtils.isEmpty(renContents)) {
            log.error("CNNC\u8d22\u4f01\u901a\u8fd4\u56de\u7684\u4fe1\u606f\u5185\u5bb9\u4e3a\u7a7a");
            retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u8fd4\u56de\u7684\u4fe1\u606f\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        CnncRenContentBo renContent = renContents.get(0);
        String statusNo = renContent.getStatusNo();
        retBo.setRespCode("0000");
        retBo.setRespDesc(STATUS_DEC_SUCCESS);
        switch (statusNo) {
            case "04": {
                retBo.setPayNotifyTransId(renContent.getTransNo());
                retBo.setTradeTime(renContent.getDealTime());
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg(renContent.getStatusDec());
                break;
            }
            case "02": 
            case "03": {
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg(renContent.getStatusDec());
                break;
            }
            case "05": 
            case "01": {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg(renContent.getStatusDec());
                break;
            }
            default: {
                retBo.setRespCode("8888");
                retBo.setRespDesc("CNNC\u8d22\u4f01\u901a\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u503c");
            }
        }
    }

    protected String init() {
        CNNC_CAI_QI_TONG_SYSTEM_ID = this.payPropertiesVo.getValueByKey("cnnc.caiqitong.system.id");
        if (StringUtils.isEmpty((Object)CNNC_CAI_QI_TONG_SYSTEM_ID)) {
            log.error("*CNNC\u8d22\u4f01\u901a\u7cfb\u7edf\u6807\u8bc6\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"cnnc.caiqitong.system.id");
            return "CNNC\u8d22\u4f01\u901a\u7cfb\u7edf\u6807\u8bc6\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0cnnc.caiqitong.system.id";
        }
        return null;
    }

    protected String validateParamArgs(Map<String, String> paramMap) {
        if (StringUtils.isEmpty(paramMap)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String cnncPayeeAcctNo = paramMap.get("cnncPayeeAcctNo");
        if (StringUtils.isEmpty((Object)cnncPayeeAcctNo)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'cnncPayeeAcctNo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!cnncPayeeAcctNo.contains(BAR)) {
            if (StringUtils.isEmpty((Object)paramMap.get("cnncRemitBankCNAPS"))) {
                return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'cnncRemitBankCNAPS'\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)paramMap.get("cnncRemitProvince"))) {
                return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'cnncRemitProvince'\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        if (StringUtils.isEmpty((Object)paramMap.get("cnncPayeeAcctName"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'cnncPayeeAcctName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paramMap.get("cnncRemitBankName"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'cnncRemitBankName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paramMap.get("cnncRemitCity"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'cnncRemitCity'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return this.init();
    }

    private String validateCallBackArgs(PayAbleCallBackReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'reqData'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

