/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.transbo.WoPayNewNotifyBO;
import com.tydic.payment.pay.payable.impl.transbo.WoPayNewQueryStatusReqBO;
import com.tydic.payment.pay.payable.impl.transbo.WoPayNewQueryStatusRspBO;
import com.tydic.payment.pay.payable.impl.transbo.WoPayNewRefundRspBO;
import com.tydic.payment.pay.payable.impl.transbo.WopayNewRefundReqBO;
import com.tydic.payment.pay.util.WoPayNewUtil;
import com.tydic.payment.pay.wopay.util.SSLClient;
import com.tydic.payment.pay.wopay.util.UniPaySignUtilsCer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractNewWopayPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractNewWopayPayAble.class);
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    private final Map<String, File> fileCache = new HashMap<String, File>();
    private final String SIGN_TYPE = "RSA_SHA256";
    private static final String SUCCESS = "1";
    public static final String MER_NO = "merNo";
    public static final String MER_PRIVATE_KEY_CERT = "merSignDir";
    public static final String CERT_PWD = "merSignKey";
    public static final String UTF_8 = "UTF-8";
    private static final String QUERY_SUCCESS = "SUCCESS";
    private static final String REFUND_SUCCESS = "SUCCESS";
    private final String QUERY_SUCCESS_VALUE = "SUCCESS";
    public static final String QUERY_STATUS_SUCCESS = "1";
    public static final String QUERY_STATUS_PAYING = "0";
    public static final String QUERY_STATUS_CLOSED = "2";

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validateArgStr = this.validateRefundArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String woPayNewRefundUrl = this.payPropertiesVo.getWoPayNewRefundUrl();
        if (StringUtils.isEmpty((Object)woPayNewRefundUrl)) {
            throw new BusinessException("8888", "\u6c83\u652f\u4ed8\uff08\u65b0\uff09\u9000\u6b3e\u5730\u5740\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String merNo = (String)paraMap.get(MER_NO);
        String merPrivateKeyCert = (String)paraMap.get(MER_PRIVATE_KEY_CERT);
        String certPwd = (String)paraMap.get(CERT_PWD);
        if (StringUtils.isEmpty((Object)merNo)) {
            throw new BusinessException("8888", "\u5546\u6237\u53f7\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)merPrivateKeyCert)) {
            throw new BusinessException("8888", "\u79c1\u94a5\u8bc1\u4e66\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)certPwd)) {
            throw new BusinessException("8888", "\u8bc1\u4e66\u5bc6\u7801\u672a\u914d\u7f6e");
        }
        Long orderId = reqBo.getOrderId();
        PorderPo porderPo = this.porderMapper.selectByOrderId(orderId);
        if (ObjectUtils.isEmpty((Object)porderPo)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\uff1a" + orderId + ", \u9000\u6b3e\u5931\u8d25");
            return retBo;
        }
        String tradeTime = porderPo.getTradeTime();
        if (StringUtils.isEmpty((Object)tradeTime)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u672a\u4ea4\u6613\u6210\u529f\uff0c \u9000\u6b3e\u5931\u8d25");
            return retBo;
        }
        String orderDate = tradeTime.substring(0, 8);
        WopayNewRefundReqBO wopayNewRefundReqBO = new WopayNewRefundReqBO();
        wopayNewRefundReqBO.setRefundReqJournl(reqBo.getRefundOrderId());
        wopayNewRefundReqBO.setMerNo(merNo);
        wopayNewRefundReqBO.setOrderNo(reqBo.getPayOrderId());
        wopayNewRefundReqBO.setOrderDate(orderDate);
        wopayNewRefundReqBO.setPayJournl(reqBo.getPayNotifyTransId());
        wopayNewRefundReqBO.setMerReqTime(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        wopayNewRefundReqBO.setAmount(String.valueOf(reqBo.getRefundFee()));
        wopayNewRefundReqBO.setReason(reqBo.getRefundReason());
        wopayNewRefundReqBO.setSignType("RSA_SHA256");
        Map sortMap = UniPaySignUtilsCer.obj2NormalMap((Object)wopayNewRefundReqBO);
        String sign = this.getSign(sortMap, merPrivateKeyCert, certPwd);
        wopayNewRefundReqBO.setSignMsg(sign);
        Map reqMap = UniPaySignUtilsCer.obj2NormalMap((Object)wopayNewRefundReqBO);
        List resultList = null;
        try {
            resultList = WoPayNewUtil.httpUrlPost(woPayNewRefundUrl, reqMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        String resultJson = this.list2Json(resultList);
        WoPayNewRefundRspBO woPayNewRefundRspBO = (WoPayNewRefundRspBO)JSON.parseObject((String)resultJson, WoPayNewRefundRspBO.class);
        if (StringUtils.isEmpty((Object)woPayNewRefundRspBO.getTransRet()) || !"SUCCESS".equals(woPayNewRefundRspBO.getTransRet())) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        retBo.setRefundTransId(woPayNewRefundRspBO.getAcceptNo());
        retBo.setTradeTime(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        log.info("\u8fdb\u5165\u8054\u901a-\u6c83\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\uff1a{}" + JSONObject.toJSONString((Object)reqBo));
        PayAbleCallBackRspBo retBo = new PayAbleCallBackRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            log.error("\u6c83\u652f\u4ed8(\u65b0)\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u6c83\u652f\u4ed8\uff08\u65b0\uff09\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        String reqData = reqBo.getReqData();
        WoPayNewNotifyBO woPayNewNotifyBO = (WoPayNewNotifyBO)JSON.parseObject((String)reqData, WoPayNewNotifyBO.class);
        if (woPayNewNotifyBO == null) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        PorderPayTransPo po = new PorderPayTransPo();
        po.setPayOrderId(woPayNewNotifyBO.getOrderNo());
        List<PorderPayTransPo> resultList = this.porderPayTransMapper.getOrderPayTransByCondition(po);
        if (CollectionUtils.isEmpty(resultList)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        Long merchantId = resultList.get(0).getMerchantId();
        woPayNewNotifyBO.setSignMsg(null);
        Map sortMap = UniPaySignUtilsCer.obj2NormalMap((Object)woPayNewNotifyBO);
        sortMap.entrySet().removeIf(entry -> entry.getValue() == null || "".equals(entry.getValue()) || ((String)entry.getValue()).equals(0L) || ((String)entry.getValue()).equals(0));
        if (!this.isSuccess(woPayNewNotifyBO)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        retBo.setTradeTime(woPayNewNotifyBO.getPayTime());
        retBo.setPayOrderId(woPayNewNotifyBO.getOrderNo());
        retBo.setPayNotifyTransId(woPayNewNotifyBO.getPayJnlno());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateArgStr = this.validateQryArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String woPayNewQueryUrl = this.payPropertiesVo.getWoPayNewQueryUrl();
        if (StringUtils.isEmpty((Object)woPayNewQueryUrl)) {
            throw new BusinessException("8888", "\u6c83\u652f\u4ed8\uff08\u65b0\uff09\u67e5\u8be2\u5730\u5740\u672a\u914d\u7f6e");
        }
        Map paraMap = reqBo.getParaMap();
        String merNo = (String)paraMap.get(MER_NO);
        String merPrivateKeyCert = (String)paraMap.get(MER_PRIVATE_KEY_CERT);
        String certPwd = (String)paraMap.get(CERT_PWD);
        if (StringUtils.isEmpty((Object)merNo)) {
            throw new BusinessException("8888", "\u5546\u6237\u53f7\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)merPrivateKeyCert)) {
            throw new BusinessException("8888", "\u79c1\u94a5\u8bc1\u4e66\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)certPwd)) {
            throw new BusinessException("8888", "\u8bc1\u4e66\u5bc6\u7801\u672a\u914d\u7f6e");
        }
        PorderPayTransPo porderPayTransPo = new PorderPayTransPo();
        porderPayTransPo.setPayOrderId(reqBo.getPayOrderId());
        PorderPayTransPo orderPayTransByPayOrderId = this.porderPayTransMapper.getOrderPayTransByPayOrderId(porderPayTransPo);
        if (ObjectUtils.isEmpty((Object)orderPayTransByPayOrderId)) {
            retBo.setRespCode("211004");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        WoPayNewQueryStatusReqBO woPayNewQueryStatusReqBO = new WoPayNewQueryStatusReqBO();
        woPayNewQueryStatusReqBO.setMerNo(merNo);
        woPayNewQueryStatusReqBO.setCharSet(UTF_8);
        woPayNewQueryStatusReqBO.setSignType("RSA_SHA256");
        woPayNewQueryStatusReqBO.setOrderNo(reqBo.getPayOrderId());
        woPayNewQueryStatusReqBO.setOrderDate(new SimpleDateFormat("yyyyMMdd").format(orderPayTransByPayOrderId.getCreateTime()));
        Map sortMap = UniPaySignUtilsCer.obj2NormalMap((Object)woPayNewQueryStatusReqBO);
        String sign = this.getSign(sortMap, merPrivateKeyCert, certPwd);
        woPayNewQueryStatusReqBO.setSignMsg(sign);
        Map reqMap = UniPaySignUtilsCer.obj2NormalMap((Object)woPayNewQueryStatusReqBO);
        List resultList = null;
        try {
            resultList = WoPayNewUtil.httpUrlPost(woPayNewQueryUrl, reqMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        log.debug("\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6c83\u652f\u4ed8\u8fd4\u56de\u6570\u636e-----------------------------------" + resultList);
        String resultJson = this.list2Json(resultList);
        WoPayNewQueryStatusRspBO woPayNewQueryStatusRspBO = (WoPayNewQueryStatusRspBO)JSON.parseObject((String)resultJson, WoPayNewQueryStatusRspBO.class);
        log.debug("\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6c83\u652f\u4ed8\u8fd4\u56de\u6570\u636e\u8f6c\u6362\u540e\u53c2\u6570-----------------------------------" + woPayNewQueryStatusRspBO);
        if (woPayNewQueryStatusRspBO != null && "SUCCESS".equalsIgnoreCase(woPayNewQueryStatusRspBO.getQueryResult())) {
            log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6c83\u652f\u4ed8\u5df2\u652f\u4ed8\u8ba2\u5355-----------------------------------");
            retBo.setOrderId(reqBo.getOrderId());
            retBo.setPayOrderId(reqBo.getPayOrderId());
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
            if ("1".equalsIgnoreCase(woPayNewQueryStatusRspBO.getOrderState())) {
                log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6c83\u652f\u4ed8\u6210\u529f\u8ba2\u5355-----------------------------------");
                retBo.setTradeTime(reqBo.getTradeTime());
                retBo.setRealFee(Long.valueOf(Long.parseLong(woPayNewQueryStatusRspBO.getPayAmount())));
                retBo.setTradeTime(woPayNewQueryStatusRspBO.getOrderCreateDatetime());
                retBo.setPayStatus("SUCCESS");
                retBo.setPayNotifyTransId(woPayNewQueryStatusRspBO.getPayJournl());
                retBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f");
            } else if (QUERY_STATUS_PAYING.equalsIgnoreCase(woPayNewQueryStatusRspBO.getOrderState())) {
                log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6c83\u652f\u4ed8\u5904\u7406\u4e2d\u8ba2\u5355-----------------------------------");
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg("\u7528\u6237\u652f\u4ed8\u4e2d");
            } else if (QUERY_STATUS_CLOSED.equalsIgnoreCase(woPayNewQueryStatusRspBO.getOrderState())) {
                log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6c83\u652f\u4ed8\u4ea4\u6613\u5173\u95ed\u8ba2\u5355-----------------------------------");
                retBo.setPayStatus("CLOSED");
                retBo.setPayStatusMsg("\u8ba2\u5355\u5df2\u5173\u95ed");
            } else {
                log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u6c83\u652f\u4ed8\u4ea4\u6613\u5931\u8d25-----------------------------------");
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u8ba2\u5355\u652f\u4ed8\u5931\u8d25");
            }
        } else {
            log.debug("\u8fdb\u5165\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u672a\u652f\u4ed8-----------------------------------");
            this.LOGGER.error("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8-\u67e5\u8be2\u5931\u8d25\uff1a" + woPayNewQueryStatusRspBO);
            retBo.setRespCode("211004");
            retBo.setRespDesc("\u6c83\u652f\u4ed8\u79fb\u52a8\u652f\u4ed8-\u67e5\u8be2\u5931\u8d25\uff1a" + woPayNewQueryStatusRspBO);
            return retBo;
        }
        return retBo;
    }

    public String getSign(Map<String, String> map, String certPath, String pinCode) {
        String sign = "";
        File signFile = null;
        signFile = this.fileCache.get(certPath) == null ? this.fileClient.downloadToFile(certPath) : this.fileCache.get(certPath);
        FileInputStream fis = null;
        try {
            int len;
            fis = new FileInputStream(signFile);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bb = new byte[4096];
            while ((len = fis.read(bb)) != -1) {
                baos.write(bb, 0, len);
            }
            fis.close();
            sign = UniPaySignUtilsCer.merSign(map, (String)"RSA_SHA256", (boolean)false, (byte[])baos.toByteArray(), (String)pinCode);
            this.LOGGER.info("\u6c83\u652f\u4ed8(\u65b0)\u751f\u6210\u7684\u7b7e\u540d\u4e32\u4e3a\uff1a" + sign);
            baos.close();
        }
        catch (IOException e) {
            this.LOGGER.error("\u6c83\u652f\u4ed8\uff08\u65b0\uff09\u4e0b\u5355\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return "\u6c83\u652f\u4ed8\u4e0b\u5355\u5f02\u5e38\uff1a" + e.getMessage();
        }
        return sign;
    }

    private boolean isSuccess(WoPayNewNotifyBO woPayNewNotifyBO) {
        return !StringUtils.isEmpty((Object)woPayNewNotifyBO.getTransRst()) && woPayNewNotifyBO.getTransRst().equals("1");
    }

    private boolean veriSign(Map map, String sign) {
        String base64Cer = this.payPropertiesVo.getWoPayNewBase64Cer();
        return UniPaySignUtilsCer.merVerify((Map)map, (String)"RSA_SHA256", (String)sign, (String)base64Cer, (boolean)false);
    }

    public String validateQryArg(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public static String doPost(String url, Map<String, String> map) {
        String charset = "utf-8";
        SSLClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            HttpResponse response;
            httpClient = new SSLClient();
            httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> elem : map.entrySet()) {
                list.add(new BasicNameValuePair(elem.getKey(), elem.getValue()));
            }
            if (list.size() > 0) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                entity.setContentType("application/x-www-form-urlencoded");
                httpPost.setHeader("Accept", "text/plain;charset=utf-8");
                httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private String list2Json(List<String> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : list) {
            String[] split = s.split("=", 2);
            if (split.length != 2) continue;
            map.put(split[0], split[1]);
        }
        return JSON.toJSONString(map);
    }

    private void sortQryStatusRetBo(PayAbleQryPayStatusReqBo reqBo, WoPayNewQueryStatusRspBO woPayNewQueryStatusRspBO, PayAbleQryPayStatusRspBo retBO) {
        retBO.setOrderId(reqBo.getOrderId());
        retBO.setPayOrderId(reqBo.getPayOrderId());
        retBO.setRespCode("0000");
        retBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        retBO.setTradeTime(woPayNewQueryStatusRspBO.getOrderCreateDatetime());
        retBO.setRealFee(Long.valueOf(woPayNewQueryStatusRspBO.getPayAmount()));
        retBO.setPayStatus("SUCCESS");
        retBO.setPayNotifyTransId(woPayNewQueryStatusRspBO.getPayJournl());
        retBO.setPayStatusMsg("\u652f\u4ed8\u6210\u529f\uff08\u6c83\u652f\u4ed8\uff09");
    }

    public String validateRefundArg(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap()) || reqBo.getParaMap().isEmpty()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

