/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.FileProcessing;
import com.tydic.payment.bill.busi.CheckBillFileService;
import com.tydic.payment.bill.busi.PaymentInsIdBusiService;
import com.tydic.payment.bill.busi.bo.RspInfoBO;
import com.tydic.payment.bill.comb.bo.BillCompareCreateFileReqBO;
import com.tydic.payment.bill.comb.bo.BillCompareCreateFileRsqBO;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.BusiCashierRelMapper;
import com.tydic.payment.pay.dao.PaySettleBillFileMapper;
import com.tydic.payment.pay.dao.PaySettleTransMapper;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.PaySettleBillFilePO;
import com.tydic.payment.pay.dao.po.PaySettleTransPO;
import com.tydic.payment.pay.exception.BusinessException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="checkBillFileService")
public class CheckBillFileServiceImpl
implements CheckBillFileService {
    private static final Logger log = LoggerFactory.getLogger(CheckBillFileServiceImpl.class);
    @Value(value="${ability_switch}")
    private String abilitySwitch;
    private static final String servcieType = "1";
    private static final int splitSize = 100000;
    private int qryOffset = 0;
    private static final String fileCharset = "UTF-8";
    private static String fileLocalPath = "upload";
    private static String separatorCom = ",";
    private static String changeLine = "\n";
    @Autowired
    private BusiCashierRelMapper busiCashierRelMapper;
    @Autowired
    private PaySettleTransMapper paySettleTransMapper;
    @Autowired
    private PaySettleBillFileMapper paySettleBillFileMapper;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private PaymentInsIdBusiService paymentInsIdBusiService;

    public RspInfoBO generateCheckBillFile() {
        RspInfoBO rspInfoBO = new RspInfoBO();
        log.info("\u5f00\u59cb\u751f\u6210\u6bcf\u5929\u5404\u63a5\u5165\u7cfb\u7edf\uff0c\u63a5\u5165\u65b9\u5f0f\u7684\u5bf9\u8d26\u6587\u4ef6!");
        BusiSystemInfoPO busiSystemInfo = new BusiSystemInfoPO();
        busiSystemInfo.setState(servcieType);
        List<BusiSystemInfoPO> busiSystemInfoList = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiSystemInfo);
        for (BusiSystemInfoPO systemInfo : busiSystemInfoList) {
            if (!StringUtils.isEmpty((Object)systemInfo.getBusiCode()) && !"null".equals(systemInfo.getBusiCode().trim())) continue;
        }
        rspInfoBO.setRespCode("0000");
        rspInfoBO.setRespDesc("\u6210\u529f");
        return rspInfoBO;
    }

    public BillCompareCreateFileRsqBO generateBatchCheckBillFile(BillCompareCreateFileReqBO ReqBO) {
        log.info("\u5f00\u59cb\u751f\u6210\u63a5\u5165\u7cfb\u7edfbusi_id[{}],busi_code[{}]\u7684\u5bf9\u8d26\u6587\u4ef6!", (Object)ReqBO.getBusiId(), (Object)ReqBO.getBusiCode());
        BillCompareCreateFileRsqBO rsp = new BillCompareCreateFileRsqBO();
        BillCompareCreateFileRsqBO fileRsp = new BillCompareCreateFileRsqBO();
        PaySettleTransPO paySettleTransPO = new PaySettleTransPO();
        paySettleTransPO.setBusiId(ReqBO.getBusiId());
        long billDate = ReqBO.getBillDate();
        paySettleTransPO.setBillDate(billDate);
        double page = 0.0;
        String fName = "";
        try {
            int totalCount = this.paySettleTransMapper.getCheckBy(paySettleTransPO);
            page = (double)totalCount / 100000.0 > (double)(totalCount / 100000) ? totalCount / 100000 + 1 : totalCount / 100000;
            if (page == 0.0) {
                page = 1.0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u7cfb\u7edf\u8d26\u5355\u8bb0\u5f55\u6570\u91cf\u5931\u8d25");
        }
        int startRow = 0;
        int endRow = 0;
        int i = 0;
        while ((double)i < page) {
            endRow = 100000 * (i + 1);
            fName = CheckBillFileServiceImpl.getFileName(paySettleTransPO.getBillDate(), ReqBO.getBusiCode(), i);
            fileRsp = this.processFile(paySettleTransPO, fName, startRow, i, (int)page);
            startRow = endRow;
            ++i;
        }
        rsp.setId(fileRsp.getId());
        return rsp;
    }

    private BillCompareCreateFileRsqBO processFile(PaySettleTransPO paySettleTransPO, String fName, int startRow, int no, int page) {
        BillCompareCreateFileRsqBO rsp = new BillCompareCreateFileRsqBO();
        try {
            File f;
            File file = new File(fileLocalPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if ((f = new File(file, fName)).exists()) {
                f.delete();
            }
            f.createNewFile();
            FileOutputStream fos = new FileOutputStream(f, true);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, fileCharset);
            BufferedWriter bw = new BufferedWriter(osw);
            List<PaySettleTransPO> resultList = this.queryDataList(paySettleTransPO, startRow);
            StringBuffer records = new StringBuffer();
            StringBuffer fileHead = new StringBuffer();
            fileHead.append(no);
            fileHead.append(separatorCom);
            fileHead.append(resultList.size());
            fileHead.append(separatorCom);
            String beginTime = "";
            String endTime = "";
            if (!resultList.isEmpty()) {
                beginTime = resultList.get(0).getTradeTime().substring(0, 8);
                endTime = resultList.get(resultList.size() - 1).getTradeTime().substring(0, 8);
            } else {
                beginTime = paySettleTransPO.getBillDate() + "";
                endTime = paySettleTransPO.getBillDate() + "";
            }
            fileHead.append(beginTime + "000000");
            fileHead.append(separatorCom);
            fileHead.append(endTime + "235959");
            fileHead.append(separatorCom);
            fileHead.append(page);
            bw.write(fileHead.toString());
            bw.write(changeLine);
            for (PaySettleTransPO paySettleTrans : resultList) {
                records.append(new DateTime().toString("yyyyMMdd"));
                records.append(separatorCom);
                records.append(paySettleTrans.getOrderId());
                records.append(separatorCom);
                records.append(paySettleTrans.getBusiId());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)paySettleTrans.getOrderType()) || "null".equals(paySettleTrans.getOrderType().trim()) ? "" : paySettleTrans.getOrderType());
                records.append(separatorCom);
                records.append(paySettleTrans.getPayMethod());
                records.append(separatorCom);
                records.append(paySettleTrans.getOutOrderId());
                records.append(separatorCom);
                records.append(paySettleTrans.getTotalFee());
                records.append(separatorCom);
                records.append(paySettleTrans.getRealFee());
                records.append(separatorCom);
                records.append(paySettleTrans.getDiscountFee() == null ? "" : paySettleTrans.getDiscountFee());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)paySettleTrans.getRefundNo()) || "null".equals(paySettleTrans.getRefundNo().trim()) ? "" : paySettleTrans.getRefundNo());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)paySettleTrans.getProvinceId()) || "null".equals(paySettleTrans.getProvinceId().trim()) ? "" : paySettleTrans.getProvinceId());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)paySettleTrans.getCityId()) || "null".equals(paySettleTrans.getCityId().trim()) ? "" : paySettleTrans.getCityId());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)paySettleTrans.getDistrictId()) || "null".equals(paySettleTrans.getDistrictId().trim()) ? "" : paySettleTrans.getDistrictId());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)paySettleTrans.getChannelId()) || "null".equals(paySettleTrans.getChannelId().trim()) ? "" : paySettleTrans.getChannelId());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)paySettleTrans.getCreateOperId()) || "null".equals(paySettleTrans.getCreateOperId().trim()) ? "" : paySettleTrans.getCreateOperId());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)paySettleTrans.getTradeTime()) || "null".equals(paySettleTrans.getTradeTime()) ? "" : paySettleTrans.getTradeTime());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)(paySettleTrans.getMerchantId() + "")) ? "" : paySettleTrans.getMerchantId());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)paySettleTrans.getUserAccount()) ? "" : paySettleTrans.getUserAccount());
                records.append(separatorCom);
                records.append(StringUtils.isEmpty((Object)paySettleTrans.getUserMobile()) ? "" : paySettleTrans.getUserMobile());
                bw.write(records.toString());
                bw.write(changeLine);
                records.delete(0, records.length());
            }
            bw.close();
            osw.close();
            fos.close();
            if (!f.exists()) {
                log.warn("no file, maybe no record");
                rsp.setRespDesc("no file, maybe no record");
            } else {
                if (this.abilitySwitch.equals(servcieType)) {
                    FileProcessing.uploadFileToOss((String)f.getPath(), (String)"OSS_LIQUIDATION_PAY");
                    boolean ftpFlag = this.ftpSwitch();
                    if (ftpFlag) {
                        FileProcessing.upLoadFile((File)f, (String)"", (String)"", (boolean)false);
                    }
                }
                PaySettleBillFilePO paySettleBillFile = new PaySettleBillFilePO();
                paySettleBillFile.setBusiId(paySettleTransPO.getBusiId());
                paySettleBillFile.setFileName(fName);
                paySettleBillFile.setBillDate(paySettleTransPO.getBillDate());
                List<PaySettleBillFilePO> list = this.paySettleBillFileMapper.getList(paySettleBillFile);
                Date dbDate = this.queryDBDateBusiService.getDBDate();
                if (list != null && !list.isEmpty()) {
                    PaySettleBillFilePO updatePo = list.get(0);
                    updatePo.setUploadTime(dbDate);
                    int updateById = this.paySettleBillFileMapper.updateById(updatePo);
                    rsp.setId(updatePo.getId());
                    if (updateById < 1) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff01");
                    }
                } else {
                    paySettleBillFile.setCreateTime(dbDate);
                    paySettleBillFile.setUploadFlag(servcieType);
                    paySettleBillFile.setRemark("\u5bf9\u8d26\u6587\u4ef6\u4e0a\u4f20");
                    int result = this.paySettleBillFileMapper.insert(paySettleBillFile);
                    rsp.setId(paySettleBillFile.getId());
                    if (result < 1) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u589e\u6570\u636e\u5931\u8d25\uff01");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rsp;
    }

    private List<PaySettleTransPO> queryDataList(PaySettleTransPO paySettleTransPO, int startRow) {
        log.debug("\u5f00\u59cb\u5206\u9875\u67e5\u8be2start...");
        Page page = new Page();
        page.setLimit(100000);
        page.setOffset(startRow);
        paySettleTransPO.setOrderBy("t.TRADE_TIME");
        List<PaySettleTransPO> list = this.paySettleTransMapper.getListPage((Page<PaySettleTransPO>)page, paySettleTransPO);
        log.debug("\u5f00\u59cb\u5206\u9875\u67e5\u8be2end...");
        return list;
    }

    private static String getFileName(Long billDate, String busiId, int fileNo) {
        String fileName = "";
        fileName = "yyyymmdd_\u7cfb\u7edf4\u4f4d_checkBillFile_\u5e8f\u5217\u53f74\u4f4d";
        String pattern = "0000";
        DecimalFormat df = new DecimalFormat(pattern);
        String squStr = df.format(fileNo);
        if (busiId.length() > 4) {
            busiId = busiId.substring(busiId.length() - 4);
        }
        fileName = billDate.toString() + "_" + busiId + "_checkBillFile_" + "D400_" + squStr + ".REQ";
        return fileName;
    }

    private boolean ftpSwitch() {
        return false;
    }
}

